!function(n){var c={};function l(t){if(c[t])return c[t].exports;var e=c[t]={i:t,l:!1,exports:{}};return n[t].call(e.exports,e,e.exports,l),e.l=!0,e.exports}l.m=n,l.c=c,l.d=function(t,e,n){l.o(t,e)||Object.defineProperty(t,e,{enumerable:!0,get:n})},l.r=function(t){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},l.t=function(e,t){if(1&t&&(e=l(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var n=Object.create(null);if(l.r(n),Object.defineProperty(n,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var c in e)l.d(n,c,function(t){return e[t]}.bind(null,c));return n},l.n=function(t){var e=t&&t.__esModule?function(){return t.default}:function(){return t};return l.d(e,"a",e),e},l.o=function(t,e){return Object.prototype.hasOwnProperty.call(t,e)},l.p="",l(l.s=9)}([function(module,exports){eval("module.exports = window.yoast.styledComponents;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMC5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy9leHRlcm5hbCBcIndpbmRvdy55b2FzdC5zdHlsZWRDb21wb25lbnRzXCI/NjljZiJdLCJzb3VyY2VzQ29udGVudCI6WyJtb2R1bGUuZXhwb3J0cyA9IHdpbmRvdy55b2FzdC5zdHlsZWRDb21wb25lbnRzOyJdLCJtYXBwaW5ncyI6IkFBQUEiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///0\n")},function(module,exports){eval("module.exports = React;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMS5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy9leHRlcm5hbCBcIlJlYWN0XCI/YzQ4MSJdLCJzb3VyY2VzQ29udGVudCI6WyJtb2R1bGUuZXhwb3J0cyA9IFJlYWN0OyJdLCJtYXBwaW5ncyI6IkFBQUEiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///1\n")},function(module,exports){eval("module.exports = window.yoast.propTypes;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMi5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy9leHRlcm5hbCBcIndpbmRvdy55b2FzdC5wcm9wVHlwZXNcIj81ZmMyIl0sInNvdXJjZXNDb250ZW50IjpbIm1vZHVsZS5leHBvcnRzID0gd2luZG93LnlvYXN0LnByb3BUeXBlczsiXSwibWFwcGluZ3MiOiJBQUFBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///2\n")},function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\nexports.determineFacebookImageMode = determineFacebookImageMode;\nexports.retrieveExpectedDimensions = retrieveExpectedDimensions;\nexports.calculateImageRatios = calculateImageRatios;\nexports.calculateLargestDimensions = calculateLargestDimensions;\nexports.calculateImageDimensions = calculateImageDimensions;\nexports.determineImageProperties = determineImageProperties;\nexports.handleImage = handleImage;\nconst TWITTER_IMAGE_SIZES = exports.TWITTER_IMAGE_SIZES = {\n\tsquareWidth: 125,\n\tsquareHeight: 125,\n\tlandscapeWidth: 506,\n\tlandscapeHeight: 265,\n\taspectRatio: 0.502 / 1 * 100\n};\n\nconst FACEBOOK_IMAGE_SIZES = exports.FACEBOOK_IMAGE_SIZES = {\n\tsquareWidth: 158,\n\tsquareHeight: 158,\n\tlandscapeWidth: 527,\n\tlandscapeHeight: 273,\n\tportraitWidth: 158,\n\tportraitHeight: 237,\n\taspectRatio: 0.522 / 1 * 100,\n\tlargeThreshold: { width: 446, height: 233 }\n};\n\n/**\n * Determines the image display mode for Facebook images, given its dimensions.\n *\n * @param {Object} originalDimensions The dimensions of the original image.\n *\n * @returns {string} The display mode of the image.\n */\nfunction determineFacebookImageMode(originalDimensions) {\n\tconst largeThreshold = FACEBOOK_IMAGE_SIZES.largeThreshold;\n\n\n\tif (originalDimensions.height > originalDimensions.width) {\n\t\treturn "portrait";\n\t}\n\n\tif (originalDimensions.width < largeThreshold.width || originalDimensions.height < largeThreshold.height) {\n\t\treturn "square";\n\t}\n\n\tif (originalDimensions.height === originalDimensions.width) {\n\t\treturn "square";\n\t}\n\n\treturn "landscape";\n}\n\n/**\n * Retrieves the image sizes.\n *\n * @param {string} socialMedium Facebook or Twitter.\n *\n * @returns {Object} Object containing the image sizes.\n */\nfunction retrieveExpectedDimensions(socialMedium) {\n\tif (socialMedium === "Twitter") {\n\t\treturn TWITTER_IMAGE_SIZES;\n\t}\n\n\treturn FACEBOOK_IMAGE_SIZES;\n}\n\n/**\n * Gets the dimensions of the uploaded image.\n *\n * @param {string} src The image source.\n *\n * @returns {Object} The original image dimensions.\n */\nfunction retrieveOriginalImageDimensions(src) {\n\t/* istanbul ignore next */\n\treturn new Promise((resolve, reject) => {\n\t\tconst img = new Image();\n\n\t\timg.onload = () => {\n\t\t\tresolve({\n\t\t\t\twidth: img.width,\n\t\t\t\theight: img.height\n\t\t\t});\n\t\t};\n\n\t\timg.onerror = reject;\n\n\t\timg.src = src;\n\t});\n}\n\n/**\n * Calculates the ratios of the width and height of the original image in relation to the width and\n * height of the expected image.\n *\n * When we\'re in landscape mode, we can\'t just resize to the dimensions expected by Twitter or Facebook.\n * If we\'d do so, we would end up with warped images. That\'s why we calculate the ratio between\n * the original height, and the height that is expected by Twitter or Facebook.\n * We do the same thing for width.\n * For example: an original image is 898x1600 (height x width) and Twitter expects 254x506.\n * The heightRatio would be 3.53 (898/254) and the widthRatio would be 3.16 (1600/506).\n *\n * @param {Object} expectedDimensions The dimensions of images in the social medium.\n * @param {Object} originalDimensions The dimensions of the original image.\n * @param {string} imageMode The image mode: square or landscape.\n *\n * @returns {Object} The image\'s width ratio and height ratio.\n */\nfunction calculateImageRatios(expectedDimensions, originalDimensions, imageMode) {\n\tif (imageMode === "landscape") {\n\t\treturn {\n\t\t\twidthRatio: originalDimensions.width / expectedDimensions.landscapeWidth,\n\t\t\theightRatio: originalDimensions.height / expectedDimensions.landscapeHeight\n\t\t};\n\t}\n\n\tif (imageMode === "portrait") {\n\t\treturn {\n\t\t\twidthRatio: originalDimensions.width / expectedDimensions.portraitWidth,\n\t\t\theightRatio: originalDimensions.height / expectedDimensions.portraitHeight\n\t\t};\n\t}\n\n\t// By default, the image mode is square.\n\treturn {\n\t\twidthRatio: originalDimensions.width / expectedDimensions.squareWidth,\n\t\theightRatio: originalDimensions.height / expectedDimensions.squareHeight\n\t};\n}\n\n/**\n * Calculates the largest dimensions that can be used for rendering the image.\n *\n * To use as much as the allowed space as possible, we base both dimensions on the dimension with\n * the lowest imageRatio. For example: for a 898x1600 image, the heightRatio is larger than the\n * widthRatio (see above). The result of dividing by the widthRatio is a 284x506 image.\n * The excess of 284-254 = 30 pixels will be \'cut off\' by the container in the presentation part.\n *\n * If we would divide by the heightRatio, the image would become 254x451, which means it would not\n * be wide enough for the container: there would be a 506-451=55px white border on one of the sides.\n *\n * @param {Object} originalDimensions The dimensions of the original image.\n * @param {Object} imageRatios The ratios of the width and height of the original image in relation\n *                             to the width and height of the expected image.\n *\n * @returns {Object} The width and height that the image should have as Twitter/Facebook image.\n */\nfunction calculateLargestDimensions(originalDimensions, imageRatios) {\n\tif (imageRatios.widthRatio <= imageRatios.heightRatio) {\n\t\treturn {\n\t\t\twidth: Math.round(originalDimensions.width / imageRatios.widthRatio),\n\t\t\theight: Math.round(originalDimensions.height / imageRatios.widthRatio)\n\t\t};\n\t}\n\n\treturn {\n\t\twidth: Math.round(originalDimensions.width / imageRatios.heightRatio),\n\t\theight: Math.round(originalDimensions.height / imageRatios.heightRatio)\n\t};\n}\n\n/**\n * Calculates the dimensions of the image to use as Twitter/Facebook image.\n *\n * @param {Object} expectedDimensions The dimensions of images in the social medium.\n * @param {Object} originalDimensions The dimensions of the original image.\n * @param {string} imageMode The image mode: square or landscape.\n *\n * @returns {object} The image dimensions.\n */\nfunction calculateImageDimensions(expectedDimensions, originalDimensions, imageMode) {\n\t/*\n  * If the image should be rendered as a square, and its original dimensions were also square,\n  * just use the squareWidth and squareHeight required by the social medium.\n  * We don\'t have to fear that the resulting image will be warped.\n  */\n\tif (imageMode === "square") {\n\t\tif (originalDimensions.width === originalDimensions.height) {\n\t\t\treturn {\n\t\t\t\twidth: expectedDimensions.squareWidth,\n\t\t\t\theight: expectedDimensions.squareHeight\n\t\t\t};\n\t\t}\n\n\t\t/*\n   * If the (Twitter) image should be rendered as a square, but originally wasn\'t square, crop the\n   * longest side. This way, the image won\'t be warped.\n   */\n\t\tconst imageRatiosSquare = calculateImageRatios(expectedDimensions, originalDimensions, imageMode);\n\n\t\treturn calculateLargestDimensions(originalDimensions, imageRatiosSquare);\n\t}\n\n\t/*\n  * If the image should be rendered as a landscape or portrait, crop the longest side, to reach\n  * the required size ratio. This way, the image won\'t be warped.\n  */\n\tconst imageRatiosNonSquare = calculateImageRatios(expectedDimensions, originalDimensions, imageMode);\n\n\treturn calculateLargestDimensions(originalDimensions, imageRatiosNonSquare);\n}\n\n/**\n * Determines the properties of the image.\n *\n * @param {string}  src            The source of the image.\n * @param {string}  socialMedium   Facebook or Twitter.\n * @param {Boolean} twitterIsLarge Whether twitter is the summary_card_large or not.\n *                                 False by default, because we don\'t want to pass this for Facebook.\n *\n * @returns {Promise} The promise of the imageProperties.\n */\nasync function determineImageProperties(src, socialMedium, twitterIsLarge = false) {\n\tconst originalDimensions = await retrieveOriginalImageDimensions(src);\n\n\t// Determine what image mode should be used.\n\n\t// First, set it correctly for Twitter\n\tlet imageMode = twitterIsLarge ? "landscape" : "square";\n\n\t// Override if we need the Facebook image mode.\n\tif (socialMedium === "Facebook") {\n\t\timageMode = determineFacebookImageMode(originalDimensions);\n\t}\n\n\t// Retrieve the image sizes, depending on the social medium.\n\tconst expectedDimensions = retrieveExpectedDimensions(socialMedium);\n\n\t// Calculate the image dimensions for the specific image.\n\tconst imageDimensions = calculateImageDimensions(expectedDimensions, originalDimensions, imageMode);\n\n\treturn {\n\t\tmode: imageMode,\n\t\theight: imageDimensions.height,\n\t\twidth: imageDimensions.width\n\t};\n}\n\n/**\n * Wraps the determined image properties in a neat object.\n *\n * @param {String}  src          The image URL.\n * @param {String}  socialMedium Twitter or Facebook.\n * @param {Boolean} twitterIsLarge Whether twitter is the summary_card_large or not.\n *                                 False by default, because we don\'t want to pass this for Facebook.\n *\n * @returns {Object} An object the Image components can handle.\n */\nasync function handleImage(src, socialMedium, twitterIsLarge = false) {\n\ttry {\n\t\tconst imageProperties = await determineImageProperties(src, socialMedium, twitterIsLarge);\n\t\treturn {\n\t\t\timageProperties: imageProperties,\n\t\t\tstatus: "loaded"\n\t\t};\n\t} catch (error) {\n\t\treturn {\n\t\t\timageProperties: null,\n\t\t\tstatus: "errored"\n\t\t};\n\t}\n}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///3\n')},function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _propTypes = __webpack_require__(2);\n\nvar _propTypes2 = _interopRequireDefault(_propTypes);\n\nvar _styledComponents = __webpack_require__(0);\n\nvar _styledComponents2 = _interopRequireDefault(_styledComponents);\n\nvar _FacebookSiteUrl = __webpack_require__(11);\n\nvar _FacebookSiteUrl2 = _interopRequireDefault(_FacebookSiteUrl);\n\nvar _FacebookImage = __webpack_require__(12);\n\nvar _FacebookImage2 = _interopRequireDefault(_FacebookImage);\n\nvar _FacebookTitle = __webpack_require__(14);\n\nvar _FacebookTitle2 = _interopRequireDefault(_FacebookTitle);\n\nvar _FacebookDescription = __webpack_require__(15);\n\nvar _FacebookDescription2 = _interopRequireDefault(_FacebookDescription);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n/**\n * Determines the width depending on the mode.\n *\n * @param {string} mode The mode. landscape, square, portrait.\n *\n * @returns {string} The width pixels.\n */\n\n\n/* Internal dependencies */\nconst determineTextContainerWidth = mode => {\n\tswitch (mode) {\n\t\tcase "landscape":\n\t\t\treturn "527px";\n\n\t\tcase "square":\n\t\t\treturn "369px";\n\n\t\tcase "portrait":\n\t\t\treturn "369px";\n\n\t\tdefault:\n\t\t\treturn "476px";\n\t}\n}; /* External dependencies */\n\n\nconst FacebookPreviewWrapper = _styledComponents2.default.div.withConfig({\n\tdisplayName: "FacebookPreview__FacebookPreviewWrapper",\n\tcomponentId: "sc-1nwbyjh-0"\n})(["box-sizing:border-box;display:flex;flex-direction:", ";background-color:#f2f3f5;max-width:527px;"], props => props.mode === "landscape" ? "column" : "row");\n\nconst FacebookTextWrapper = _styledComponents2.default.div.withConfig({\n\tdisplayName: "FacebookPreview__FacebookTextWrapper",\n\tcomponentId: "sc-1nwbyjh-1"\n})(["box-sizing:border-box;background-color:#f2f3f5;margin:0;padding:10px 12px;position:relative;border-bottom:", ";border-top:", ";border-right:", ";border:", ";display:flex;flex-direction:column;flex-grow:1;justify-content:", ";font-size:12px;overflow:hidden;"], props => props.mode === "landscape" ? "" : "1px solid #dddfe2", props => props.mode === "landscape" ? "" : "1px solid #dddfe2", props => props.mode === "landscape" ? "" : "1px solid #dddfe2", props => props.mode === "landscape" ? "1px solid #dddfe2" : "", props => props.mode === "landscape" ? "flex-start" : "center");\n\n/**\n * Renders FacebookPreview component.\n *\n * @param {object} props The props.\n *\n * @returns {React.Element} The rendered element.\n */\nclass FacebookPreview extends _react.Component {\n\t/**\n  * The constructor.\n  *\n  * @param {Object} props The component\'s props.\n  */\n\tconstructor(props) {\n\t\tsuper(props);\n\t\tthis.state = {\n\t\t\timageMode: null,\n\t\t\tmaxLineCount: 0,\n\t\t\tdescriptionLineCount: 0\n\t\t};\n\t\tthis.facebookTitleRef = _react2.default.createRef();\n\n\t\tthis.onImageLoaded = this.onImageLoaded.bind(this);\n\n\t\t// Binding fields to onMouseHover to prevent arrow functions in JSX props.\n\t\tthis.onImageEnter = this.props.onMouseHover.bind(this, "image");\n\t\tthis.onTitleEnter = this.props.onMouseHover.bind(this, "title");\n\t\tthis.onDescriptionEnter = this.props.onMouseHover.bind(this, "description");\n\t\tthis.onLeave = this.props.onMouseHover.bind(this, "");\n\n\t\t// Binding fields to onSelect to prevent arrow functions in JSX props. Image field is handled in onImageClick function.\n\t\tthis.onSelectTitle = this.props.onSelect.bind(this, "title");\n\t\tthis.onSelectDescription = this.props.onSelect.bind(this, "description");\n\t}\n\n\t/**\n  * Retrieves the imageMode from the Facebook image container.\n  *\n  * @param {string} mode The Facebook image mode: landscape, portrait or square.\n  *\n  * @returns {void} Void.\n  */\n\tonImageLoaded(mode) {\n\t\tthis.setState({ imageMode: mode });\n\t}\n\n\t/**\n  * Calculates the amount of lines the title spans.\n  *\n  * @returns {number} The amount of lines the title spans.\n  */\n\tgetTitleLineCount() {\n\t\tconst facebookTitleRefHeight = this.facebookTitleRef.current.offsetHeight;\n\n\t\treturn facebookTitleRefHeight / _FacebookTitle.facebookTitleLineHeight;\n\t}\n\n\t/**\n  * Sets the max line count if the image mode has been changed.\n  *\n  * @returns {void}\n  */\n\tmaybeSetMaxLineCount() {\n\t\tvar _state = this.state;\n\t\tconst imageMode = _state.imageMode,\n\t\t      maxLineCount = _state.maxLineCount;\n\n\n\t\tconst currentMaxLineCount = imageMode === "landscape" ? 2 : 5;\n\n\t\tif (currentMaxLineCount !== maxLineCount) {\n\t\t\tthis.setState({ maxLineCount: currentMaxLineCount });\n\t\t}\n\t}\n\n\t/**\n  * Sets the max description line count if the max line count has been changed.\n  *\n  * @returns {void}\n  */\n\tmaybeSetDescriptionLineCount() {\n\t\tvar _state2 = this.state;\n\t\tconst descriptionLineCount = _state2.descriptionLineCount,\n\t\t      maxLineCount = _state2.maxLineCount,\n\t\t      imageMode = _state2.imageMode;\n\n\t\tconst titleLineCount = this.getTitleLineCount();\n\n\t\t// Calculate new description line count.\n\t\tlet maxDescriptionLineCount = maxLineCount - titleLineCount;\n\t\t// Exceptions for portait image mode.\n\t\tif (imageMode === "portrait") {\n\t\t\tmaxDescriptionLineCount = titleLineCount === 5 ? 0 : 4;\n\t\t}\n\n\t\tif (maxDescriptionLineCount !== descriptionLineCount) {\n\t\t\tthis.setState({ descriptionLineCount: maxDescriptionLineCount });\n\t\t}\n\t}\n\n\t/**\n  * Component updates.\n  *\n  * @returns {void}\n  */\n\tcomponentDidUpdate() {\n\t\t// Recalculate available lines for title and description.\n\t\tthis.maybeSetMaxLineCount();\n\t\tthis.maybeSetDescriptionLineCount();\n\t}\n\n\t/**\n  * Renders the FacebookPreview.\n  *\n  * @returns {ReactComponent} Either the PlaceholderImage component, the ErrorImage component or\n  * the TwitterImageContainer.\n  */\n\trender() {\n\t\tvar _state3 = this.state;\n\t\tconst imageMode = _state3.imageMode,\n\t\t      maxLineCount = _state3.maxLineCount,\n\t\t      descriptionLineCount = _state3.descriptionLineCount;\n\n\n\t\treturn _react2.default.createElement(\n\t\t\tFacebookPreviewWrapper,\n\t\t\t{\n\t\t\t\tid: "facebookPreview",\n\t\t\t\tmode: imageMode\n\t\t\t},\n\t\t\t_react2.default.createElement(_FacebookImage2.default, {\n\t\t\t\tsrc: this.props.imageUrl || this.props.imageFallbackUrl,\n\t\t\t\talt: this.props.alt,\n\t\t\t\tonImageLoaded: this.onImageLoaded,\n\t\t\t\tonImageClick: this.props.onImageClick,\n\t\t\t\tonMouseEnter: this.onImageEnter,\n\t\t\t\tonMouseLeave: this.onLeave\n\t\t\t}),\n\t\t\t_react2.default.createElement(\n\t\t\t\tFacebookTextWrapper,\n\t\t\t\t{ mode: imageMode },\n\t\t\t\t_react2.default.createElement(_FacebookSiteUrl2.default, {\n\t\t\t\t\tsiteUrl: this.props.siteUrl,\n\t\t\t\t\tmode: imageMode\n\t\t\t\t}),\n\t\t\t\t_react2.default.createElement(\n\t\t\t\t\t_FacebookTitle2.default,\n\t\t\t\t\t{\n\t\t\t\t\t\tref: this.facebookTitleRef,\n\t\t\t\t\t\tonMouseEnter: this.onTitleEnter,\n\t\t\t\t\t\tonMouseLeave: this.onLeave,\n\t\t\t\t\t\tonClick: this.onSelectTitle,\n\t\t\t\t\t\tlineCount: maxLineCount\n\t\t\t\t\t},\n\t\t\t\t\tthis.props.title\n\t\t\t\t),\n\t\t\t\tdescriptionLineCount > 0 && _react2.default.createElement(\n\t\t\t\t\t_FacebookDescription2.default,\n\t\t\t\t\t{\n\t\t\t\t\t\tmaxWidth: determineTextContainerWidth(imageMode),\n\t\t\t\t\t\tonMouseEnter: this.onDescriptionEnter,\n\t\t\t\t\t\tonMouseLeave: this.onLeave,\n\t\t\t\t\t\tonClick: this.onSelectDescription,\n\t\t\t\t\t\tlineCount: descriptionLineCount\n\t\t\t\t\t},\n\t\t\t\t\tthis.props.description\n\t\t\t\t)\n\t\t\t)\n\t\t);\n\t}\n}\n\nFacebookPreview.propTypes = {\n\tsiteUrl: _propTypes2.default.string.isRequired,\n\ttitle: _propTypes2.default.string.isRequired,\n\tdescription: _propTypes2.default.string,\n\timageUrl: _propTypes2.default.string,\n\timageFallbackUrl: _propTypes2.default.string,\n\talt: _propTypes2.default.string,\n\tonSelect: _propTypes2.default.func,\n\tonImageClick: _propTypes2.default.func,\n\tonMouseHover: _propTypes2.default.func\n};\n\nFacebookPreview.defaultProps = {\n\tdescription: "",\n\talt: "",\n\timageUrl: "",\n\timageFallbackUrl: "",\n\tonSelect: () => {},\n\tonImageClick: () => {},\n\tonMouseHover: () => {}\n};\n\nexports.default = FacebookPreview;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///4\n')},function(module,exports){eval("module.exports = window.wp.i18n;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNS5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy9leHRlcm5hbCBcIndpbmRvdy53cC5pMThuXCI/Y2Q4ZCJdLCJzb3VyY2VzQ29udGVudCI6WyJtb2R1bGUuZXhwb3J0cyA9IHdpbmRvdy53cC5pMThuOyJdLCJtYXBwaW5ncyI6IkFBQUEiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///5\n")},function(module,exports){eval("module.exports = window.lodash;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiNi5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy9leHRlcm5hbCBcIndpbmRvdy5sb2Rhc2hcIj9hNjAxIl0sInNvdXJjZXNDb250ZW50IjpbIm1vZHVsZS5leHBvcnRzID0gd2luZG93LmxvZGFzaDsiXSwibWFwcGluZ3MiOiJBQUFBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///6\n")},function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\nexports.SocialImage = undefined;\n\nvar _propTypes = __webpack_require__(2);\n\nvar _propTypes2 = _interopRequireDefault(_propTypes);\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _styledComponents = __webpack_require__(0);\n\nvar _styledComponents2 = _interopRequireDefault(_styledComponents);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n// Adding && for specificity, competing styles coming from blockeditor.\nconst StyledImage = _styledComponents2.default.img.withConfig({\n\tdisplayName: "SocialImage__StyledImage",\n\tcomponentId: "sc-1m76ywa-0"\n})(["&&{max-width:", "px;height:", "px;position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);max-width:none;}"], props => props.width, props => props.height);\n\nconst StyledLandscapeImage = _styledComponents2.default.img.withConfig({\n\tdisplayName: "SocialImage__StyledLandscapeImage",\n\tcomponentId: "sc-1m76ywa-1"\n})(["&&{height:100%;position:absolute;width:100%;object-fit:cover;}"]);\n\nconst WrapperDiv = _styledComponents2.default.div.withConfig({\n\tdisplayName: "SocialImage__WrapperDiv",\n\tcomponentId: "sc-1m76ywa-2"\n})(["padding-bottom:", "%;"], props => props.aspectRatio);\n\n/**\n * Renders the SocialImage.\n *\n * @param {Object} props The component\'s props.\n *\n * @returns {JSX.Element} The SocialImage component.\n */\nconst SocialImage = exports.SocialImage = props => {\n\tconst imageProps = props.imageProps,\n\t      width = props.width,\n\t      height = props.height,\n\t      imageMode = props.imageMode;\n\n\n\tif (imageMode === "landscape") {\n\t\treturn _react2.default.createElement(\n\t\t\tWrapperDiv,\n\t\t\t{ aspectRatio: imageProps.aspectRatio },\n\t\t\t_react2.default.createElement(StyledLandscapeImage, { src: imageProps.src, alt: imageProps.alt })\n\t\t);\n\t}\n\n\treturn _react2.default.createElement(StyledImage, {\n\t\tsrc: imageProps.src,\n\t\talt: imageProps.alt,\n\t\twidth: width,\n\t\theight: height,\n\t\timageProperties: imageProps\n\t});\n};\n\nSocialImage.propTypes = {\n\timageProps: _propTypes2.default.shape({\n\t\tsrc: _propTypes2.default.string.isRequired,\n\t\talt: _propTypes2.default.string.isRequired,\n\t\taspectRatio: _propTypes2.default.number.isRequired\n\t}).isRequired,\n\twidth: _propTypes2.default.number.isRequired,\n\theight: _propTypes2.default.number.isRequired,\n\timageMode: _propTypes2.default.string\n};\n\nSocialImage.defaultProps = {\n\timageMode: "landscape"\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///7\n')},function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _propTypes = __webpack_require__(2);\n\nvar _propTypes2 = _interopRequireDefault(_propTypes);\n\nvar _styledComponents = __webpack_require__(0);\n\nvar _styledComponents2 = _interopRequireDefault(_styledComponents);\n\nvar _TwitterSiteUrl = __webpack_require__(16);\n\nvar _TwitterSiteUrl2 = _interopRequireDefault(_TwitterSiteUrl);\n\nvar _TwitterImage = __webpack_require__(17);\n\nvar _TwitterImage2 = _interopRequireDefault(_TwitterImage);\n\nvar _TwitterTextWrapper = __webpack_require__(18);\n\nvar _TwitterTextWrapper2 = _interopRequireDefault(_TwitterTextWrapper);\n\nvar _TwitterTitle = __webpack_require__(19);\n\nvar _TwitterTitle2 = _interopRequireDefault(_TwitterTitle);\n\nvar _TwitterDescription = __webpack_require__(20);\n\nvar _TwitterDescription2 = _interopRequireDefault(_TwitterDescription);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n/* External dependencies */\nconst TwitterPreviewWrapper = _styledComponents2.default.div.withConfig({\n\tdisplayName: "TwitterPreview__TwitterPreviewWrapper",\n\tcomponentId: "sc-16lhv3o-0"\n})(["font-family:system-ui,-apple-system,BlinkMacSystemFont,\\"Segoe UI\\",Roboto,Ubuntu,\\"Helvetica Neue\\",sans-serif;font-size:15px;font-weight:400;line-height:20px;max-width:507px;border:1px solid #E1E8ED;box-sizing:border-box;border-radius:14px;color:#292F33;background:#FFFFFF;text-overflow:ellipsis;display:flex;&:hover{background:#f5f8fa;border:1px solid rgba(136,153,166,.5);}"]);\n\n/**\n * The wrapper for the summary_large_image twitter card.\n */\n\n\n/* Internal dependencies */\nconst LargeTwitterPreviewWrapper = (0, _styledComponents2.default)(TwitterPreviewWrapper).withConfig({\n\tdisplayName: "TwitterPreview__LargeTwitterPreviewWrapper",\n\tcomponentId: "sc-16lhv3o-1"\n})(["flex-direction:column;max-height:370px;"]);\n\n/**\n * The wrapper for the summary twitter card.\n */\nconst SmallTwitterPreviewWrapper = (0, _styledComponents2.default)(TwitterPreviewWrapper).withConfig({\n\tdisplayName: "TwitterPreview__SmallTwitterPreviewWrapper",\n\tcomponentId: "sc-16lhv3o-2"\n})(["flex-direction:row;height:125px;"]);\n\n/**\n * Renders TwitterPreview component.\n *\n * @param {object} props The props.\n *\n * @returns {React.Element} The rendered element.\n */\nclass TwitterPreview extends _react.Component {\n\t/**\n  * The constructor.\n  *\n  * @param {Object} props The props.\n  *\n  * @returns {void}\n  */\n\tconstructor(props) {\n\t\tsuper(props);\n\n\t\t// Binding fields to onMouseHover to prevent arrow functions in JSX props.\n\t\tthis.onImageEnter = this.props.onMouseHover.bind(this, "image");\n\t\tthis.onTitleEnter = this.props.onMouseHover.bind(this, "title");\n\t\tthis.onDescriptionEnter = this.props.onMouseHover.bind(this, "description");\n\t\tthis.onLeave = this.props.onMouseHover.bind(this, "");\n\n\t\t// Binding fields to onSelect to prevent arrow functions in JSX props. Image field is handled in onImageClick function.\n\t\tthis.onSelectTitle = this.props.onSelect.bind(this, "title");\n\t\tthis.onSelectDescription = this.props.onSelect.bind(this, "description");\n\t}\n\n\t/**\n  * The render function.\n  *\n  * @returns {*} The rendered component.\n  */\n\trender() {\n\t\tvar _props = this.props;\n\t\tconst isLarge = _props.isLarge,\n\t\t      imageUrl = _props.imageUrl,\n\t\t      imageFallbackUrl = _props.imageFallbackUrl,\n\t\t      alt = _props.alt,\n\t\t      title = _props.title,\n\t\t      description = _props.description,\n\t\t      siteUrl = _props.siteUrl;\n\n\n\t\tconst Wrapper = isLarge ? LargeTwitterPreviewWrapper : SmallTwitterPreviewWrapper;\n\n\t\treturn _react2.default.createElement(\n\t\t\tWrapper,\n\t\t\t{ id: "twitterPreview" },\n\t\t\t_react2.default.createElement(_TwitterImage2.default, {\n\t\t\t\tsrc: imageUrl || imageFallbackUrl,\n\t\t\t\talt: alt,\n\t\t\t\tisLarge: isLarge,\n\t\t\t\tonImageClick: this.props.onImageClick,\n\t\t\t\tonMouseEnter: this.onImageEnter,\n\t\t\t\tonMouseLeave: this.onLeave\n\t\t\t}),\n\t\t\t_react2.default.createElement(\n\t\t\t\t_TwitterTextWrapper2.default,\n\t\t\t\tnull,\n\t\t\t\t_react2.default.createElement(_TwitterSiteUrl2.default, { siteUrl: siteUrl }),\n\t\t\t\t_react2.default.createElement(\n\t\t\t\t\t_TwitterTitle2.default,\n\t\t\t\t\t{\n\t\t\t\t\t\tonMouseEnter: this.onTitleEnter,\n\t\t\t\t\t\tonMouseLeave: this.onLeave,\n\t\t\t\t\t\tonClick: this.onSelectTitle\n\t\t\t\t\t},\n\t\t\t\t\ttitle\n\t\t\t\t),\n\t\t\t\t_react2.default.createElement(\n\t\t\t\t\t_TwitterDescription2.default,\n\t\t\t\t\t{\n\t\t\t\t\t\tonMouseEnter: this.onDescriptionEnter,\n\t\t\t\t\t\tonMouseLeave: this.onLeave,\n\t\t\t\t\t\tonClick: this.onSelectDescription\n\t\t\t\t\t},\n\t\t\t\t\tdescription\n\t\t\t\t)\n\t\t\t)\n\t\t);\n\t}\n}\n\nTwitterPreview.propTypes = {\n\tsiteUrl: _propTypes2.default.string.isRequired,\n\ttitle: _propTypes2.default.string.isRequired,\n\tdescription: _propTypes2.default.string,\n\tisLarge: _propTypes2.default.bool,\n\timageUrl: _propTypes2.default.string,\n\timageFallbackUrl: _propTypes2.default.string,\n\talt: _propTypes2.default.string,\n\tonSelect: _propTypes2.default.func,\n\tonImageClick: _propTypes2.default.func,\n\tonMouseHover: _propTypes2.default.func\n};\n\nTwitterPreview.defaultProps = {\n\tdescription: "",\n\talt: "",\n\timageUrl: "",\n\timageFallbackUrl: "",\n\tonSelect: () => {},\n\tonImageClick: () => {},\n\tonMouseHover: () => {},\n\tisLarge: true\n};\n\nexports.default = TwitterPreview;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///8\n')},function(module,exports,__webpack_require__){"use strict";eval("\n\nwindow.yoast = window.yoast || {};\nwindow.yoast.socialMetadataPreviews = __webpack_require__(10);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiOS5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy9hc3NldHMvanMvc3JjL2V4dGVybmFscy95b2FzdC9zb2NpYWwtbWV0YWRhdGEtcHJldmlld3MuanM/ZDIyZSJdLCJzb3VyY2VzQ29udGVudCI6WyJ3aW5kb3cueW9hc3QgPSB3aW5kb3cueW9hc3QgfHwge307XG53aW5kb3cueW9hc3Quc29jaWFsTWV0YWRhdGFQcmV2aWV3cyA9IHJlcXVpcmUoIFwiQHlvYXN0L3NvY2lhbC1tZXRhZGF0YS1wcmV2aWV3c1wiICk7XG4iXSwibWFwcGluZ3MiOiI7O0FBQUE7QUFDQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///9\n")},function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n  value: true\n});\n\nvar _FacebookPreview = __webpack_require__(4);\n\nObject.defineProperty(exports, "FacebookPreview", {\n  enumerable: true,\n  get: function get() {\n    return _interopRequireDefault(_FacebookPreview).default;\n  }\n});\n\nvar _TwitterPreview = __webpack_require__(8);\n\nObject.defineProperty(exports, "TwitterPreview", {\n  enumerable: true,\n  get: function get() {\n    return _interopRequireDefault(_TwitterPreview).default;\n  }\n});\n\nvar _SocialPreviewEditor = __webpack_require__(21);\n\nObject.defineProperty(exports, "SocialPreviewEditor", {\n  enumerable: true,\n  get: function get() {\n    return _interopRequireDefault(_SocialPreviewEditor).default;\n  }\n});\n\nvar _determineImageProperties = __webpack_require__(3);\n\nObject.defineProperty(exports, "TWITTER_IMAGE_SIZES", {\n  enumerable: true,\n  get: function get() {\n    return _determineImageProperties.TWITTER_IMAGE_SIZES;\n  }\n});\nObject.defineProperty(exports, "FACEBOOK_IMAGE_SIZES", {\n  enumerable: true,\n  get: function get() {\n    return _determineImageProperties.FACEBOOK_IMAGE_SIZES;\n  }\n});\nObject.defineProperty(exports, "determineFacebookImageMode", {\n  enumerable: true,\n  get: function get() {\n    return _determineImageProperties.determineFacebookImageMode;\n  }\n});\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTAuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vbm9kZV9tb2R1bGVzL0B5b2FzdC9zb2NpYWwtbWV0YWRhdGEtcHJldmlld3Mvc3JjL2luZGV4LmpzPzNiZGMiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IHsgZGVmYXVsdCBhcyBGYWNlYm9va1ByZXZpZXcgfSBmcm9tIFwiLi9mYWNlYm9vay9GYWNlYm9va1ByZXZpZXdcIjtcbmV4cG9ydCB7IGRlZmF1bHQgYXMgVHdpdHRlclByZXZpZXcgfSBmcm9tIFwiLi90d2l0dGVyL1R3aXR0ZXJQcmV2aWV3XCI7XG5leHBvcnQgeyBkZWZhdWx0IGFzIFNvY2lhbFByZXZpZXdFZGl0b3IgfSBmcm9tIFwiLi9lZGl0b3IvU29jaWFsUHJldmlld0VkaXRvclwiO1xuZXhwb3J0IHsgVFdJVFRFUl9JTUFHRV9TSVpFUywgRkFDRUJPT0tfSU1BR0VfU0laRVMsIGRldGVybWluZUZhY2Vib29rSW1hZ2VNb2RlIH0gZnJvbSBcIi4vaGVscGVycy9kZXRlcm1pbmVJbWFnZVByb3BlcnRpZXNcIjtcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7QUFBQTs7Ozs7Ozs7O0FBQ0E7Ozs7Ozs7OztBQUNBOzs7Ozs7Ozs7QUFDQTs7Ozs7O0FBQUE7Ozs7OztBQUFBOzs7O0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///10\n')},function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _styledComponents = __webpack_require__(0);\n\nvar _styledComponents2 = _interopRequireDefault(_styledComponents);\n\nvar _propTypes = __webpack_require__(2);\n\nvar _propTypes2 = _interopRequireDefault(_propTypes);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nconst FacebookSiteUrlWrapper = _styledComponents2.default.p.withConfig({\n\tdisplayName: "FacebookSiteUrl__FacebookSiteUrlWrapper",\n\tcomponentId: "sc-109exs2-0"\n})(["color:#606770;flex-shrink:0;font-size:12px;line-height:16px;overflow:hidden;padding:0;text-overflow:ellipsis;text-transform:uppercase;white-space:nowrap;margin:0;position:", ";"], props => props.mode === "landscape" ? "relative" : "static");\n\n/**\n * Renders a FacebookSiteUrl component.\n *\n * @param {object} props The props.\n * @param {string} props.siteUrl The site url.\n *\n * @returns {React.Element} The rendered element.\n */\n/* External dependencies */\nconst FacebookSiteUrlComponent = props => {\n\tconst siteUrl = props.siteUrl;\n\n\n\treturn _react2.default.createElement(\n\t\t_react.Fragment,\n\t\tnull,\n\t\t_react2.default.createElement(\n\t\t\t"span",\n\t\t\t{ className: "screen-reader-text" },\n\t\t\tsiteUrl\n\t\t),\n\t\t_react2.default.createElement(\n\t\t\tFacebookSiteUrlWrapper,\n\t\t\t{ "aria-hidden": "true" },\n\t\t\t_react2.default.createElement(\n\t\t\t\t"span",\n\t\t\t\tnull,\n\t\t\t\tsiteUrl\n\t\t\t)\n\t\t)\n\t);\n};\n\nFacebookSiteUrlComponent.propTypes = {\n\tsiteUrl: _propTypes2.default.string.isRequired\n};\n\nexports.default = FacebookSiteUrlComponent;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///11\n')},function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _styledComponents = __webpack_require__(0);\n\nvar _styledComponents2 = _interopRequireDefault(_styledComponents);\n\nvar _propTypes = __webpack_require__(2);\n\nvar _propTypes2 = _interopRequireDefault(_propTypes);\n\nvar _i18n = __webpack_require__(5);\n\nvar _lodash = __webpack_require__(6);\n\nvar _styleGuide = __webpack_require__(13);\n\nvar _SocialImage = __webpack_require__(7);\n\nvar _determineImageProperties = __webpack_require__(3);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n/* Internal dependencies */\n/* External dependencies */\nconst FacebookImageContainer = _styledComponents2.default.div.withConfig({\n\tdisplayName: "FacebookImage__FacebookImageContainer",\n\tcomponentId: "sc-n8g3py-0"\n})(["position:relative;", ";overflow:hidden;background-color:", ";"], props => props.mode === "landscape" ? `max-width: ${props.dimensions.width}` : `min-width: ${props.dimensions.width}; height: ${props.dimensions.height}`, _styleGuide.colors.$color_white);\n\n/* Yoast dependencies */\n\n\nconst PlaceholderImage = _styledComponents2.default.div.withConfig({\n\tdisplayName: "FacebookImage__PlaceholderImage",\n\tcomponentId: "sc-n8g3py-1"\n})(["box-sizing:border-box;max-width:", "px;height:", "px;background-color:", ";border-style:dashed;border-width:1px;color:#006DAC;background-color:#f1f1f1;display:flex;justify-content:center;align-items:center;text-decoration:underline;font-size:14px;cursor:pointer;"], _determineImageProperties.FACEBOOK_IMAGE_SIZES.landscapeWidth, _determineImageProperties.FACEBOOK_IMAGE_SIZES.landscapeHeight, _styleGuide.colors.$color_grey);\n\n/**\n * Renders the FacebookImage component.\n *\n * @param {string} src The image source.\n *\n * @returns {ReactComponent} The FacebookImage component.\n */\nclass FacebookImage extends _react.Component {\n\t/**\n  * The constructor.\n  *\n  * @param {Object} props The component\'s props.\n  */\n\tconstructor(props) {\n\t\tsuper(props);\n\t\tthis.state = {\n\t\t\timageProperties: null,\n\t\t\tstatus: "loading"\n\t\t};\n\t\tthis.socialMedium = "Facebook";\n\t\tthis.handleFacebookImage = this.handleFacebookImage.bind(this);\n\t\tthis.setState = this.setState.bind(this);\n\t}\n\n\t/**\n  * Handles setting the handled image properties on the state.\n  *\n  * @returns {void}\n  */\n\tasync handleFacebookImage() {\n\t\ttry {\n\t\t\tconst newState = await (0, _determineImageProperties.handleImage)(this.props.src, this.socialMedium);\n\t\t\tthis.setState(newState);\n\t\t\tthis.props.onImageLoaded(newState.imageProperties.mode || "landscape");\n\t\t} catch (error) {\n\t\t\tthis.setState(error);\n\t\t\tthis.props.onImageLoaded("landscape");\n\t\t}\n\t}\n\n\t/**\n  * React Lifecycle method that is called after the component updates.\n  *\n  * @param {Object} prevProps The props.\n  *\n  * @returns {Object} The new props.\n  */\n\tcomponentDidUpdate(prevProps) {\n\t\t// Only perform calculations on the image if the src has actually changed.\n\t\tif (prevProps.src !== this.props.src) {\n\t\t\tthis.handleFacebookImage();\n\t\t}\n\t}\n\n\t/**\n  * Determine the image properties and set them in state.\n  *\n  * @param {string} src The image source URL.\n  *\n  * @returns {void}\n  */\n\tcomponentDidMount() {\n\t\tthis.handleFacebookImage();\n\t}\n\n\t/**\n  * Retrieves the dimensions for the Facebook image container.\n  *\n  * @param {string} imageMode The Facebook image mode: landscape, portrait or square.\n  *\n  * @returns {Object} The width and height for the container.\n  */\n\tretrieveContainerDimensions(imageMode) {\n\t\tswitch (imageMode) {\n\t\t\tcase "square":\n\t\t\t\treturn {\n\t\t\t\t\theight: _determineImageProperties.FACEBOOK_IMAGE_SIZES.squareHeight + "px",\n\t\t\t\t\twidth: _determineImageProperties.FACEBOOK_IMAGE_SIZES.squareWidth + "px"\n\t\t\t\t};\n\t\t\tcase "portrait":\n\t\t\t\treturn {\n\t\t\t\t\theight: _determineImageProperties.FACEBOOK_IMAGE_SIZES.portraitHeight + "px",\n\t\t\t\t\twidth: _determineImageProperties.FACEBOOK_IMAGE_SIZES.portraitWidth + "px"\n\t\t\t\t};\n\t\t\tcase "landscape":\n\t\t\t\treturn {\n\t\t\t\t\theight: _determineImageProperties.FACEBOOK_IMAGE_SIZES.landscapeHeight + "px",\n\t\t\t\t\twidth: _determineImageProperties.FACEBOOK_IMAGE_SIZES.landscapeWidth + "px"\n\t\t\t\t};\n\t\t}\n\t}\n\n\t/**\n  * Renders the FacebookImage.\n  *\n  * @returns {ReactComponent} Either the ErrorImage component or the FacebookImageContainer.\n  */\n\trender() {\n\t\tvar _state = this.state;\n\t\tconst imageProperties = _state.imageProperties,\n\t\t      status = _state.status;\n\n\n\t\tif (status === "loading" || this.props.src === "" || status === "errored") {\n\t\t\treturn _react2.default.createElement(\n\t\t\t\tPlaceholderImage,\n\t\t\t\t{\n\t\t\t\t\tonClick: this.props.onImageClick,\n\t\t\t\t\tonMouseEnter: this.props.onMouseEnter,\n\t\t\t\t\tonMouseLeave: this.props.onMouseLeave\n\t\t\t\t},\n\t\t\t\t(0, _i18n.__)("Select image", "wordpress-seo")\n\t\t\t);\n\t\t}\n\n\t\tconst containerDimensions = this.retrieveContainerDimensions(imageProperties.mode);\n\t\treturn _react2.default.createElement(\n\t\t\tFacebookImageContainer,\n\t\t\t{\n\t\t\t\tmode: imageProperties.mode,\n\t\t\t\tdimensions: containerDimensions,\n\t\t\t\tonMouseEnter: this.props.onMouseEnter,\n\t\t\t\tonMouseLeave: this.props.onMouseLeave,\n\t\t\t\tonClick: this.props.onImageClick\n\t\t\t},\n\t\t\t_react2.default.createElement(_SocialImage.SocialImage, {\n\t\t\t\timageProps: {\n\t\t\t\t\tsrc: this.props.src,\n\t\t\t\t\talt: this.props.alt,\n\t\t\t\t\taspectRatio: _determineImageProperties.FACEBOOK_IMAGE_SIZES.aspectRatio\n\t\t\t\t},\n\t\t\t\twidth: imageProperties.width,\n\t\t\t\theight: imageProperties.height,\n\t\t\t\timageMode: imageProperties.mode\n\t\t\t})\n\t\t);\n\t}\n}\n\nFacebookImage.propTypes = {\n\tsrc: _propTypes2.default.string,\n\talt: _propTypes2.default.string,\n\tonImageLoaded: _propTypes2.default.func,\n\tonImageClick: _propTypes2.default.func,\n\tonMouseEnter: _propTypes2.default.func,\n\tonMouseLeave: _propTypes2.default.func\n};\n\nFacebookImage.defaultProps = {\n\tsrc: "",\n\talt: "",\n\tonImageLoaded: _lodash.noop,\n\tonImageClick: _lodash.noop,\n\tonMouseEnter: _lodash.noop,\n\tonMouseLeave: _lodash.noop\n};\n\nexports.default = FacebookImage;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///12\n')},function(module,exports){eval("module.exports = window.yoast.styleGuide;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vZXh0ZXJuYWwgXCJ3aW5kb3cueW9hc3Quc3R5bGVHdWlkZVwiP2RlZjkiXSwic291cmNlc0NvbnRlbnQiOlsibW9kdWxlLmV4cG9ydHMgPSB3aW5kb3cueW9hc3Quc3R5bGVHdWlkZTsiXSwibWFwcGluZ3MiOiJBQUFBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///13\n")},function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\nexports.facebookTitleLineHeight = undefined;\n\nvar _styledComponents = __webpack_require__(0);\n\nvar _styledComponents2 = _interopRequireDefault(_styledComponents);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n// Used to make sure the element also has a height when empty by setting min-height equal to line-height.\nconst facebookTitleLineHeight = exports.facebookTitleLineHeight = 20; /* External dependencies */\n\n\nconst FacebookTitle = _styledComponents2.default.span.withConfig({\n\tdisplayName: "FacebookTitle",\n\tcomponentId: "sc-1cm5c6b-0"\n})(["line-height:", "px;min-height:", "px;color:#1d2129;font-weight:600;overflow:hidden;font-size:16px;margin:3px 0 0;letter-spacing:normal;white-space:normal;flex-shrink:0;cursor:pointer;display:-webkit-box;-webkit-line-clamp:", ";-webkit-box-orient:vertical;overflow:hidden;"], facebookTitleLineHeight, facebookTitleLineHeight, props => props.lineCount);\n\nexports.default = FacebookTitle;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTQuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vbm9kZV9tb2R1bGVzL0B5b2FzdC9zb2NpYWwtbWV0YWRhdGEtcHJldmlld3Mvc3JjL2ZhY2Vib29rL0ZhY2Vib29rVGl0bGUuanM/YzYwOCJdLCJzb3VyY2VzQ29udGVudCI6WyIvKiBFeHRlcm5hbCBkZXBlbmRlbmNpZXMgKi9cbmltcG9ydCBzdHlsZWQgZnJvbSBcInN0eWxlZC1jb21wb25lbnRzXCI7XG5cbi8vIFVzZWQgdG8gbWFrZSBzdXJlIHRoZSBlbGVtZW50IGFsc28gaGFzIGEgaGVpZ2h0IHdoZW4gZW1wdHkgYnkgc2V0dGluZyBtaW4taGVpZ2h0IGVxdWFsIHRvIGxpbmUtaGVpZ2h0LlxuZXhwb3J0IGNvbnN0IGZhY2Vib29rVGl0bGVMaW5lSGVpZ2h0ID0gMjA7XG5cbmNvbnN0IEZhY2Vib29rVGl0bGUgPSBzdHlsZWQuc3BhbmBcblx0bGluZS1oZWlnaHQ6ICR7IGZhY2Vib29rVGl0bGVMaW5lSGVpZ2h0IH1weDtcblx0bWluLWhlaWdodCA6ICR7IGZhY2Vib29rVGl0bGVMaW5lSGVpZ2h0IH1weDtcblx0Y29sb3I6ICMxZDIxMjk7XG5cdGZvbnQtd2VpZ2h0OiA2MDA7XG5cdG92ZXJmbG93OiBoaWRkZW47XG5cdGZvbnQtc2l6ZTogMTZweDtcblx0bWFyZ2luOiAzcHggMCAwO1xuXHRsZXR0ZXItc3BhY2luZzogbm9ybWFsO1xuXHR3aGl0ZS1zcGFjZTogbm9ybWFsO1xuXHRmbGV4LXNocmluazogMDtcblx0Y3Vyc29yOiBwb2ludGVyO1xuXHRkaXNwbGF5OiAtd2Via2l0LWJveDtcblx0LXdlYmtpdC1saW5lLWNsYW1wOiAkeyBwcm9wcyA9PiAoIHByb3BzLmxpbmVDb3VudCApIH07XG5cdC13ZWJraXQtYm94LW9yaWVudDogdmVydGljYWw7XG5cdG92ZXJmbG93OiBoaWRkZW47XG5gO1xuXG5leHBvcnQgZGVmYXVsdCBGYWNlYm9va1RpdGxlO1xuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQ0E7QUFDQTs7Ozs7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFpQkEiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///14\n')},function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\n\nvar _styledComponents = __webpack_require__(0);\n\nvar _styledComponents2 = _interopRequireDefault(_styledComponents);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n// Used to make sure the element also has a height when empty by setting min-height equal to line-height.\nconst descriptionLineHeight = 16;\n\n/**\n * Renders a FacebookDescription component.\n *\n * @param {props} props props.\n *\n * @returns {React.Component} The rendered element.\n */\n/* External dependencies */\nconst FacebookDescription = _styledComponents2.default.p.withConfig({\n\tdisplayName: "FacebookDescription",\n\tcomponentId: "sc-ulm5bh-0"\n})(["line-height:", "px;min-height:", "px;color:#606770;font-size:14px;padding:0;text-overflow:ellipsis;margin:3px 0 0 0;display:-webkit-box;cursor:pointer;-webkit-line-clamp:", ";-webkit-box-orient:vertical;overflow:hidden;@media all and ( max-width:", " ){display:none;}"], descriptionLineHeight, descriptionLineHeight, props => props.lineCount, props => props.maxWidth);\n\nexports.default = FacebookDescription;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTUuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vbm9kZV9tb2R1bGVzL0B5b2FzdC9zb2NpYWwtbWV0YWRhdGEtcHJldmlld3Mvc3JjL2ZhY2Vib29rL0ZhY2Vib29rRGVzY3JpcHRpb24uanM/YTI3OSJdLCJzb3VyY2VzQ29udGVudCI6WyIvKiBFeHRlcm5hbCBkZXBlbmRlbmNpZXMgKi9cbmltcG9ydCBzdHlsZWQgZnJvbSBcInN0eWxlZC1jb21wb25lbnRzXCI7XG5cbi8vIFVzZWQgdG8gbWFrZSBzdXJlIHRoZSBlbGVtZW50IGFsc28gaGFzIGEgaGVpZ2h0IHdoZW4gZW1wdHkgYnkgc2V0dGluZyBtaW4taGVpZ2h0IGVxdWFsIHRvIGxpbmUtaGVpZ2h0LlxuY29uc3QgZGVzY3JpcHRpb25MaW5lSGVpZ2h0ID0gMTY7XG5cbi8qKlxuICogUmVuZGVycyBhIEZhY2Vib29rRGVzY3JpcHRpb24gY29tcG9uZW50LlxuICpcbiAqIEBwYXJhbSB7cHJvcHN9IHByb3BzIHByb3BzLlxuICpcbiAqIEByZXR1cm5zIHtSZWFjdC5Db21wb25lbnR9IFRoZSByZW5kZXJlZCBlbGVtZW50LlxuICovXG5jb25zdCBGYWNlYm9va0Rlc2NyaXB0aW9uID0gc3R5bGVkLnBgXG5cdGxpbmUtaGVpZ2h0OiAkeyBkZXNjcmlwdGlvbkxpbmVIZWlnaHQgfXB4O1xuXHRtaW4taGVpZ2h0IDogJHsgZGVzY3JpcHRpb25MaW5lSGVpZ2h0IH1weDtcblx0Y29sb3I6ICM2MDY3NzA7XG5cdGZvbnQtc2l6ZTogMTRweDtcblx0cGFkZGluZzogMDtcblx0dGV4dC1vdmVyZmxvdzogZWxsaXBzaXM7XG5cdG1hcmdpbjogM3B4IDAgMCAwO1xuXHRkaXNwbGF5OiAtd2Via2l0LWJveDtcblx0Y3Vyc29yOiBwb2ludGVyO1xuXHQtd2Via2l0LWxpbmUtY2xhbXA6ICR7IHByb3BzID0+ICggcHJvcHMubGluZUNvdW50ICkgfTtcblx0LXdlYmtpdC1ib3gtb3JpZW50OiB2ZXJ0aWNhbDtcblx0b3ZlcmZsb3c6IGhpZGRlbjtcblxuXHRAbWVkaWEgYWxsIGFuZCAoIG1heC13aWR0aDogJHsgcHJvcHMgPT4gcHJvcHMubWF4V2lkdGggfSApIHtcblx0XHRkaXNwbGF5OiBub25lO1xuXHR9XG5gO1xuXG5leHBvcnQgZGVmYXVsdCBGYWNlYm9va0Rlc2NyaXB0aW9uO1xuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQTtBQUNBOzs7OztBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7Ozs7O0FBTkE7QUFhQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBa0JBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///15\n')},function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _styledComponents = __webpack_require__(0);\n\nvar _styledComponents2 = _interopRequireDefault(_styledComponents);\n\nvar _propTypes = __webpack_require__(2);\n\nvar _propTypes2 = _interopRequireDefault(_propTypes);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n/**\n * Paragraph that contains the TwitterSiteUrl and the icon.\n */\nconst TwitterSiteUrlWrapper = _styledComponents2.default.div.withConfig({\n\tdisplayName: "TwitterSiteUrl__TwitterSiteUrlWrapper",\n\tcomponentId: "sc-y2m51b-0"\n})(["text-transform:lowercase;color:rgb(83,100,113);white-space:nowrap;overflow:hidden;text-overflow:ellipsis;margin:0;fill:currentcolor;display:flex;flex-direction:row;align-items:flex-end;"]);\n\n/**\n * Renders a TwitterSiteUrl component.\n *\n * @param {object} props The props.\n *\n * @returns {React.Element} The rendered element.\n */\n/* External dependencies */\nconst TwitterSiteUrl = props => {\n\treturn _react2.default.createElement(\n\t\tTwitterSiteUrlWrapper,\n\t\tnull,\n\t\t_react2.default.createElement(\n\t\t\t"span",\n\t\t\tnull,\n\t\t\tprops.siteUrl\n\t\t)\n\t);\n};\n\nTwitterSiteUrl.propTypes = {\n\tsiteUrl: _propTypes2.default.string.isRequired\n};\n\nexports.default = TwitterSiteUrl;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTYuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vbm9kZV9tb2R1bGVzL0B5b2FzdC9zb2NpYWwtbWV0YWRhdGEtcHJldmlld3Mvc3JjL3R3aXR0ZXIvVHdpdHRlclNpdGVVcmwuanM/YTVjNiJdLCJzb3VyY2VzQ29udGVudCI6WyIvKiBFeHRlcm5hbCBkZXBlbmRlbmNpZXMgKi9cbmltcG9ydCBSZWFjdCBmcm9tIFwicmVhY3RcIjtcbmltcG9ydCBzdHlsZWQgZnJvbSBcInN0eWxlZC1jb21wb25lbnRzXCI7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gXCJwcm9wLXR5cGVzXCI7XG5cbi8qKlxuICogUGFyYWdyYXBoIHRoYXQgY29udGFpbnMgdGhlIFR3aXR0ZXJTaXRlVXJsIGFuZCB0aGUgaWNvbi5cbiAqL1xuY29uc3QgVHdpdHRlclNpdGVVcmxXcmFwcGVyID0gc3R5bGVkLmRpdmBcblx0dGV4dC10cmFuc2Zvcm06IGxvd2VyY2FzZTtcblx0Y29sb3I6IHJnYig4MywgMTAwLCAxMTMpO1xuXHR3aGl0ZS1zcGFjZTogbm93cmFwO1xuXHRvdmVyZmxvdzogaGlkZGVuO1xuXHR0ZXh0LW92ZXJmbG93OiBlbGxpcHNpcztcblx0bWFyZ2luOiAwO1xuXHRmaWxsOiBjdXJyZW50Y29sb3I7XG5cdGRpc3BsYXk6IGZsZXg7XG5cdGZsZXgtZGlyZWN0aW9uOiByb3c7XG5cdGFsaWduLWl0ZW1zOiBmbGV4LWVuZDtcbmA7XG5cbi8qKlxuICogUmVuZGVycyBhIFR3aXR0ZXJTaXRlVXJsIGNvbXBvbmVudC5cbiAqXG4gKiBAcGFyYW0ge29iamVjdH0gcHJvcHMgVGhlIHByb3BzLlxuICpcbiAqIEByZXR1cm5zIHtSZWFjdC5FbGVtZW50fSBUaGUgcmVuZGVyZWQgZWxlbWVudC5cbiAqL1xuY29uc3QgVHdpdHRlclNpdGVVcmwgPSAoIHByb3BzICkgPT4ge1xuXHRyZXR1cm4gKFxuXHRcdDxUd2l0dGVyU2l0ZVVybFdyYXBwZXI+XG5cdFx0XHQ8c3Bhbj57IHByb3BzLnNpdGVVcmwgfTwvc3Bhbj5cblx0XHQ8L1R3aXR0ZXJTaXRlVXJsV3JhcHBlcj5cblx0KTtcbn07XG5cblR3aXR0ZXJTaXRlVXJsLnByb3BUeXBlcyA9IHtcblx0c2l0ZVVybDogUHJvcFR5cGVzLnN0cmluZy5pc1JlcXVpcmVkLFxufTtcblxuZXhwb3J0IGRlZmF1bHQgVHdpdHRlclNpdGVVcmw7XG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUNBO0FBQ0E7OztBQUFBO0FBQ0E7OztBQUFBO0FBQ0E7Ozs7O0FBQ0E7OztBQUdBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFZQTs7Ozs7OztBQXJCQTtBQTRCQTtBQUNBO0FBQ0E7QUFBQTtBQUNBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFEQTtBQUlBO0FBQ0E7QUFDQTtBQUNBO0FBREE7QUFDQTtBQUdBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///16\n')},function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _styledComponents = __webpack_require__(0);\n\nvar _styledComponents2 = _interopRequireDefault(_styledComponents);\n\nvar _propTypes = __webpack_require__(2);\n\nvar _propTypes2 = _interopRequireDefault(_propTypes);\n\nvar _i18n = __webpack_require__(5);\n\nvar _lodash = __webpack_require__(6);\n\nvar _SocialImage = __webpack_require__(7);\n\nvar _determineImageProperties = __webpack_require__(3);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n/**\n * Will set height, width, and border properties on the image container as required by the summary/summary_large_image cards.\n *\n * @param {boolean} isLarge Whether this is the summary_large_image or regular summary card.\n * @param {boolean} border  Whether this image should have appropriate border styles, or no border;\n *\n * @returns {string} A string containing relevant css settings.\n */\n\n\n/* Internal dependencies */\nconst injectCardDependentStyles = (isLarge, border = true) => {\n\tif (isLarge) {\n\t\treturn `\n\t\t\tmax-width: ${_determineImageProperties.TWITTER_IMAGE_SIZES.landscapeWidth}px;\n\t\t\t${border ? "border-bottom: 1px solid #E1E8ED;" : ""}\n\t\t\tborder-radius: 14px 14px 0 0;\n\t\t\t`;\n\t}\n\treturn `\n\t\twidth: ${_determineImageProperties.TWITTER_IMAGE_SIZES.squareWidth}px;\n\t\t${border ? "border-right: 1px solid #E1E8ED;" : ""}\n\t\tborder-radius: 14px 0 0 14px;\n\t\t`;\n}; /* External dependencies */\n\n\nconst TwitterImageContainer = _styledComponents2.default.div.withConfig({\n\tdisplayName: "TwitterImage__TwitterImageContainer",\n\tcomponentId: "sc-y3dnut-0"\n})(["position:relative;box-sizing:content-box;overflow:hidden;background-color:#e1e8ed;flex-shrink:0;", ""], props => injectCardDependentStyles(props.isLarge));\n\nconst BaseImage = _styledComponents2.default.div.withConfig({\n\tdisplayName: "TwitterImage__BaseImage",\n\tcomponentId: "sc-y3dnut-1"\n})(["display:flex;justify-content:center;align-items:center;box-sizing:border-box;max-width:100%;margin:0;padding:1em;text-align:center;font-size:1rem;", ""], props => injectCardDependentStyles(props.isLarge, false));\n\nconst PlaceholderImage = (0, _styledComponents2.default)(BaseImage).withConfig({\n\tdisplayName: "TwitterImage__PlaceholderImage",\n\tcomponentId: "sc-y3dnut-2"\n})(["", " border-top-left-radius:14px;", ":14px;border-style:dashed;border-width:1px;color:#006DAC;background-color:#f1f1f1;text-decoration:underline;font-size:14px;cursor:pointer;"], props => props.isLarge && `height: ${_determineImageProperties.TWITTER_IMAGE_SIZES.landscapeHeight}px;`, props => props.isLarge ? "border-top-right-radius" : "border-bottom-left-radius");\n\n/**\n * Renders the TwitterImage component.\n *\n * @param {string} src The image source.\n *\n * @returns {ReactComponent} The TwitterImage component.\n */\nclass TwitterImage extends _react2.default.Component {\n\t/**\n  * The constructor.\n  *\n  * @param {Object} props The component\'s props.\n  */\n\tconstructor(props) {\n\t\tsuper(props);\n\t\tthis.state = {\n\t\t\tstatus: "loading"\n\t\t};\n\n\t\tthis.socialMedium = "Twitter";\n\t\tthis.handleTwitterImage = this.handleTwitterImage.bind(this);\n\t\tthis.setState = this.setState.bind(this);\n\t}\n\n\t/**\n  * Handles setting the handled image properties on the state.\n  *\n  * @returns {void}\n  */\n\tasync handleTwitterImage() {\n\t\tif (this.props.src === null) {\n\t\t\treturn;\n\t\t}\n\t\tconst newState = await (0, _determineImageProperties.handleImage)(this.props.src, this.socialMedium, this.props.isLarge);\n\t\tthis.setState(newState);\n\t}\n\n\t/**\n  * React Lifecycle method that is called after the component updates.\n  *\n  * @param {Object} prevProps The props.\n  *\n  * @returns {Object} The new props.\n  */\n\tcomponentDidUpdate(prevProps) {\n\t\t// Only perform calculations on the image if the src has actually changed.\n\t\tif (prevProps.src !== this.props.src) {\n\t\t\tthis.handleTwitterImage();\n\t\t}\n\t}\n\n\t/**\n  * After the component has mounted, determine the properties of the TwitterImage.\n  *\n  * @returns {void}\n  */\n\tcomponentDidMount() {\n\t\tthis.handleTwitterImage();\n\t}\n\n\t/**\n  * Renders the TwitterImage.\n  *\n  * @returns {ReactComponent} Either the PlaceholderImage component, the ErrorImage component or\n  * the TwitterImageContainer.\n  */\n\trender() {\n\t\tvar _state = this.state;\n\t\tconst status = _state.status,\n\t\t      imageProperties = _state.imageProperties;\n\n\n\t\tif (status === "loading" || this.props.src === "" || status === "errored") {\n\t\t\treturn _react2.default.createElement(\n\t\t\t\tPlaceholderImage,\n\t\t\t\t{\n\t\t\t\t\tisLarge: this.props.isLarge,\n\t\t\t\t\tonClick: this.props.onImageClick,\n\t\t\t\t\tonMouseEnter: this.props.onMouseEnter,\n\t\t\t\t\tonMouseLeave: this.props.onMouseLeave\n\t\t\t\t},\n\t\t\t\t(0, _i18n.__)("Select image", "wordpress-seo")\n\t\t\t);\n\t\t}\n\n\t\treturn _react2.default.createElement(\n\t\t\tTwitterImageContainer,\n\t\t\t{\n\t\t\t\tisLarge: this.props.isLarge,\n\t\t\t\tonClick: this.props.onImageClick,\n\t\t\t\tonMouseEnter: this.props.onMouseEnter,\n\t\t\t\tonMouseLeave: this.props.onMouseLeave\n\t\t\t},\n\t\t\t_react2.default.createElement(_SocialImage.SocialImage, {\n\t\t\t\timageProps: {\n\t\t\t\t\tsrc: this.props.src,\n\t\t\t\t\talt: this.props.alt,\n\t\t\t\t\taspectRatio: _determineImageProperties.TWITTER_IMAGE_SIZES.aspectRatio\n\t\t\t\t},\n\t\t\t\twidth: imageProperties.width,\n\t\t\t\theight: imageProperties.height,\n\t\t\t\timageMode: imageProperties.mode\n\t\t\t})\n\t\t);\n\t}\n}\n\nexports.default = TwitterImage;\nTwitterImage.propTypes = {\n\tisLarge: _propTypes2.default.bool.isRequired,\n\tsrc: _propTypes2.default.string,\n\talt: _propTypes2.default.string,\n\tonImageClick: _propTypes2.default.func,\n\tonMouseEnter: _propTypes2.default.func,\n\tonMouseLeave: _propTypes2.default.func\n};\n\nTwitterImage.defaultProps = {\n\tsrc: "",\n\talt: "",\n\tonMouseEnter: _lodash.noop,\n\tonImageClick: _lodash.noop,\n\tonMouseLeave: _lodash.noop\n};//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///17\n')},function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _styledComponents = __webpack_require__(0);\n\nvar _styledComponents2 = _interopRequireDefault(_styledComponents);\n\nvar _propTypes = __webpack_require__(2);\n\nvar _propTypes2 = _interopRequireDefault(_propTypes);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nconst Wrapper = _styledComponents2.default.div.withConfig({\n\tdisplayName: "TwitterTextWrapper__Wrapper",\n\tcomponentId: "sc-nrtc3w-0"\n})(["display:flex;flex-direction:column;padding:12px;justify-content:center;margin:0;box-sizing:border-box;flex:auto;min-width:0px;gap:2px;> *{line-height:20px;min-height:20px;font-size:15px;}"]);\n\n/**\n * Wrapper for all the text in the preview.\n *\n * @param {object} props The properties.\n *\n * @returns {React.Element} An element that wraps all text elements.\n */\nconst TwitterTextWrapper = props => _react2.default.createElement(\n\tWrapper,\n\tnull,\n\tprops.children\n);\n\nTwitterTextWrapper.propTypes = {\n\tchildren: _propTypes2.default.array.isRequired\n};\n\nexports.default = TwitterTextWrapper;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTguanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vbm9kZV9tb2R1bGVzL0B5b2FzdC9zb2NpYWwtbWV0YWRhdGEtcHJldmlld3Mvc3JjL3R3aXR0ZXIvVHdpdHRlclRleHRXcmFwcGVyLmpzP2Y3M2IiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IFJlYWN0IGZyb20gXCJyZWFjdFwiO1xuaW1wb3J0IHN0eWxlZCBmcm9tIFwic3R5bGVkLWNvbXBvbmVudHNcIjtcbmltcG9ydCBQcm9wVHlwZXMgZnJvbSBcInByb3AtdHlwZXNcIjtcblxuY29uc3QgV3JhcHBlciA9IHN0eWxlZC5kaXZgXG5cdGRpc3BsYXk6IGZsZXg7XG5cdGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG5cdHBhZGRpbmc6IDEycHg7XG5cdGp1c3RpZnktY29udGVudDogY2VudGVyO1xuXHRtYXJnaW46IDA7XG5cdGJveC1zaXppbmc6IGJvcmRlci1ib3g7XG5cdGZsZXg6IGF1dG87XG5cdG1pbi13aWR0aDogMHB4O1xuXHRnYXA6MnB4O1xuXHQ+ICoge1xuXHRcdGxpbmUtaGVpZ2h0OjIwcHg7XG5cdFx0bWluLWhlaWdodDoyMHB4O1xuXHRcdGZvbnQtc2l6ZToxNXB4O1xuICAgIH1cbmA7XG5cbi8qKlxuICogV3JhcHBlciBmb3IgYWxsIHRoZSB0ZXh0IGluIHRoZSBwcmV2aWV3LlxuICpcbiAqIEBwYXJhbSB7b2JqZWN0fSBwcm9wcyBUaGUgcHJvcGVydGllcy5cbiAqXG4gKiBAcmV0dXJucyB7UmVhY3QuRWxlbWVudH0gQW4gZWxlbWVudCB0aGF0IHdyYXBzIGFsbCB0ZXh0IGVsZW1lbnRzLlxuICovXG5jb25zdCBUd2l0dGVyVGV4dFdyYXBwZXIgPSAoIHByb3BzICkgPT4gPFdyYXBwZXI+XG5cdHsgcHJvcHMuY2hpbGRyZW4gfVxuPC9XcmFwcGVyPjtcblxuVHdpdHRlclRleHRXcmFwcGVyLnByb3BUeXBlcyA9IHtcblx0Y2hpbGRyZW46IFByb3BUeXBlcy5hcnJheS5pc1JlcXVpcmVkLFxufTtcblxuZXhwb3J0IGRlZmF1bHQgVHdpdHRlclRleHRXcmFwcGVyO1xuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQTtBQUNBOzs7QUFBQTtBQUNBOzs7QUFBQTtBQUNBOzs7OztBQUNBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFnQkE7Ozs7Ozs7QUFPQTtBQUFBO0FBQUE7QUFDQTtBQURBO0FBQ0E7QUFHQTtBQUNBO0FBREE7QUFDQTtBQUdBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///18\n')},function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\n\nvar _styledComponents = __webpack_require__(0);\n\nvar _styledComponents2 = _interopRequireDefault(_styledComponents);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\nconst TwitterTitle = _styledComponents2.default.p.withConfig({\n\tdisplayName: "TwitterTitle",\n\tcomponentId: "sc-2h4g0v-0"\n})(["white-space:nowrap;overflow:hidden;text-overflow:ellipsis;margin:0;color:rgb(15,20,25);cursor:pointer;"]); /* External dependencies */\nexports.default = TwitterTitle;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMTkuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vbm9kZV9tb2R1bGVzL0B5b2FzdC9zb2NpYWwtbWV0YWRhdGEtcHJldmlld3Mvc3JjL3R3aXR0ZXIvVHdpdHRlclRpdGxlLmpzP2M4ZjAiXSwic291cmNlc0NvbnRlbnQiOlsiLyogRXh0ZXJuYWwgZGVwZW5kZW5jaWVzICovXG5pbXBvcnQgc3R5bGVkIGZyb20gXCJzdHlsZWQtY29tcG9uZW50c1wiO1xuXG5jb25zdCBUd2l0dGVyVGl0bGUgPSBzdHlsZWQucGBcblx0d2hpdGUtc3BhY2U6IG5vd3JhcDtcblx0b3ZlcmZsb3c6IGhpZGRlbjtcblx0dGV4dC1vdmVyZmxvdzogZWxsaXBzaXM7XG5cdG1hcmdpbjogMDtcblx0Y29sb3I6IHJnYigxNSwgMjAsIDI1KTtcblx0Y3Vyc29yOiBwb2ludGVyO1xuYDtcblxuZXhwb3J0IGRlZmF1bHQgVHdpdHRlclRpdGxlO1xuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFDQTtBQUNBOzs7OztBQUNBO0FBQUE7QUFBQTtBQUFBO0FBU0EiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///19\n')},function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\n\nvar _styledComponents = __webpack_require__(0);\n\nvar _styledComponents2 = _interopRequireDefault(_styledComponents);\n\nvar _determineImageProperties = __webpack_require__(3);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n/**\n * Renders a TwitterDescription component.\n * NOTE: the "-webkit-line-clamp: 3" limits the number of lines to 3.\n *\n * @param {object} props The props.\n *\n * @returns {React.Component} The rendered element.\n */\n/* External dependencies */\nconst TwitterDescription = _styledComponents2.default.p.withConfig({\n\tdisplayName: "TwitterDescription",\n\tcomponentId: "sc-1kv12fr-0"\n})(["max-height:55px;overflow:hidden;text-overflow:ellipsis;margin:0;color:rgb(83,100,113);display:-webkit-box;cursor:pointer;-webkit-line-clamp:2;-webkit-box-orient:vertical;@media all and ( max-width:", "px ){display:none;}"], _determineImageProperties.TWITTER_IMAGE_SIZES.landscapeWidth);\n\nexports.default = TwitterDescription;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMjAuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vbm9kZV9tb2R1bGVzL0B5b2FzdC9zb2NpYWwtbWV0YWRhdGEtcHJldmlld3Mvc3JjL3R3aXR0ZXIvVHdpdHRlckRlc2NyaXB0aW9uLmpzPzI4ZDMiXSwic291cmNlc0NvbnRlbnQiOlsiLyogRXh0ZXJuYWwgZGVwZW5kZW5jaWVzICovXG5pbXBvcnQgc3R5bGVkIGZyb20gXCJzdHlsZWQtY29tcG9uZW50c1wiO1xuaW1wb3J0IHsgVFdJVFRFUl9JTUFHRV9TSVpFUyB9IGZyb20gXCIuLi9oZWxwZXJzL2RldGVybWluZUltYWdlUHJvcGVydGllc1wiO1xuXG4vKipcbiAqIFJlbmRlcnMgYSBUd2l0dGVyRGVzY3JpcHRpb24gY29tcG9uZW50LlxuICogTk9URTogdGhlIFwiLXdlYmtpdC1saW5lLWNsYW1wOiAzXCIgbGltaXRzIHRoZSBudW1iZXIgb2YgbGluZXMgdG8gMy5cbiAqXG4gKiBAcGFyYW0ge29iamVjdH0gcHJvcHMgVGhlIHByb3BzLlxuICpcbiAqIEByZXR1cm5zIHtSZWFjdC5Db21wb25lbnR9IFRoZSByZW5kZXJlZCBlbGVtZW50LlxuICovXG5jb25zdCBUd2l0dGVyRGVzY3JpcHRpb24gPSBzdHlsZWQucGBcblx0bWF4LWhlaWdodDogNTVweDtcblx0b3ZlcmZsb3c6IGhpZGRlbjtcblx0dGV4dC1vdmVyZmxvdzogZWxsaXBzaXM7XG5cdG1hcmdpbjogMDtcblx0Y29sb3I6IHJnYig4MywgMTAwLCAxMTMpO1xuXHRkaXNwbGF5OiAtd2Via2l0LWJveDtcblx0Y3Vyc29yOiBwb2ludGVyO1xuXHQtd2Via2l0LWxpbmUtY2xhbXA6IDI7XG5cdC13ZWJraXQtYm94LW9yaWVudDogdmVydGljYWw7XG5cblx0QG1lZGlhIGFsbCBhbmQgKCBtYXgtd2lkdGg6ICR7IFRXSVRURVJfSU1BR0VfU0laRVMubGFuZHNjYXBlV2lkdGggfXB4ICkge1xuXHRcdGRpc3BsYXk6IG5vbmU7XG5cdH1cbmA7XG5cbmV4cG9ydCBkZWZhdWx0IFR3aXR0ZXJEZXNjcmlwdGlvbjtcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQ0E7QUFDQTs7O0FBQUE7QUFDQTs7O0FBQ0E7Ozs7Ozs7O0FBSkE7QUFZQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBZUEiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///20\n')},function(module,exports,__webpack_require__){"use strict";eval('\n\nObject.defineProperty(exports, "__esModule", {\n\tvalue: true\n});\n\nvar _components = __webpack_require__(22);\n\nvar _react = __webpack_require__(1);\n\nvar _react2 = _interopRequireDefault(_react);\n\nvar _propTypes = __webpack_require__(2);\n\nvar _propTypes2 = _interopRequireDefault(_propTypes);\n\nvar _socialMetadataForms = __webpack_require__(23);\n\nvar _FacebookPreview = __webpack_require__(4);\n\nvar _FacebookPreview2 = _interopRequireDefault(_FacebookPreview);\n\nvar _TwitterPreview = __webpack_require__(8);\n\nvar _TwitterPreview2 = _interopRequireDefault(_TwitterPreview);\n\nvar _replacementVariableEditor = __webpack_require__(24);\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }\n\n/**\n * A form with an image selection button, a title input field and a description field and the social preview.\n *\n * @returns {void} Void.\n */\n\n\n/* Internal dependencies */\nclass SocialPreviewEditor extends _react.Component {\n\t/**\n  * The constructor.\n  * @param {Object} props The props object.\n  *\n  * @returns {void}\n  */\n\tconstructor(props) {\n\t\tsuper(props);\n\n\t\tthis.state = {\n\t\t\tactiveField: "",\n\t\t\thoveredField: ""\n\t\t};\n\n\t\tthis.SocialPreview = props.socialMediumName === "Facebook" ? _FacebookPreview2.default : _TwitterPreview2.default;\n\t\tthis.setHoveredField = this.setHoveredField.bind(this);\n\t\tthis.setActiveField = this.setActiveField.bind(this);\n\t\tthis.setEditorRef = this.setEditorRef.bind(this);\n\t\tthis.setEditorFocus = this.setEditorFocus.bind(this);\n\t}\n\n\t/**\n  * Sets the field that the mouse is hovering over in state.\n  *\n  * @param {string} field The field that is hovered over.\n  *\n  * @returns {void}\n  */\n\tsetHoveredField(field) {\n\t\tif (field === this.state.hoveredField) {\n\t\t\treturn;\n\t\t}\n\t\tthis.setState({\n\t\t\thoveredField: field\n\t\t});\n\t}\n\n\t/**\n  * Sets the active field that is selected in state.\n  *\n  * @param {string} field The field that is selected.\n  *\n  * @returns {void}\n  */\n\tsetActiveField(field) {\n\t\tif (field === this.state.activeField) {\n\t\t\treturn;\n\t\t}\n\t\tthis.setState({ activeField: field }, () => this.setEditorFocus(field));\n\t}\n\n\t/**\n  * Sets focus on the editor that is the active field.\n  *\n  * @param {String} field The active field belonging to the editor to focus.\n  *\n  * @returns {void}\n  */\n\tsetEditorFocus(field) {\n\t\tswitch (field) {\n\t\t\tcase "title":\n\t\t\t\tthis.titleEditorRef.focus();\n\t\t\t\tbreak;\n\t\t\tcase "description":\n\t\t\t\tthis.descriptionEditorRef.focus();\n\t\t\t\tbreak;\n\t\t}\n\t}\n\n\t/**\n  * Sets the reference of each editor.\n  * Used by child components to communicate with this focus managing component.\n  * This component can then call the .focus() function on the passed refs.\n  *\n  * @param {string} field The field belonging to the editor that belongs to the ref.\n  * @param {*} ref A ref to an editor.\n  *\n  * @returns {void}\n  */\n\tsetEditorRef(field, ref) {\n\t\tswitch (field) {\n\t\t\tcase "title":\n\t\t\t\tthis.titleEditorRef = ref;\n\t\t\t\tbreak;\n\t\t\tcase "description":\n\t\t\t\tthis.descriptionEditorRef = ref;\n\t\t\t\tbreak;\n\t\t}\n\t}\n\n\t/**\n  * The render function.\n  *\n  * @returns {void} Void.\n  */\n\trender() {\n\t\tvar _props = this.props;\n\t\tconst onDescriptionChange = _props.onDescriptionChange,\n\t\t      onTitleChange = _props.onTitleChange,\n\t\t      onSelectImageClick = _props.onSelectImageClick,\n\t\t      onRemoveImageClick = _props.onRemoveImageClick,\n\t\t      socialMediumName = _props.socialMediumName,\n\t\t      imageWarnings = _props.imageWarnings,\n\t\t      siteUrl = _props.siteUrl,\n\t\t      description = _props.description,\n\t\t      descriptionInputPlaceholder = _props.descriptionInputPlaceholder,\n\t\t      descriptionPreviewFallback = _props.descriptionPreviewFallback,\n\t\t      imageUrl = _props.imageUrl,\n\t\t      imageFallbackUrl = _props.imageFallbackUrl,\n\t\t      alt = _props.alt,\n\t\t      title = _props.title,\n\t\t      titleInputPlaceholder = _props.titleInputPlaceholder,\n\t\t      titlePreviewFallback = _props.titlePreviewFallback,\n\t\t      replacementVariables = _props.replacementVariables,\n\t\t      recommendedReplacementVariables = _props.recommendedReplacementVariables,\n\t\t      applyReplacementVariables = _props.applyReplacementVariables,\n\t\t      isPremium = _props.isPremium,\n\t\t      isLarge = _props.isLarge,\n\t\t      socialPreviewLabel = _props.socialPreviewLabel,\n\t\t      idSuffix = _props.idSuffix,\n\t\t      activeMetaTabId = _props.activeMetaTabId;\n\n\t\t// Set fallbacks if title and/or description are empty.\n\n\t\tconst previewTitle = title || titlePreviewFallback;\n\t\tconst previewDescription = description || descriptionPreviewFallback;\n\n\t\tconst replacedVars = applyReplacementVariables({ title: previewTitle, description: previewDescription });\n\n\t\treturn _react2.default.createElement(\n\t\t\t_react2.default.Fragment,\n\t\t\tnull,\n\t\t\tsocialPreviewLabel && _react2.default.createElement(\n\t\t\t\t_components.SimulatedLabel,\n\t\t\t\tnull,\n\t\t\t\tsocialPreviewLabel\n\t\t\t),\n\t\t\t_react2.default.createElement(this.SocialPreview, {\n\t\t\t\tonMouseHover: this.setHoveredField,\n\t\t\t\tonSelect: this.setActiveField,\n\t\t\t\tonImageClick: onSelectImageClick,\n\t\t\t\tsiteUrl: siteUrl,\n\t\t\t\ttitle: replacedVars.title,\n\t\t\t\tdescription: replacedVars.description,\n\t\t\t\timageUrl: imageUrl,\n\t\t\t\timageFallbackUrl: imageFallbackUrl,\n\t\t\t\talt: alt,\n\t\t\t\tisLarge: isLarge,\n\t\t\t\tactiveMetaTabId: activeMetaTabId\n\t\t\t}),\n\t\t\t_react2.default.createElement(_socialMetadataForms.SocialMetadataPreviewForm, {\n\t\t\t\tonDescriptionChange: onDescriptionChange,\n\t\t\t\tsocialMediumName: socialMediumName,\n\t\t\t\ttitle: title,\n\t\t\t\ttitleInputPlaceholder: titleInputPlaceholder,\n\t\t\t\tonRemoveImageClick: onRemoveImageClick,\n\t\t\t\timageSelected: !!imageUrl,\n\t\t\t\timageUrl: imageUrl,\n\t\t\t\tonTitleChange: onTitleChange,\n\t\t\t\tonSelectImageClick: onSelectImageClick,\n\t\t\t\tdescription: description,\n\t\t\t\tdescriptionInputPlaceholder: descriptionInputPlaceholder,\n\t\t\t\timageWarnings: imageWarnings,\n\t\t\t\treplacementVariables: replacementVariables,\n\t\t\t\trecommendedReplacementVariables: recommendedReplacementVariables,\n\t\t\t\tonMouseHover: this.setHoveredField,\n\t\t\t\thoveredField: this.state.hoveredField,\n\t\t\t\tonSelect: this.setActiveField,\n\t\t\t\tactiveField: this.state.activeField,\n\t\t\t\tisPremium: isPremium,\n\t\t\t\tsetEditorRef: this.setEditorRef,\n\t\t\t\tidSuffix: idSuffix\n\t\t\t})\n\t\t);\n\t}\n} /* External dependencies */\n\n\nSocialPreviewEditor.propTypes = {\n\ttitle: _propTypes2.default.string.isRequired,\n\tonTitleChange: _propTypes2.default.func.isRequired,\n\tdescription: _propTypes2.default.string.isRequired,\n\tonDescriptionChange: _propTypes2.default.func.isRequired,\n\timageUrl: _propTypes2.default.string.isRequired,\n\timageFallbackUrl: _propTypes2.default.string.isRequired,\n\tonSelectImageClick: _propTypes2.default.func.isRequired,\n\tonRemoveImageClick: _propTypes2.default.func.isRequired,\n\tsocialMediumName: _propTypes2.default.string.isRequired,\n\talt: _propTypes2.default.string,\n\tisPremium: _propTypes2.default.bool,\n\timageWarnings: _propTypes2.default.array,\n\tisLarge: _propTypes2.default.bool,\n\tsiteUrl: _propTypes2.default.string,\n\tdescriptionInputPlaceholder: _propTypes2.default.string,\n\ttitleInputPlaceholder: _propTypes2.default.string,\n\tdescriptionPreviewFallback: _propTypes2.default.string,\n\ttitlePreviewFallback: _propTypes2.default.string,\n\treplacementVariables: _replacementVariableEditor.replacementVariablesShape,\n\trecommendedReplacementVariables: _replacementVariableEditor.recommendedReplacementVariablesShape,\n\tapplyReplacementVariables: _propTypes2.default.func,\n\tsocialPreviewLabel: _propTypes2.default.string,\n\tidSuffix: _propTypes2.default.string,\n\tactiveMetaTabId: _propTypes2.default.string\n};\n\nSocialPreviewEditor.defaultProps = {\n\timageWarnings: [],\n\trecommendedReplacementVariables: [],\n\treplacementVariables: [],\n\tisPremium: false,\n\tisLarge: true,\n\tsiteUrl: "",\n\tdescriptionInputPlaceholder: "",\n\ttitleInputPlaceholder: "",\n\tdescriptionPreviewFallback: "",\n\ttitlePreviewFallback: "",\n\talt: "",\n\tapplyReplacementVariables: data => data,\n\tsocialPreviewLabel: "",\n\tidSuffix: "",\n\tactiveMetaTabId: ""\n};\n\nexports.default = SocialPreviewEditor;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMjEuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vbm9kZV9tb2R1bGVzL0B5b2FzdC9zb2NpYWwtbWV0YWRhdGEtcHJldmlld3Mvc3JjL2VkaXRvci9Tb2NpYWxQcmV2aWV3RWRpdG9yLmpzPzAyNTkiXSwic291cmNlc0NvbnRlbnQiOlsiLyogRXh0ZXJuYWwgZGVwZW5kZW5jaWVzICovXG5pbXBvcnQgeyBTaW11bGF0ZWRMYWJlbCB9IGZyb20gXCJAeW9hc3QvY29tcG9uZW50c1wiO1xuaW1wb3J0IFJlYWN0LCB7IENvbXBvbmVudCB9IGZyb20gXCJyZWFjdFwiO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tIFwicHJvcC10eXBlc1wiO1xuXG4vKiBJbnRlcm5hbCBkZXBlbmRlbmNpZXMgKi9cbmltcG9ydCB7IFNvY2lhbE1ldGFkYXRhUHJldmlld0Zvcm0gfSBmcm9tIFwiQHlvYXN0L3NvY2lhbC1tZXRhZGF0YS1mb3Jtc1wiO1xuaW1wb3J0IEZhY2Vib29rUHJldmlldyBmcm9tIFwiLi4vZmFjZWJvb2svRmFjZWJvb2tQcmV2aWV3XCI7XG5pbXBvcnQgVHdpdHRlclByZXZpZXcgZnJvbSBcIi4uL3R3aXR0ZXIvVHdpdHRlclByZXZpZXdcIjtcbmltcG9ydCB7IHJlY29tbWVuZGVkUmVwbGFjZW1lbnRWYXJpYWJsZXNTaGFwZSwgcmVwbGFjZW1lbnRWYXJpYWJsZXNTaGFwZSB9IGZyb20gXCJAeW9hc3QvcmVwbGFjZW1lbnQtdmFyaWFibGUtZWRpdG9yXCI7XG5cbi8qKlxuICogQSBmb3JtIHdpdGggYW4gaW1hZ2Ugc2VsZWN0aW9uIGJ1dHRvbiwgYSB0aXRsZSBpbnB1dCBmaWVsZCBhbmQgYSBkZXNjcmlwdGlvbiBmaWVsZCBhbmQgdGhlIHNvY2lhbCBwcmV2aWV3LlxuICpcbiAqIEByZXR1cm5zIHt2b2lkfSBWb2lkLlxuICovXG5jbGFzcyBTb2NpYWxQcmV2aWV3RWRpdG9yIGV4dGVuZHMgQ29tcG9uZW50IHtcblx0LyoqXG5cdCAqIFRoZSBjb25zdHJ1Y3Rvci5cblx0ICogQHBhcmFtIHtPYmplY3R9IHByb3BzIFRoZSBwcm9wcyBvYmplY3QuXG5cdCAqXG5cdCAqIEByZXR1cm5zIHt2b2lkfVxuXHQgKi9cblx0Y29uc3RydWN0b3IoIHByb3BzICkge1xuXHRcdHN1cGVyKCBwcm9wcyApO1xuXG5cdFx0dGhpcy5zdGF0ZSA9IHtcblx0XHRcdGFjdGl2ZUZpZWxkOiBcIlwiLFxuXHRcdFx0aG92ZXJlZEZpZWxkOiBcIlwiLFxuXHRcdH07XG5cblx0XHR0aGlzLlNvY2lhbFByZXZpZXcgPSBwcm9wcy5zb2NpYWxNZWRpdW1OYW1lID09PSBcIkZhY2Vib29rXCIgPyBGYWNlYm9va1ByZXZpZXcgOiBUd2l0dGVyUHJldmlldztcblx0XHR0aGlzLnNldEhvdmVyZWRGaWVsZCA9IHRoaXMuc2V0SG92ZXJlZEZpZWxkLmJpbmQoIHRoaXMgKTtcblx0XHR0aGlzLnNldEFjdGl2ZUZpZWxkID0gdGhpcy5zZXRBY3RpdmVGaWVsZC5iaW5kKCB0aGlzICk7XG5cdFx0dGhpcy5zZXRFZGl0b3JSZWYgPSB0aGlzLnNldEVkaXRvclJlZi5iaW5kKCB0aGlzICk7XG5cdFx0dGhpcy5zZXRFZGl0b3JGb2N1cyA9IHRoaXMuc2V0RWRpdG9yRm9jdXMuYmluZCggdGhpcyApO1xuXHR9XG5cblx0LyoqXG5cdCAqIFNldHMgdGhlIGZpZWxkIHRoYXQgdGhlIG1vdXNlIGlzIGhvdmVyaW5nIG92ZXIgaW4gc3RhdGUuXG5cdCAqXG5cdCAqIEBwYXJhbSB7c3RyaW5nfSBmaWVsZCBUaGUgZmllbGQgdGhhdCBpcyBob3ZlcmVkIG92ZXIuXG5cdCAqXG5cdCAqIEByZXR1cm5zIHt2b2lkfVxuXHQgKi9cblx0c2V0SG92ZXJlZEZpZWxkKCBmaWVsZCApIHtcblx0XHRpZiAoIGZpZWxkID09PSB0aGlzLnN0YXRlLmhvdmVyZWRGaWVsZCApIHtcblx0XHRcdHJldHVybjtcblx0XHR9XG5cdFx0dGhpcy5zZXRTdGF0ZSgge1xuXHRcdFx0aG92ZXJlZEZpZWxkOiBmaWVsZCxcblx0XHR9ICk7XG5cdH1cblxuXHQvKipcblx0ICogU2V0cyB0aGUgYWN0aXZlIGZpZWxkIHRoYXQgaXMgc2VsZWN0ZWQgaW4gc3RhdGUuXG5cdCAqXG5cdCAqIEBwYXJhbSB7c3RyaW5nfSBmaWVsZCBUaGUgZmllbGQgdGhhdCBpcyBzZWxlY3RlZC5cblx0ICpcblx0ICogQHJldHVybnMge3ZvaWR9XG5cdCAqL1xuXHRzZXRBY3RpdmVGaWVsZCggZmllbGQgKSB7XG5cdFx0aWYgKCBmaWVsZCA9PT0gdGhpcy5zdGF0ZS5hY3RpdmVGaWVsZCApIHtcblx0XHRcdHJldHVybjtcblx0XHR9XG5cdFx0dGhpcy5zZXRTdGF0ZShcblx0XHRcdHsgYWN0aXZlRmllbGQ6IGZpZWxkIH0sXG5cdFx0XHQoKSA9PiB0aGlzLnNldEVkaXRvckZvY3VzKCBmaWVsZCApXG5cdFx0KTtcblx0fVxuXG5cdC8qKlxuXHQgKiBTZXRzIGZvY3VzIG9uIHRoZSBlZGl0b3IgdGhhdCBpcyB0aGUgYWN0aXZlIGZpZWxkLlxuXHQgKlxuXHQgKiBAcGFyYW0ge1N0cmluZ30gZmllbGQgVGhlIGFjdGl2ZSBmaWVsZCBiZWxvbmdpbmcgdG8gdGhlIGVkaXRvciB0byBmb2N1cy5cblx0ICpcblx0ICogQHJldHVybnMge3ZvaWR9XG5cdCAqL1xuXHRzZXRFZGl0b3JGb2N1cyggZmllbGQgKSB7XG5cdFx0c3dpdGNoICggZmllbGQgKSB7XG5cdFx0XHRjYXNlIFwidGl0bGVcIjpcblx0XHRcdFx0dGhpcy50aXRsZUVkaXRvclJlZi5mb2N1cygpO1xuXHRcdFx0XHRicmVhaztcblx0XHRcdGNhc2UgXCJkZXNjcmlwdGlvblwiOlxuXHRcdFx0XHR0aGlzLmRlc2NyaXB0aW9uRWRpdG9yUmVmLmZvY3VzKCk7XG5cdFx0XHRcdGJyZWFrO1xuXHRcdH1cblx0fVxuXG5cdC8qKlxuXHQgKiBTZXRzIHRoZSByZWZlcmVuY2Ugb2YgZWFjaCBlZGl0b3IuXG5cdCAqIFVzZWQgYnkgY2hpbGQgY29tcG9uZW50cyB0byBjb21tdW5pY2F0ZSB3aXRoIHRoaXMgZm9jdXMgbWFuYWdpbmcgY29tcG9uZW50LlxuXHQgKiBUaGlzIGNvbXBvbmVudCBjYW4gdGhlbiBjYWxsIHRoZSAuZm9jdXMoKSBmdW5jdGlvbiBvbiB0aGUgcGFzc2VkIHJlZnMuXG5cdCAqXG5cdCAqIEBwYXJhbSB7c3RyaW5nfSBmaWVsZCBUaGUgZmllbGQgYmVsb25naW5nIHRvIHRoZSBlZGl0b3IgdGhhdCBiZWxvbmdzIHRvIHRoZSByZWYuXG5cdCAqIEBwYXJhbSB7Kn0gcmVmIEEgcmVmIHRvIGFuIGVkaXRvci5cblx0ICpcblx0ICogQHJldHVybnMge3ZvaWR9XG5cdCAqL1xuXHRzZXRFZGl0b3JSZWYoIGZpZWxkLCByZWYgKSB7XG5cdFx0c3dpdGNoICggZmllbGQgKSB7XG5cdFx0XHRjYXNlIFwidGl0bGVcIjpcblx0XHRcdFx0dGhpcy50aXRsZUVkaXRvclJlZiA9IHJlZjtcblx0XHRcdFx0YnJlYWs7XG5cdFx0XHRjYXNlIFwiZGVzY3JpcHRpb25cIjpcblx0XHRcdFx0dGhpcy5kZXNjcmlwdGlvbkVkaXRvclJlZiA9IHJlZjtcblx0XHRcdFx0YnJlYWs7XG5cdFx0fVxuXHR9XG5cblx0LyoqXG5cdCAqIFRoZSByZW5kZXIgZnVuY3Rpb24uXG5cdCAqXG5cdCAqIEByZXR1cm5zIHt2b2lkfSBWb2lkLlxuXHQgKi9cblx0cmVuZGVyKCkge1xuXHRcdGNvbnN0IHtcblx0XHRcdG9uRGVzY3JpcHRpb25DaGFuZ2UsXG5cdFx0XHRvblRpdGxlQ2hhbmdlLFxuXHRcdFx0b25TZWxlY3RJbWFnZUNsaWNrLFxuXHRcdFx0b25SZW1vdmVJbWFnZUNsaWNrLFxuXHRcdFx0c29jaWFsTWVkaXVtTmFtZSxcblx0XHRcdGltYWdlV2FybmluZ3MsXG5cdFx0XHRzaXRlVXJsLFxuXHRcdFx0ZGVzY3JpcHRpb24sXG5cdFx0XHRkZXNjcmlwdGlvbklucHV0UGxhY2Vob2xkZXIsXG5cdFx0XHRkZXNjcmlwdGlvblByZXZpZXdGYWxsYmFjayxcblx0XHRcdGltYWdlVXJsLFxuXHRcdFx0aW1hZ2VGYWxsYmFja1VybCxcblx0XHRcdGFsdCxcblx0XHRcdHRpdGxlLFxuXHRcdFx0dGl0bGVJbnB1dFBsYWNlaG9sZGVyLFxuXHRcdFx0dGl0bGVQcmV2aWV3RmFsbGJhY2ssXG5cdFx0XHRyZXBsYWNlbWVudFZhcmlhYmxlcyxcblx0XHRcdHJlY29tbWVuZGVkUmVwbGFjZW1lbnRWYXJpYWJsZXMsXG5cdFx0XHRhcHBseVJlcGxhY2VtZW50VmFyaWFibGVzLFxuXHRcdFx0aXNQcmVtaXVtLFxuXHRcdFx0aXNMYXJnZSxcblx0XHRcdHNvY2lhbFByZXZpZXdMYWJlbCxcblx0XHRcdGlkU3VmZml4LFxuXHRcdFx0YWN0aXZlTWV0YVRhYklkLFxuXHRcdH0gPSB0aGlzLnByb3BzO1xuXG5cdFx0Ly8gU2V0IGZhbGxiYWNrcyBpZiB0aXRsZSBhbmQvb3IgZGVzY3JpcHRpb24gYXJlIGVtcHR5LlxuXHRcdGNvbnN0IHByZXZpZXdUaXRsZSA9IHRpdGxlIHx8IHRpdGxlUHJldmlld0ZhbGxiYWNrO1xuXHRcdGNvbnN0IHByZXZpZXdEZXNjcmlwdGlvbiA9IGRlc2NyaXB0aW9uIHx8IGRlc2NyaXB0aW9uUHJldmlld0ZhbGxiYWNrO1xuXG5cdFx0Y29uc3QgcmVwbGFjZWRWYXJzID0gYXBwbHlSZXBsYWNlbWVudFZhcmlhYmxlcyggeyB0aXRsZTogcHJldmlld1RpdGxlLCBkZXNjcmlwdGlvbjogcHJldmlld0Rlc2NyaXB0aW9uIH0gKTtcblxuXHRcdHJldHVybiAoXG5cdFx0XHQ8UmVhY3QuRnJhZ21lbnQ+XG5cdFx0XHRcdHsgc29jaWFsUHJldmlld0xhYmVsICYmIDxTaW11bGF0ZWRMYWJlbD5cblx0XHRcdFx0XHR7IHNvY2lhbFByZXZpZXdMYWJlbCB9XG5cdFx0XHRcdDwvU2ltdWxhdGVkTGFiZWw+IH1cblx0XHRcdFx0PHRoaXMuU29jaWFsUHJldmlld1xuXHRcdFx0XHRcdG9uTW91c2VIb3Zlcj17IHRoaXMuc2V0SG92ZXJlZEZpZWxkIH1cblx0XHRcdFx0XHRvblNlbGVjdD17IHRoaXMuc2V0QWN0aXZlRmllbGQgfVxuXHRcdFx0XHRcdG9uSW1hZ2VDbGljaz17IG9uU2VsZWN0SW1hZ2VDbGljayB9XG5cdFx0XHRcdFx0c2l0ZVVybD17IHNpdGVVcmwgfVxuXHRcdFx0XHRcdHRpdGxlPXsgcmVwbGFjZWRWYXJzLnRpdGxlIH1cblx0XHRcdFx0XHRkZXNjcmlwdGlvbj17IHJlcGxhY2VkVmFycy5kZXNjcmlwdGlvbiB9XG5cdFx0XHRcdFx0aW1hZ2VVcmw9eyBpbWFnZVVybCB9XG5cdFx0XHRcdFx0aW1hZ2VGYWxsYmFja1VybD17IGltYWdlRmFsbGJhY2tVcmwgfVxuXHRcdFx0XHRcdGFsdD17IGFsdCB9XG5cdFx0XHRcdFx0aXNMYXJnZT17IGlzTGFyZ2UgfVxuXHRcdFx0XHRcdGFjdGl2ZU1ldGFUYWJJZD17IGFjdGl2ZU1ldGFUYWJJZCB9XG5cdFx0XHRcdC8+XG5cdFx0XHRcdDxTb2NpYWxNZXRhZGF0YVByZXZpZXdGb3JtXG5cdFx0XHRcdFx0b25EZXNjcmlwdGlvbkNoYW5nZT17IG9uRGVzY3JpcHRpb25DaGFuZ2UgfVxuXHRcdFx0XHRcdHNvY2lhbE1lZGl1bU5hbWU9eyBzb2NpYWxNZWRpdW1OYW1lIH1cblx0XHRcdFx0XHR0aXRsZT17IHRpdGxlIH1cblx0XHRcdFx0XHR0aXRsZUlucHV0UGxhY2Vob2xkZXI9eyB0aXRsZUlucHV0UGxhY2Vob2xkZXIgfVxuXHRcdFx0XHRcdG9uUmVtb3ZlSW1hZ2VDbGljaz17IG9uUmVtb3ZlSW1hZ2VDbGljayB9XG5cdFx0XHRcdFx0aW1hZ2VTZWxlY3RlZD17ICEhIGltYWdlVXJsIH1cblx0XHRcdFx0XHRpbWFnZVVybD17IGltYWdlVXJsIH1cblx0XHRcdFx0XHRvblRpdGxlQ2hhbmdlPXsgb25UaXRsZUNoYW5nZSB9XG5cdFx0XHRcdFx0b25TZWxlY3RJbWFnZUNsaWNrPXsgb25TZWxlY3RJbWFnZUNsaWNrIH1cblx0XHRcdFx0XHRkZXNjcmlwdGlvbj17IGRlc2NyaXB0aW9uIH1cblx0XHRcdFx0XHRkZXNjcmlwdGlvbklucHV0UGxhY2Vob2xkZXI9eyBkZXNjcmlwdGlvbklucHV0UGxhY2Vob2xkZXIgfVxuXHRcdFx0XHRcdGltYWdlV2FybmluZ3M9eyBpbWFnZVdhcm5pbmdzIH1cblx0XHRcdFx0XHRyZXBsYWNlbWVudFZhcmlhYmxlcz17IHJlcGxhY2VtZW50VmFyaWFibGVzIH1cblx0XHRcdFx0XHRyZWNvbW1lbmRlZFJlcGxhY2VtZW50VmFyaWFibGVzPXsgcmVjb21tZW5kZWRSZXBsYWNlbWVudFZhcmlhYmxlcyB9XG5cdFx0XHRcdFx0b25Nb3VzZUhvdmVyPXsgdGhpcy5zZXRIb3ZlcmVkRmllbGQgfVxuXHRcdFx0XHRcdGhvdmVyZWRGaWVsZD17IHRoaXMuc3RhdGUuaG92ZXJlZEZpZWxkIH1cblx0XHRcdFx0XHRvblNlbGVjdD17IHRoaXMuc2V0QWN0aXZlRmllbGQgfVxuXHRcdFx0XHRcdGFjdGl2ZUZpZWxkPXsgdGhpcy5zdGF0ZS5hY3RpdmVGaWVsZCB9XG5cdFx0XHRcdFx0aXNQcmVtaXVtPXsgaXNQcmVtaXVtIH1cblx0XHRcdFx0XHRzZXRFZGl0b3JSZWY9eyB0aGlzLnNldEVkaXRvclJlZiB9XG5cdFx0XHRcdFx0aWRTdWZmaXg9eyBpZFN1ZmZpeCB9XG5cdFx0XHRcdC8+XG5cdFx0XHQ8L1JlYWN0LkZyYWdtZW50PlxuXHRcdCk7XG5cdH1cbn1cblxuU29jaWFsUHJldmlld0VkaXRvci5wcm9wVHlwZXMgPSB7XG5cdHRpdGxlOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG5cdG9uVGl0bGVDaGFuZ2U6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG5cdGRlc2NyaXB0aW9uOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG5cdG9uRGVzY3JpcHRpb25DaGFuZ2U6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG5cdGltYWdlVXJsOiBQcm9wVHlwZXMuc3RyaW5nLmlzUmVxdWlyZWQsXG5cdGltYWdlRmFsbGJhY2tVcmw6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcblx0b25TZWxlY3RJbWFnZUNsaWNrOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuXHRvblJlbW92ZUltYWdlQ2xpY2s6IFByb3BUeXBlcy5mdW5jLmlzUmVxdWlyZWQsXG5cdHNvY2lhbE1lZGl1bU5hbWU6IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcblx0YWx0OiBQcm9wVHlwZXMuc3RyaW5nLFxuXHRpc1ByZW1pdW06IFByb3BUeXBlcy5ib29sLFxuXHRpbWFnZVdhcm5pbmdzOiBQcm9wVHlwZXMuYXJyYXksXG5cdGlzTGFyZ2U6IFByb3BUeXBlcy5ib29sLFxuXHRzaXRlVXJsOiBQcm9wVHlwZXMuc3RyaW5nLFxuXHRkZXNjcmlwdGlvbklucHV0UGxhY2Vob2xkZXI6IFByb3BUeXBlcy5zdHJpbmcsXG5cdHRpdGxlSW5wdXRQbGFjZWhvbGRlcjogUHJvcFR5cGVzLnN0cmluZyxcblx0ZGVzY3JpcHRpb25QcmV2aWV3RmFsbGJhY2s6IFByb3BUeXBlcy5zdHJpbmcsXG5cdHRpdGxlUHJldmlld0ZhbGxiYWNrOiBQcm9wVHlwZXMuc3RyaW5nLFxuXHRyZXBsYWNlbWVudFZhcmlhYmxlczogcmVwbGFjZW1lbnRWYXJpYWJsZXNTaGFwZSxcblx0cmVjb21tZW5kZWRSZXBsYWNlbWVudFZhcmlhYmxlczogcmVjb21tZW5kZWRSZXBsYWNlbWVudFZhcmlhYmxlc1NoYXBlLFxuXHRhcHBseVJlcGxhY2VtZW50VmFyaWFibGVzOiBQcm9wVHlwZXMuZnVuYyxcblx0c29jaWFsUHJldmlld0xhYmVsOiBQcm9wVHlwZXMuc3RyaW5nLFxuXHRpZFN1ZmZpeDogUHJvcFR5cGVzLnN0cmluZyxcblx0YWN0aXZlTWV0YVRhYklkOiBQcm9wVHlwZXMuc3RyaW5nLFxufTtcblxuU29jaWFsUHJldmlld0VkaXRvci5kZWZhdWx0UHJvcHMgPSB7XG5cdGltYWdlV2FybmluZ3M6IFtdLFxuXHRyZWNvbW1lbmRlZFJlcGxhY2VtZW50VmFyaWFibGVzOiBbXSxcblx0cmVwbGFjZW1lbnRWYXJpYWJsZXM6IFtdLFxuXHRpc1ByZW1pdW06IGZhbHNlLFxuXHRpc0xhcmdlOiB0cnVlLFxuXHRzaXRlVXJsOiBcIlwiLFxuXHRkZXNjcmlwdGlvbklucHV0UGxhY2Vob2xkZXI6IFwiXCIsXG5cdHRpdGxlSW5wdXRQbGFjZWhvbGRlcjogXCJcIixcblx0ZGVzY3JpcHRpb25QcmV2aWV3RmFsbGJhY2s6IFwiXCIsXG5cdHRpdGxlUHJldmlld0ZhbGxiYWNrOiBcIlwiLFxuXHRhbHQ6IFwiXCIsXG5cdGFwcGx5UmVwbGFjZW1lbnRWYXJpYWJsZXM6IGRhdGEgPT4gZGF0YSxcblx0c29jaWFsUHJldmlld0xhYmVsOiBcIlwiLFxuXHRpZFN1ZmZpeDogXCJcIixcblx0YWN0aXZlTWV0YVRhYklkOiBcIlwiLFxufTtcblxuZXhwb3J0IGRlZmF1bHQgU29jaWFsUHJldmlld0VkaXRvcjtcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQ0E7QUFDQTtBQUFBO0FBQ0E7OztBQUFBO0FBQ0E7OztBQUVBO0FBQ0E7QUFBQTtBQUNBOzs7QUFBQTtBQUNBOzs7QUFBQTtBQUNBOzs7QUFDQTs7Ozs7OztBQU5BO0FBV0E7QUFDQTs7Ozs7O0FBTUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBRkE7QUFDQTtBQUlBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7Ozs7QUFPQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFEQTtBQUdBO0FBQ0E7QUFDQTs7Ozs7OztBQU9BO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFJQTtBQUNBO0FBQ0E7Ozs7Ozs7QUFPQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBTkE7QUFRQTtBQUNBO0FBQ0E7Ozs7Ozs7Ozs7QUFVQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBTkE7QUFRQTtBQUNBO0FBQ0E7Ozs7O0FBS0E7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBMkJBO0FBQ0E7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUFBO0FBQ0E7QUFBQTtBQUFBO0FBQ0E7QUFEQTtBQUdBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQVhBO0FBYUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFyQkE7QUFqQkE7QUEwQ0E7QUFoTEE7QUFDQTtBQUNBO0FBaUxBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBeEJBO0FBQ0E7QUEwQkE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFmQTtBQUNBO0FBaUJBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///21\n')},function(module,exports){eval("module.exports = window.yoast.componentsNew;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMjIuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vZXh0ZXJuYWwgXCJ3aW5kb3cueW9hc3QuY29tcG9uZW50c05ld1wiPzFmZWYiXSwic291cmNlc0NvbnRlbnQiOlsibW9kdWxlLmV4cG9ydHMgPSB3aW5kb3cueW9hc3QuY29tcG9uZW50c05ldzsiXSwibWFwcGluZ3MiOiJBQUFBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///22\n")},function(module,exports){eval("module.exports = window.yoast.socialMetadataForms;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMjMuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vZXh0ZXJuYWwgXCJ3aW5kb3cueW9hc3Quc29jaWFsTWV0YWRhdGFGb3Jtc1wiPzA0ZjMiXSwic291cmNlc0NvbnRlbnQiOlsibW9kdWxlLmV4cG9ydHMgPSB3aW5kb3cueW9hc3Quc29jaWFsTWV0YWRhdGFGb3JtczsiXSwibWFwcGluZ3MiOiJBQUFBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///23\n")},function(module,exports){eval("module.exports = window.yoast.replacementVariableEditor;//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiMjQuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vZXh0ZXJuYWwgXCJ3aW5kb3cueW9hc3QucmVwbGFjZW1lbnRWYXJpYWJsZUVkaXRvclwiPzA1OGEiXSwic291cmNlc0NvbnRlbnQiOlsibW9kdWxlLmV4cG9ydHMgPSB3aW5kb3cueW9hc3QucmVwbGFjZW1lbnRWYXJpYWJsZUVkaXRvcjsiXSwibWFwcGluZ3MiOiJBQUFBIiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///24\n")}]);