## Gutenberg Template Library & Redux Framework
[![WordPress plugin](https://img.shields.io/wordpress/plugin/v/redux-framework.svg?maxAge=3600)](https://wordpress.org/plugins/redux-framework) [![WordPress](https://img.shields.io/wordpress/v/redux-framework.svg?maxAge=3600)](https://wordpress.org/download/) [![Build Status](https://travis-ci.org/reduxframework/redux-framework.png?branch=master)](https://travis-ci.org/reduxframework/redux-framework) [![Slack](https://redux-slackin.herokuapp.com/badge.svg)](https://redux-slackin.herokuapp.com)

#### Redux is powered by the Extendify team. Learn more at [extendify.com](https://extendify.com) ####

## New to Version 4.3 ##
* METABOXES!
* REPEATER EXTENSION!
* Gutenberg Template Library updated to the new Extendify library. See more information here about this upgrade and how to access the legacy library: [https://redux.io/gutenberg-template-library-upgrade](https://redux.io/gutenberg-template-library-upgrade).

## Beta testing instructions for the Repeater extension ##
* Repeater config is includes in the sample config.  
* If you are already using the Repeater extension of Redux Pro, there is nothing you need to update.  The version of the Repeater field within the Redux core will override both the extension and Pro.
* Please verify the repeater field in your existing project still function normally.
* Please do not use this code in your production releases yet.  Internal beta testing for your organization fine and encouraged.

## New to Version 4.2 ##
### See the sample folder for examples for the new and improved fields. ###
* Additional Typography features:  Top and bottom margins, text shadow.
* New Media Image Filters (greyscale, sepia, opacity, contrast, invert, blur, saturate, brightness, hue-rotate).
* New Gradient Field Filters (type, reach, angle), including output for autogenerated CSS.
* New Box Shadow field with output for autogenerated CSS.
* New Flyout Submenus: `flyout_submenus` global arg.
* New Alpha color option for color field: `color_alpha` field arg for fields that support color pickers.
* Removed: `async_typography` global arg.  Google no longer supports it.  Use `font_display` with one of the following `auto|block|swap|fallback|optional`.  See: [https://developer.mozilla.org/en-US/docs/Web/CSS/@font-face/font-display](https://developer.mozilla.org/en-US/docs/Web/CSS/@font-face/font-display)
* Automatic update option for Google Fonts without a Pro subscription.

## Follow us on Social Media! ##
[![Follow us on Twitter](https://www.download82.com/images/produse/iconuri/twitter-for-android.png "Follow us on Twitter")](https://www.twitter.com/ReduxFramework)
[![Like us on Facebook](https://addons.thunderbird.net/user-media/addon_icons/79/79494-64.png "Like us on Facebook")](https://www.facebook.com/ReduxFramework/)

## Changelog ##
See [Changelog.md](https://github.com/reduxframework/redux-framework/blob/master/CHANGELOG.md)

## Documentation ##
Need a little help with Redux?  Come check out our brand-new documentation site at  [devs.redux.io](http://devs.redux.io), chock-full of tutorials and examples!



## Template and Pattern Library

Redux Framework includes access to the Extendify template and pattern library that can be accessed by clicking the "Library" button in the menu bar of the editor. We provide a variety of templates and patterns to serve different use cases and are adding more templates every week.

## Privacy

The Extendify library uses a custom API to fetch block patterns and page layouts from our servers. API requests are only made when a user clicks on the Library button. In order to provide and improve this service, Extendify passes site data along with an API request, including:

* Browser

* Referring site

* Category selection

* WP language

* Active theme

* Active plugins

* Anonymized UUID

* Anonymized IP address

By accessing the Extendify library, you agree to the Extendify [privacy policy](https://extendify.com/privacy-policy) and [terms of service](https://extendify.com/terms-of-service).

## Help Us Translate Redux ##
Please head over to the plugin page to learn how you can help us translate Redux quickly. Any and all are translations are welcome. We appreciate your help!
https://translate.wordpress.org/projects/wp-plugins/redux-framework/

## Features ##
* Uses the [WordPress Settings API](http://codex.wordpress.org/Settings_API "WordPress Settings API")
* Multiple built in field types
* Multiple layout field types
* Fields can be overloaded with a callback function, for custom field types
* Easily extendable by creating Field Classes
* Built in Validation Classes
* Easily extendable by creating Validation Classes
* Custom Validation error handling, including error counts for each section, and custom styling for error fields
* Custom Validation warning handling, including warning counts for each section, and custom styling for warning fields
* Multiple Hook Points for customisation
* Import / Export Functionality - including cross site importing of settings
* Easily add page help through the class
* Fully responsive options panel
* Much more

## What's new in version 4? ##

### Core Rewrite
Our code base has been rebuilt from the ground up.  With compartmentalized code,  autoloading, and class inheritance, Redux is now faster and more efficient than it’s ever been!

### Top of the Line Security!
Redux meets security standards laid out by WordPress Coding Standards, WordPress VIP Standards, and ThemeForest Guidelines.  Focus includes escaping, sanitizing, and nonces verification, and database query prep/caching.

### Gutenberg Template Library
Supercharge the Gutenberg editor with our ever-growing library of WordPress Blocks and templates. Discover what’s possible and implement any design on your website in virtually no time at all.  See the [WordPress plugin page](https://wordpress.org/plugins/redux-framework/#description) for much more information!

### Automatic Google Font Updates.
This is one of the crown jewels of Redux v4!  Your users will have the ability to update Google Fonts as updates are available or automatic ‘behind the scenes’ updates.  No more waiting for updates and no API key required!

### Field Sanitizing
Field sanitizing allows one to pass an array of function names as an argument to a field in which the return value will be the sanitizing string.  This feature will only work with text based fields including text, textarea, and multi_text (ACE Editor and WP Editor not included).

One may use any existing function including PHP functions, WordPress functions and custom written functions.  The return value of any used function must be that of a string.  Any other return value will be disregarded.

Please view the [sample-config.php](https://github.com/reduxframework/redux-framework/blob/master/sample/sample-config.php) file for specific examples.

### Select2 AJAX Loading
The AJAX loading routines for the select2 fields have been fixed/finished.  See the 'capabilities' field in the demo panel for an example.  

For the interim, this feature will only work when used in conjunction with the `data` argument (that is, the one that fetches WordPress data).  

To set AJAX loading, add the `'ajax' => true` argument to your select field.  The `min_input_length` argument may also be added to specify how many characters should be typed before results are shown.  Default is `1`.

### Field/Section Disabling
This feature has been request quite a few times over the years.  Fields and sections can now be disabled by adding the `'disabled' => true` argument to either a section or a field.  The section or field will then appear 'greyed out' and not respond to input.  This comes in handy in the event one may want to offer teasers for premium versions of their products.

Since those with a little CSS know-how could easily reactivate disabled fields with a little CSS, we took the added precaution of having Redux remove any `name` attributes on disabled fields/sections.  This way, even if a clever user reactivates the field, it will never save.

### Updated Panel Interface
The option panel interface has been brought up to date with the current WordPress admin design.  It is also now ‘theme aware’.  Panel colors will now follow suit with the selected admin theme.

### Improved Field Validation
Due to the need for multiple field validations, Redux now supports an array of validations versus the previously limiting single argument.  Validation results now appear in real time after a save without the need for page refresh.

### Full v3 Backward Compatibility
We take backward compatibility very seriously here and strive to maintain it.  Redux v4 has been designed to act as a drop in replacement to offer new functionality without breaking existing functionality.

## FAQs ##

1. Why should we use ```require_once``` instead of ```get_template_part```?
* First, because ```get_template_part``` is for... you guessed it, themes! Redux is designed to work with both themes *and* plugins.
* Second, read [this](http://kovshenin.com/2013/get_template_part/).
2. Why shouldn't we edit ```sample-config.php``` in the plugin directory?
* Because ```sample-config.php``` will be replaced at each update of the plugin. You will lose all your work.
