<?php

namespace App\Controllers;

use Sober\Controller\Controller;

class App extends Controller
{
    public function siteName()
    {
        return get_bloginfo('name');
    }

    public static function title()
    {
        if (is_home()) {
            if ($home = get_option('page_for_posts', true)) {
                return get_the_title($home);
            }
            return __('Latest Posts', 'sage');
        }
        if (is_archive()) {
            return get_the_archive_title();
        }
        if (is_search()) {
            return sprintf(__('Search Results for %s', 'sage'), get_search_query());
        }
        if (is_404()) {
            return __('Not Found', 'sage');
        }
        return get_the_title();
    }

    public static function imageWithAlt(array $image_id): array
    {

        if (!empty($image_id)) {
            $image['image'] = $image_id['url'];
            $image['alt']   = $image_id['alt'];
            $srcSet = $image_id['sizes'] ?? " ";
            if (isset($srcSet['thumbnail'])) {
                $image['small'] = $srcSet['thumbnail'] . " " . $srcSet['thumbnail-width'] . "w,";

                $image['medium'] = $srcSet['medium'] . " " . $srcSet['medium-width'] . 'w,';
                $image['large']  = $srcSet['large'] . " " . $srcSet['large-width'] . 'w,';
                $image['1536']   = $srcSet['1536x1536'] . " " . $srcSet['1536x1536-width'] . 'w,';
                $image['2048']   = $srcSet['2048x2048'] . " " . $srcSet['2048x2048-width'] . 'w';
            }
            $image['caption'] = wp_get_attachment_caption($image_id['id']);

            return $image;
        }
    }

    public static function getReviews(int $number = 0)
    {
        if (!empty($number)) {
            $args = array(
                'post_type' => 'reviews',
                'tax_query' => array(
                    array(
                        'taxonomy' => 'groups',
                        'field' => 'term_id',
                        'terms' => $number
                    )
                ),
                'posts_per_page' => -1
            );
        } else {
            $args = array(
                'post_type' => 'reviews',
                'orderby' => 'DESC',
                'posts_per_page' => 10
            );
        }
        $query = new \WP_Query($args);
        $data = [];
        if ($query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();
                $data[get_the_ID()]['name'][] = get_field("name", get_the_ID());
                $data[get_the_ID()]['review'][] = get_field("review", get_the_ID());
                $data[get_the_ID()]['rating'][] = get_field("rating", get_the_ID());
                $image = get_field("logo", get_the_ID());
                $data[get_the_ID()]['logo'][] = \App\Controllers\App::imageWithAlt($image);
                $data[get_the_ID()]['date'][] = get_field("date", get_the_ID());
                $data[get_the_ID()]['review_title'][] = get_field('review_title', get_the_ID());
                $data[get_the_ID()]['external_review_link'][] = get_field('external_review_link', get_the_ID());
            }
            return $data;
        } else {
            return "No posts found";
        }
    }

    public static function checkImgExtension(string $imagetype)
    {
        return  $ext = pathinfo($imagetype, PATHINFO_EXTENSION);
    }

    public static function inlineStyle(array $padding = [], String $block = '')
    {
        if (array_key_exists("block_padding", $padding)) {
            $padding_top = $padding['block_padding']["padding_top"];
            $padding_bottom = $padding['block_padding']["padding_bottom"];
            $padding_top_tablet = $padding['block_padding']['padding_top_tablet'];
            $padding_bottom_tablet = $padding['block_padding']['padding_bottom_tablet'];
            $padding_top_mobile = $padding['block_padding']['padding_top_mobile'];
            $padding_bottom_mobile = $padding['block_padding']['padding_bottom_mobile'];
        } else {
            $padding_top = $padding["padding_top"];
            $padding_bottom = $padding["padding_bottom"];
            $padding_top_tablet = $padding['padding_top_tablet'];
            $padding_bottom_tablet = $padding['padding_bottom_tablet'];
            $padding_top_mobile = $padding['padding_top_mobile'];
            $padding_bottom_mobile = $padding['padding_bottom_mobile'];
        }


        return "
                <style>
                  [data-{$block}] {
                    padding-top: {$padding_top}px;
                    padding-bottom: {$padding_bottom}px;
                  }
                  @media (max-width: 768px) {
                    [data-{$block}] {
                      padding-top: {$padding_top_tablet}px;
                      padding-bottom: {$padding_bottom_tablet}px;
                    }
                  }
                  @media (max-width: 575px) {
                    [data-{$block}] {
                    padding-top: {$padding_top_mobile}px;
                    padding-bottom: {$padding_bottom_mobile}px;
                    }
                  }
                </style>
                ";
    }

    public static function startRating(float $average)
    {
         $remainder = fmod($average, 1);
         $rounded = $average - $remainder;
         $stars = array();
        for ($i=0; $i<$rounded+1; $i++) {
            $stars['full'] = $i;
        }
        if ($remainder > 0 && $remainder <= 0.4) {
            $stars['half'] = "star-4";
        } else if ($remainder > 0.4 && $remainder < 0.6) {
            $stars['half'] = "star-5";
        } else if ($remainder > 0.5 && $remainder < 0.7) {
            $stars['half'] = "star-6";
        } else if ($remainder > 0.6 && $remainder <= 0.8) {
            $stars['half'] = "star-7";
        } else if ($remainder > 0.8) {
            $stars['half'] = "star-8";
        }


         return $stars;
    }

    public static function setPhoneNumbers($page_id)
    {
        $default_phone_number = get_field("default_phone_number", "option");
        $page_different_numbers = get_field("additional_phone_numbers", "option");

        $expire= time()+60*60*24*30;
        if (!empty($_GET['phone'])) {
            $ref_id = $_GET['phone'];
            setcookie("phone", $ref_id, $expire, '/', $_SERVER['SERVER_NAME']); //TODO change domen
            return $ref_id;
        }

        if (isset($_COOKIE['phone'])) {
            return $_COOKIE['phone'];
        }

        if (!empty($default_phone_number) && empty($page_different_numbers)) {
            return $default_phone_number;
        }

        if (!empty($page_different_numbers)) {
            foreach ($page_different_numbers as $page_different_number) {
                if ($page_id === $page_different_number['select_page']) {
                    return $page_different_number['new_phone_number'];
                }
            }
            return $default_phone_number;
        }
    }

    public static function blogPosts(int $num = 3)
    {
        $args = array(
            'post_type' => 'post',
            'orderby' => 'DESC',
            'posts_per_page' => $num
        );

        $query = new \WP_Query($args);
        $data = [];
        if ($query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();
                $data[get_the_ID()]['title'][] = get_the_title();
                $data[get_the_ID()]['permalink'][] = get_permalink();
                $thumb = get_post_thumbnail_id(get_the_ID());
                $image = wp_get_attachment_image_src($thumb, 'full');
                $image_alt = get_post_meta($thumb, "_wp_attachment_image_alt", true);
                $post_date = get_the_date('m/d Y');
                $data[get_the_ID()]['image'][] = $image[0];
                $data[get_the_ID()]['alt'][] = $image_alt;
                $data[get_the_ID()]['date'][] = $post_date;
            }
        } else {
            echo "no posts found";
        }

        return $data;
    }

    public static function getPostReadTime(int $post_id)
    {
        $post = get_post($post_id);
        $category = get_the_category( $post_id );
        $the_content = $post->post_content;
        $string_content = preg_replace('/\s+/', ' ', trim($the_content));
        $words = explode(" ", $string_content);
        $words_count = count($words);
        $minute = floor($words_count / 300);
        if ( $minute < 1 ) {
            if ( $category[0]->slug == 'videos' ) {
                $estimate = '1 min to read';
            } else {
                $estimate = '< 1 min to read';
            }
        } else {
            $estimate = $minute . ' min to read';
        }

        return $estimate;
    }

    public static function returnCategories()
    {
        $categories = get_categories(array(
            'orderby' => 'name',
            'order'   => 'ASC',
            'type' => 'post'
        ));
        $data = [];

        foreach ($categories as $category) {
            $data['cat_id'][] = $category->term_id;
            $data['cat_name'][] = $category->name;
            $data['cat_slug'][] = $category->slug;
            $data['cat_url'][] = get_category_link($category->term_id);
        }

        return $data;
    }

    public static function returnCPTcats($taxonomy)
    {
        $args = array(
            'type'                     => 'help-center',
            'child_of'                 => 0,
            'parent'                   => '',
            'orderby'                  => 'name',
            'order'                    => 'DESC',
            'hide_empty'               => 1,
            'hierarchical'             => 1,
            'taxonomy'                 => $taxonomy,
            'pad_counts'               => false );

        $cats = get_categories($args);
        $data = [];
        foreach ($cats as $cat) {
                $data['cat_name'][] = $cat->name;
                $data['cat_id'][] = $cat->term_id;
                $data['cat_slug'][] = $cat->slug;
                $data['cat_url'][] = get_term_link($cat->term_id);
                $data['cat_image'][] = get_field('icon_taxonomy', $cat->taxonomy . '_' . $cat->term_id);
        }
        return $data;
    }

    public static function returnCPTposts($type, $cat , $taxonomy = 'helpcenter-category', $num = -1, $posts = [])
    {
        $args = array(
            'post_type' => $type,
            'tax_query' => array(
                array(
                    'taxonomy' => $taxonomy,
                    'field'    => 'term_id',
                    'terms'    => $cat,
                ),
            ),
            'orderby' => 'post__in',
            'posts_per_page' => $num,
            'post__in' => (!empty($posts)) ? $posts : null
        );

        $query = new \WP_Query($args);
        $data = [];
        if ($query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();
                $data['title'][] = get_the_title();
                $data['permalink'][] = get_permalink();
            }
        }

        return $data;
    }

    public static function returnPostsfromHC($cat, $num = 5, $posts = [])
    {
        $args = array(
            'post_type' => "help-center",
            'tax_query' => array(
                array(
                    'taxonomy' => 'helpcenter-category',
                    'field'    => 'term_id',
                    'terms'    => $cat,
                ),
            ),
            'orderby' => 'post__in',
            'posts_per_page' => $num,
            'post__in' => (!empty($posts)) ? $posts : null
        );
        $query = new \WP_Query($args);
        $data = [];
        if ($query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();
                $data['title'][] = get_the_title();
                $data['permalink'][] = get_permalink();
            }
        }
        wp_reset_postdata();
        return $data;
    }

    public static function breadcrumb()  {
        $separator = '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="9" height="28" viewBox="0 0 9 28" class="breadcrumb-separator"><title>angle-right</title><path d="M9.297 15c0 0.125-0.063 0.266-0.156 0.359l-7.281 7.281c-0.094 0.094-0.234 0.156-0.359 0.156s-0.266-0.063-0.359-0.156l-0.781-0.781c-0.094-0.094-0.156-0.219-0.156-0.359 0-0.125 0.063-0.266 0.156-0.359l6.141-6.141-6.141-6.141c-0.094-0.094-0.156-0.234-0.156-0.359s0.063-0.266 0.156-0.359l0.781-0.781c0.094-0.094 0.234-0.156 0.359-0.156s0.266 0.063 0.359 0.156l7.281 7.281c0.094 0.094 0.156 0.234 0.156 0.359z"></path></svg>';        ;
        global $post;
        if (is_archive() || is_single()) {
            $first_url = '/blog/';
            $first_url_name = esc_html__('Montway\'s blog');
        } else {
            $first_url = get_option('home');
            $first_url_name = esc_html__('Home');
        }
        if (!is_front_page()) {
            $output = '<p class="breadcrumbs">';
            $output .= '<a class="is-underline" href="';
            $output .= $first_url;
            $output .= '">';
            $output .= $first_url_name;
            $output .= '</a>' . $separator;

            if (is_category() || is_single()) {
                $categories = get_the_category();
                if (!empty($categories)) {
                    $output .= '<a class="is-underline" href="'. get_category_link($categories[0]) .'">' . esc_html($categories[0]->name) . '</a>';
                }
                // $address_book = get_the_terms($post->ID, 'categories');
                // if (!empty($address_book)) {
                //     foreach ($address_book as $item) {
                //         $address_book_name = $item->name;
                //         $address_book_url = get_category_link($item->term_id);
                //     }
                //     $output .= '<a href="' . $address_book_url . '">' . $address_book_name . '</a>';
                // }
            } else if (is_archive() || is_single()) {
                if (is_day()) {
                    printf(__('%s', 'montway'), get_the_date());
                } elseif (is_month()) {
                    printf(__('%s', 'montway'), get_the_date(_x('F Y', 'monthly archives date format', 'montway')));
                } elseif (is_year()) {
                    printf(__('%s', 'montway'), get_the_date(_x('Y', 'yearly archives date format', 'montway')));
                } else {
                    //_e( 'Blog Archives', 'montway' );
                    $output .= '<a>' . single_term_title('', false) . '</a>';
                }
            }


            if (is_single()) {
                $output .= $separator;
                $output .= '<a  class="'. get_the_permalink() .'">' . get_the_title() . '</a>';
            }


            $output .= '</pre>';

            return $output;
        }
    }

    public static function RelatedBlogPosts(int $num = 6, int $id)
    {
        $args = array(
            'post_type' => 'post',
            'orderby' => 'rand',
            'posts_per_page' => $num,
            'category__in' => wp_get_post_categories($id),
            'post__not_in' => array($id)
        );

        $query = new \WP_Query($args);
        $data = [];
        if ($query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();
                $data[get_the_ID()]['title'][] = get_the_title();
                $data[get_the_ID()]['permalink'][] = get_permalink();
                $thumb = get_post_thumbnail_id(get_the_ID());
                $image = wp_get_attachment_image_src($thumb, 'full');
                $image_alt = get_post_meta($thumb, "_wp_attachment_image_alt", true);
                $post_date = get_the_date('m/d Y');
                $data[get_the_ID()]['image'][] = $image[0];
                $data[get_the_ID()]['alt'][] = $image_alt;
                $data[get_the_ID()]['date'][] = $post_date;
                $data[get_the_ID()]['time_to_read'][] = self::getPostReadTime(get_the_ID());
                $category = get_the_category(get_the_ID());
                foreach ($category as $cat) {
                    $data[get_the_ID()]['category_name'][] = $cat->name;
                    $data[get_the_ID()]['cat_url'][] = get_category_link($cat->term_id);
                }
                $data[get_the_ID()]['id'][] = get_the_ID();
            }
        } else {
            echo "no posts found";
        }

        return $data;
    }

    public static function custom_pagination($pages = '', $range = 2) {
         $showitems = ($range * 2)+1;

         global $paged;
         if(empty($paged)) $paged = 1;

         if($pages == '') {
             global $wp_query;
             $pages = $wp_query->max_num_pages;
             if(!$pages) {
                 $pages = 1;
             }
         }

         if(1 != $pages) {
             echo "<div class='pagination justify-content-center py-2 py-md-4 mb-56 mb-2'>";
             if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a class='pag-number' href='".get_pagenum_link(1)."'>&laquo;</a>";
             if($paged > 1 && $showitems < $pages) echo "<a class='pag-number' href='".get_pagenum_link($paged - 1)."'>&lsaquo;</a>";

             for ($i=1; $i <= $pages; $i++) {
                 if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems )) {
                     echo ($paged == $i)? "<span class='current pag-number'>".$i."</span>":"<a href='".get_pagenum_link($i)."' class='inactive pag-number' >".$i."</a>";
                 }
             }

             if ($paged < $pages && $showitems < $pages) echo "<a class='pag-number' href='".get_pagenum_link($paged + 1)."'>&rsaquo;</a>";
             if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<a class='pag-number' href='".get_pagenum_link($pages)."'>&raquo;</a>";
             echo "</div>\n";
         }
    }

    /**
     * Get ID of the first ACF block on the page
     */
    public static function sg_get_first_block_id() {
        $post = get_post(); 

        if(has_blocks($post->post_content)) {
            $blocks = parse_blocks($post->post_content);
            $first_block_attrs = $blocks[0]['attrs'];

            if(array_key_exists('id', $first_block_attrs)) {
                return $first_block_attrs['id'];
            }
        }
    }

}
