<?php

namespace App\Controllers;



use DOMDocument;

class Twitter
{


    private $regex = '#^https?://twitter\.com/(?:\#!/)?(\w+)/status(es)?/(\d+)$#i';


    function __construct()
    {
        add_shortcode('tweet', array( $this, 'tweet_shortcode_handler' ));
        wp_embed_register_handler('twitter-embed', $this->regex, array( $this, 'tweet_embed_handler' ));
        add_filter('pre_kses', array( $this, 'tweet_embed_reversal' ));
    }

    function tweet_embed_reversal($content)
    {
        if (preg_match('#<blockquote class="twitter-tweet">(.+)</blockquote>#', $content, $matches)) {
            $tweet_content = $matches[1];
            $doc = new DomDocument;
            $doc->loadHTML($tweet_content);
            $links = $doc->getElementsByTagName('a');
            foreach ($links as $link) {
                $link = $link->getAttribute('href');
                if (preg_match($this->regex, $link)) {
                    $content = str_replace($matches[0], '[tweet ' . esc_url($link) . ']', $content);
                    break;
                }
            }
        }

        return $content;
    }

    function tweet_embed_handler($matches, $attr, $url, $rawattr)
    {
        return $this->tweet_shortcode_handler(array( $url ));
    }

    public function tweet_shortcode_handler($atts)
    {
        global $post, $content_width;

        if (! isset($atts[0]) || ! preg_match($this->regex, $atts[0], $matches)) {
            return;
        }

        $url = $atts[0];
        $author = $matches[1];
        $tweet_id = $matches[3];
        $meta_key = '_tweet-' . $tweet_id;

        $tweet = get_post_meta($post->ID, $meta_key, true);

        if (! $tweet || empty($tweet)) {
            $query_args = array( 'id' => $tweet_id, 'lang' => 'en', 'maxwidth' => $content_width );
            $response = wp_remote_get(add_query_arg($query_args, 'https://api.twitter.com/1/statuses/oembed.json'));
            if (! is_wp_error($response)) {
                $body = wp_remote_retrieve_body($response);
                $tweet = json_decode($body);
                $tweet = $tweet->html;
            } else {
                trigger_error($response->get_error_message());
            }
        }

        $tweet = str_replace('style=";width: 550px!important;"', '', $tweet);
        $tweet = str_replace('width="550"', '', $tweet);
        return $tweet;
    }
}
