<?php

namespace App;

/**
 * Add <body> classes
 */
add_filter('body_class', function (array $classes) {
    /** Add page slug if it doesn't exist */
    if (is_single() || is_page() && !is_front_page()) {
        if (!in_array(basename(get_permalink()), $classes)) {
            $classes[] = basename(get_permalink());
        }
    }

    /** Add class if sidebar is active */
    if (display_sidebar()) {
        $classes[] = 'sidebar-primary';
    }

    /** Clean up class names for custom templates */
    $classes = array_map(function ($class) {
        return preg_replace(['/-blade(-php)?$/', '/^page-template-views/'], '', $class);
    }, $classes);

    return array_filter($classes);
});

/**
 * Add "… Continued" to the excerpt
 */
add_filter('excerpt_more', function () {
    return '...';
});

/**
 * Template Hierarchy should search for .blade.php files
 */
collect([
    'index', '404', 'archive', 'author', 'category', 'tag', 'taxonomy', 'date', 'home',
    'frontpage', 'page', 'paged', 'search', 'single', 'singular', 'attachment', 'embed'
])->map(function ($type) {
    add_filter("{$type}_template_hierarchy", __NAMESPACE__.'\\filter_templates');
});

/**
 * Render page using Blade
 */
add_filter('template_include', function ($template) {
    collect(['get_header', 'wp_head'])->each(function ($tag) {
        ob_start();
        do_action($tag);
        $output = ob_get_clean();
        remove_all_actions($tag);
        add_action($tag, function () use ($output) {
            echo $output;
        });
    });
    $data = collect(get_body_class())->reduce(function ($data, $class) use ($template) {
        return apply_filters("sage/template/{$class}/data", $data, $template);
    }, []);
    if ($template) {
        echo template($template, $data);
        return get_stylesheet_directory().'/index.php';
    }
    return $template;
}, PHP_INT_MAX);

/**
 * Render comments.blade.php
 */
add_filter('comments_template', function ($comments_template) {
    $comments_template = str_replace(
        [get_stylesheet_directory(), get_template_directory()],
        '',
        $comments_template
    );

    $data = collect(get_body_class())->reduce(function ($data, $class) use ($comments_template) {
        return apply_filters("sage/template/{$class}/data", $data, $comments_template);
    }, []);

    $theme_template = locate_template(["views/{$comments_template}", $comments_template]);

    if ($theme_template) {
        echo template($theme_template, $data);
        return get_stylesheet_directory().'/index.php';
    }

    return $comments_template;
}, 100);

// register category for acf blocks
add_filter('block_categories_all', function ($categories, $post) {

    $category_slugs = wp_list_pluck($categories, 'slug');
    return in_array('montway_blocks', $category_slugs, true) ? $categories : array_merge(
        $categories,
        array(
            array(
                'slug'  => 'montway_blocks',
                'title' => __(' Montway Blocks', 'montway'),
                'icon'  => null,
            ),
        )
    );
}, 10, 2);

add_filter('block_categories_all', function ($categories, $post) {

    $category_slugs = wp_list_pluck($categories, 'slug');
    return in_array('help_center_blocks', $category_slugs, true) ? $categories : array_merge(
        $categories,
        array(
            array(
                'slug'  => 'help_center_blocks',
                'title' => __(' Help Center Blocks', 'montway'),
                'icon'  => null,
            ),
        )
    );
}, 10, 2);

add_filter("upload_mimes", function ($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
});
add_filter('nav_menu_link_attributes', function ($atts, $item, $args) {
    $class = 'is-underline'; // or something based on $item
    if ($args->menu_id == 'footer-nav') {
        $atts['class'] = $class;
    }
    return $atts;
}, 10, 4);

add_filter("nav_menu_link_attributes", function ($classes, $item, $args) {
    if (isset($args->add_a_class)) {
        $classes['class'] = $args->add_a_class;
    }
    return $classes;
}, 1, 3);

add_filter('post_thumbnail_html', function ($html) {
    // If there is no post thumbnail,
    // Return a default image
    global $post;
    $id = $post->id;
    if ('' == $html) {
        if (in_category('videos')) {
            return '<img src="'. home_url() .'/app/uploads/2022/01/default-videos.png"  alt="'. get_the_title($id) .'"/>';
        } else if (in_category('company-news')) {
            return '<img src="'. home_url() .'/app/uploads/2022/01/default-company-news.png"  alt="'. get_the_title($id) .'"/>';
        } else {
            return '<img src="'. home_url() .'/app/uploads/2021/12/default.jpg"  alt="'. get_the_title($id) .'"/>';
        }
    }
    // Else, return the post thumbnail
    return $html;
});
// only search title and not post content
add_filter('posts_search', function ($search) {
   // remove_filter('posts_search', 'only_title_search_wpse_119422');

    global $wpdb;

    $pattern = "/\({$wpdb->posts}.post_title[^)]+\)/";
    preg_match_all($pattern, $search, $matches);

    if (! empty($matches[0])) {
        $search = sprintf(
            " AND (%s)",
            implode(" AND ", $matches[0])
        );
    }

    return $search;
});

/*add_filter('post_type_link', function ($post_link, $post) {
    if (is_object($post) && $post->post_type === 'help-center') {
        $terms = wp_get_object_terms($post->ID, 'helpcenter-category');
        $tags = wp_get_object_terms($post->ID, 'helpcenter-tags');
        if ($terms) {
            return str_replace('%helpcenter-category%', $terms[0]->slug, $post_link);
        }elseif ($tags){
            return str_replace('%helpcenter-category%', $tags[0]->slug, $post_link);
        }
    } else {
        return $post_link;
    }
}, 1, 2);*/


add_filter('the_content', function ($content) {
    if (is_single()) {
        // match any youtube iframes
        $pattern = '~<iframe[^>]*src\s*=\s*"?https?:\/\/[^\s"\/]*youtube.com(?:\/[^\s"]*)?"?[^>]*>.*?<\/iframe>|<iframe[^>]*src\s*=\s*"?https?:\/\/[^\s"\/]*player.vimeo.com(?:\/[^\s"]*)?"?[^>]*>.*?<\/iframe>~';
        preg_match_all($pattern, $content, $matches);

        if (strpos($content, 'embed-responsive') == false) {
            foreach ($matches[0] as $match) {
                // wrap matched iframe with div
                $wrappedframe = '<div class="embed-responsive embed-responsive-16by9">' . $match . '</div>';

                //replace original iframe with new in content
                $content = str_replace($match, $wrappedframe, $content);
            }
            return $content;
        }
    }
    return $content;
});

add_filter('user_trailingslashit', function ($string, $type) {
    if ($type == 'page' && !is_page('help-center')) {
        $string = untrailingslashit($string);
    }
    return $string;
}, 70, 2);
remove_filter('template_redirect','redirect_canonical');