<?php

namespace App;

use Roots\Sage\Container;
use Roots\Sage\Assets\JsonManifest;
use Roots\Sage\Template\Blade;
use Roots\Sage\Template\BladeProvider;

/**
 * Theme assets
 */
add_action('wp_enqueue_scripts', function () {
    wp_enqueue_style('sage/main.css', asset_path('styles/main.css'), false, null);
    wp_enqueue_script('sage/main.js', asset_path('scripts/main.js'), ['jquery'], null, true);

    if (is_single() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}, 100);
add_action('wp_enqueue_scripts', function () {
    wp_dequeue_style('wp-block-library');
    wp_dequeue_style('wp-block-library-theme');
    wp_dequeue_style('wc-blocks-style'); // Remove WooCommerce block CSS
    wp_dequeue_script('wpgmza_data');
    if (!is_singular('post')) {
        wp_dequeue_style('toc-screen');
        wp_dequeue_script('toc-front');
    }
    if (!is_singular('help-center')) {
        wp_dequeue_style('wp-postratings');
        wp_dequeue_script('wp-postratings');
    }
}, 100);
add_action('wp_footer', function () {
    wp_enqueue_script('sage/lazy.js', asset_path('scripts/lazy.js'), ['jquery'], null, true);
    wp_enqueue_script('wpgmza_data');
});
/**
 * Theme setup
 */
add_action('after_setup_theme', function () {
    /**
     * Enable features from Soil when plugin is activated
     * @link https://roots.io/plugins/soil/
     */
    add_theme_support('soil-clean-up');
    add_theme_support('soil-jquery-cdn');
    add_theme_support('soil-nav-walker');
    add_theme_support('soil-nice-search');
    add_theme_support('soil-relative-urls');

    /**
     * Enable plugins to manage the document title
     * @link https://developer.wordpress.org/reference/functions/add_theme_support/#title-tag
     */
    add_theme_support('title-tag');

    /**
     * Register navigation menus
     * @link https://developer.wordpress.org/reference/functions/register_nav_menus/
     */
    register_nav_menus([
        'primary_navigation' => __('Primary Navigation', 'sage')
    ]);
    register_nav_menus([
        'footer_top_navigation' => __('Footer Top Navigation', 'sage')
    ]);
    register_nav_menus([
        'footer_navigation' => __('Footer Navigation', 'sage')
    ]);
    register_nav_menus([
        'cta_navigation' => __('CTA Navigation', 'sage')
    ]);
    register_nav_menus([
        'top_bar_nav' => __('Top Bar Navigation', 'sage')
    ]);
    register_nav_menus([
        'cta_mob_navigation' => __('CTA Mobile Navigation', 'sage')
    ]);
    register_nav_menus([
        'states_navigation' => __('States Navigation', 'sage')
    ]);
    register_nav_menus([
        'blog_category_navigation' => __('Blog Category Navigation', 'sage')
    ]);

    /**
     * Enable post thumbnails
     * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
     */
    add_theme_support('post-thumbnails');

    /**
     * Enable HTML5 markup support
     * @link https://developer.wordpress.org/reference/functions/add_theme_support/#html5
     */
    add_theme_support('html5', ['caption', 'comment-form', 'comment-list', 'gallery', 'search-form']);

    /**
     * Enable selective refresh for widgets in customizer
     * @link https://developer.wordpress.org/themes/advanced-topics/customizer-api/#theme-support-in-sidebars
     */
    add_theme_support('customize-selective-refresh-widgets');

    /**
     * Use main stylesheet for visual editor
     * @see resources/assets/styles/layouts/_tinymce.scss
     */
    add_editor_style(asset_path('styles/main.css'));
}, 20);

/**
 * Register sidebars
 */
add_action('widgets_init', function () {
    $config = [
        'before_widget' => '<section class="widget %1$s %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>'
    ];
    register_sidebar([
        'name'          => __('Primary', 'sage'),
        'id'            => 'sidebar-primary'
    ] + $config);
    register_sidebar([
        'name'          => __('Footer', 'sage'),
        'id'            => 'sidebar-footer'
    ] + $config);
});

/**
 * Updates the `$post` variable on each iteration of the loop.
 * Note: updated value is only available for subsequently loaded views, such as partials
 */
add_action('the_post', function ($post) {
    sage('blade')->share('post', $post);
});

/**
 * Setup Sage options
 */
add_action('after_setup_theme', function () {
    /**
     * Add JsonManifest to Sage container
     */
    sage()->singleton('sage.assets', function () {
        return new JsonManifest(config('assets.manifest'), config('assets.uri'));
    });

    /**
     * Add Blade to Sage container
     */
    sage()->singleton('sage.blade', function (Container $app) {
        $cachePath = config('view.compiled');
        if (!file_exists($cachePath)) {
            wp_mkdir_p($cachePath);
        }
        (new BladeProvider($app))->register();
        return new Blade($app['view']);
    });

    /**
     * Create @asset() Blade directive
     */
    sage('blade')->compiler()->directive('asset', function ($asset) {
        return "<?= " . __NAMESPACE__ . "\\asset_path({$asset}); ?>";
    });
});

add_action("init", function () {

    $labels = array(
    'name' => _x('Reviews', 'Post Type General Name', 'montway'),
    'singular_name' => _x('Review', 'Post Type Singular Name', 'montway'),
    'menu_name' => __('Reviews', 'montway'),
    'parent_item_colon' => __('Parent Review', 'montway'),
    'all_items' => __('All Reviews', 'montway'),
    'view_item' => __('View Reviews', 'montway'),
    'add_new_item' => __('Add New Review', 'montway'),
    'add_new' => __('Add New', 'montway'),
    'edit_item' => __('Edit Review', 'montway'),
    'update_item' => __('Update Review', 'montway'),
    'search_items' => __('Search Reviews', 'montway'),
    'not_found' => __('Not Found', 'montway'),
    'not_found_in_trash' => __('Not found in Trash', 'montway'),
    );

    $args = array(
    'label' => __('reviews', 'montway'),
    'description' => __('Reviews', 'montway'),
    'labels' => $labels,
    'supports' => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
    'hierarchical' => false,
    'public' => true,
    'show_ui' => true,
    'show_in_menu' => true,
    'show_in_nav_menus' => true,
    'show_in_admin_bar' => true,
    'menu_position' => 5,
    'can_export' => true,
    'has_archive' => true,
    'exclude_from_search' => false,
    'publicly_queryable' => false,
    'capability_type' => 'post',
    'show_in_rest' => true,
    'taxonomies' => array('groups'),
    'menu_icon' => 'dashicons-star-half'

    );
    register_post_type('reviews', $args);
});

add_action("init", function () {

    $labels = array(
    'name' => _x('Help Center', 'Post Type General Name', 'montway'),
    'singular_name' => _x('Help Center', 'Post Type Singular Name', 'montway'),
    'menu_name' => __('Help Center', 'montway'),
    'parent_item_colon' => __('Parent Help Center', 'montway'),
    'all_items' => __('All Help Center', 'montway'),
    'view_item' => __('View Help Center', 'montway'),
    'add_new_item' => __('Add New Help Center', 'montway'),
    'add_new' => __('Add New', 'montway'),
    'edit_item' => __('Edit Help Center', 'montway'),
    'update_item' => __('Update Help Center', 'montway'),
    'search_items' => __('Search Help Center', 'montway'),
    'not_found' => __('Not Found', 'montway'),
    'not_found_in_trash' => __('Not found in Trash', 'montway'),
    );

    $args = array(
    'label' => __('Help Center', 'montway'),
    'description' => __('Help Center', 'montway'),
    'labels' => $labels,
    'supports' => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
    'hierarchical' => true,
    'public' => true,
    'show_ui' => true,
    'show_in_menu' => true,
    'show_in_nav_menus' => true,
    'show_in_admin_bar' => true,
    'menu_position' => 6,
    'can_export' => true,
    'has_archive' => false,
    'exclude_from_search' => false,
    'publicly_queryable' => true,
    'capability_type' => 'post',
    'show_in_rest' => true,
    'rewrite'=> [
    'slug' => 'help-center',
    "with_front" => false,
    ],
    'menu_icon' => 'dashicons-editor-help',

    );
    register_post_type('help-center', $args);
    flush_rewrite_rules();
});

add_action("init", function () {

    $labels = array(
    'name' => _x('Tags', 'taxonomy general name'),
    'singular_name' => _x('Tag', 'taxonomy singular name'),
    'search_items' => __('Search Tags'),
    'popular_items' => __('Popular Tags'),
    'all_items' => __('All Tags'),
    'parent_item' => __('Parent Group'),
    'parent_item_colon' => __('Parent Group:'),
    'edit_item' => __('Edit Tag'),
    'update_item' => __('Update Tag'),
    'add_new_item' => __('Add New Tag'),
    'new_item_name' => __('New Tag Name'),
    'separate_items_with_commas' => __('Separate tags with commas'),
    'add_or_remove_items' => __('Add or remove tags'),
    'choose_from_most_used' => __('Choose from the most used tags'),
    'menu_name' => __('Tags'),
    );

    register_taxonomy('helpcenter-tags', array('help-center'), array(
    'hierarchical' => false,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'show_in_rest' => true,
    'rewrite' => array( 'slug' => 'tag', 'with_front' => false, 'has_archive' => true),
    ));
});

add_action("init", function () {
    $labels = array(
    'name' => _x('Groups', 'taxonomy general name'),
    'singular_name' => _x('Group', 'taxonomy singular name'),
    'search_items' => __('Search Groups'),
    'all_items' => __('All Groups'),
    'parent_item' => __('Parent Group'),
    'parent_item_colon' => __('Parent Group:'),
    'edit_item' => __('Edit Group'),
    'update_item' => __('Update Group'),
    'add_new_item' => __('Add New Group'),
    'new_item_name' => __('New Group Name'),
    'menu_name' => __('Groups'),
    );

    register_taxonomy('groups', array('reviews'), array(
    'hierarchical' => true,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'show_in_rest' => true,
    'rewrite' => array( 'slug' => 'group' ),
    ));
});

add_action("init", function () {
    $labels = array(
    'name' => _x('Categories', 'taxonomy general name'),
    'singular_name' => _x('Category', 'taxonomy singular name'),
    'search_items' => __('Search Categories'),
    'all_items' => __('All Categories'),
    'parent_item' => __('Parent Category'),
    'parent_item_colon' => __('Parent Category:'),
    'edit_item' => __('Edit Category'),
    'update_item' => __('Update Category'),
    'add_new_item' => __('Add New Category'),
    'new_item_name' => __('New Category Name'),
    'menu_name' => __('Categories'),
    );

    register_taxonomy('helpcenter-category', array('help-center'), array(
    'hierarchical' => false,
    'labels' => $labels,
    'show_ui' => true,
    'show_admin_column' => true,
    'query_var' => true,
    'show_in_rest' => true,
    'rewrite' => array( 'slug' => 'category', 'with_front' => false, 'has_archive' => true),
    ));
});


// counter shortcodes
add_shortcode("totalyears", function ($atts) {
    $a = shortcode_atts(array(
    'name' => get_field("total_years_in_business", "option")
    ), $atts);

    return $a['name'];
});

add_shortcode("totalcustomers", function ($atts) {
    $a = shortcode_atts(array(
    'name' => get_field("total_customers_served", "option")
    ), $atts);

    return $a['name'];
});

add_shortcode("totalvehicles", function ($atts) {
    $a = shortcode_atts(array(
    'name' => get_field("total_vehicles_delivered", "option")
    ), $atts);

    return $a['name'];
});

add_shortcode("totalcareers", function ($atts) {
    $a = shortcode_atts(array(
    'name' => get_field("total_carriers_in_our_network", "option")
    ), $atts);

    return $a['name'];
});

add_shortcode("totalcars", function ($atts) {
    $a = shortcode_atts(array(
    'name' => get_field("total_cars_shipped_annually", "option")
    ), $atts);

    return $a['name'];
});

add_shortcode("phones", function ($atts) {
    $page_id = get_queried_object_id();
    $number = \App\Controllers\App::setPhoneNumbers($page_id);
    $result = sprintf(
        "(%s) %s-%s",
        substr($number, 0, 3),
        substr($number, 3, 3),
        substr($number, 6)
    );
    $a = shortcode_atts(array(
    'phone' => $number,
    'format' => $result,
    'link' => ''
    ), $atts);
    if ($a['link'] == 'no_link') {
        return '<span class="text-blue no-link-phone set-phone-number">' . $a['format'] . '</span>';
    } else {
        return '<a class="text-blue is-underline set-phone-number" href="tel:'.$a['phone'].'">' . $a['format'] . '</a>';
    }
});
add_shortcode('info-text', function ($atts) {
    extract(shortcode_atts(array(
    'info_text' => ''
    ), $atts));
    $output = '';
    $output .= '<span class="info-wrap position-relative d-inline-block">';
    $output .= '<span class="info-icon d-inline-flex align-items-center justify-content-center position-relative"
      title="' . $info_text . '">i</span>';
    $output .= '</span>';
    return $output;
});
add_shortcode('cta-code', function () {
    $headline = get_field("title", 'options');
    $subtitle = apply_filters('the_content', get_field("subtitle", 'options'));

    $button = get_field("button", 'options');
    $button_text = $button["button_text"];
    $button_link = $button["button_link"];

    $image = get_field('background_image', 'options');
    if (!empty($image)) {
        $background_image = \App\Controllers\App::imageWithAlt($image);
        $background_image_type = \App\Controllers\App::checkImgExtension($image['filename']);
    }
    $output = '<div class="bg-white cta-center single-post-cta mb-4">';
    $output .= '<div class="container">';
      $output .= '<div class="row">';
         $output .= '<div class="col-12 mx-auto px-0">';
            $output .= '<div class="cta-box " style="background-image: url(' .  $background_image['image'] . ');">';
               $output .= ( !empty($headline) ) ? '<h3 class="mb-3 h3 font-weight-bold text-center">' . $headline . '</h3>' : '';
               $output .= ( !empty($subtitle) ) ? '<div class="text text-center mb-0">' . $subtitle . '</div>' : '';
               $output .= ( !empty($button_link) ) ? ' <a href="' .  $button_link . '" class="button-primary">' .
                  $button_text . '</a>' : '';
               $output .= '</div>';
            $output .= '</div>';
         $output .= '</div>';
      $output .= '</div>';
    $output .= '</div>';

    return $output;
});

add_actions(['wp_ajax_email_calculator', 'wp_ajax_nopriv_email_calculator'], function () {

/*
*
* validate email
*/
    $email_val = new Controllers\Curl();
    $email = [
    'data' => array(
    'type' => "Email",
    'attributes' => array(
    'email' => $_POST['email_address']
    )
    )
    ];
    $email_val->url("https://www.montway.com/checkout/api/message/verify")->method('post')->data($email)->send();

    if ($email_val->info['http_code'] == 200) {
        $email_cont = $email_val->content;
    }
    $response = json_decode($email_cont, true);
    $valid = $response['data']['attributes']['valid'];
    $valid_email = $response['data']['attributes']['email'];
    $email_val->close();
    $email_data = array('val' => $valid, 'email' => $valid_email);
    // $email_data = array('val' => true, 'email' => 'test@test.com');
    print_r(json_encode($email_data));
    die();
});

add_actions(['wp_ajax_calculator', 'wp_ajax_nopriv_calculator'], function () {
    if (check_ajax_referer('calculator_nonce')) {
        $city_from = filter_var($_POST['city_from'], FILTER_SANITIZE_STRING);
        $city_to = filter_var($_POST['city_to'], FILTER_SANITIZE_STRING);
        $transport_type = filter_var($_POST['transport_type'], FILTER_SANITIZE_STRING);
        $year = filter_var($_POST['select_year'], FILTER_SANITIZE_STRING);
        $vehicle = filter_var($_POST['vehicle'], FILTER_SANITIZE_STRING);
        $vehicle_model = filter_var($_POST['vehicle_model'], FILTER_SANITIZE_STRING);
        $operable = filter_var($_POST['operable'], FILTER_SANITIZE_STRING);
        $email = filter_var($_POST['email_address'], FILTER_SANITIZE_EMAIL);
        $shipping_date = filter_var($_POST['selected_shipping_date'], FILTER_SANITIZE_STRING);
        $telephone = filter_var($_POST['telephone'], FILTER_SANITIZE_STRING);


        if (!empty($city_from) && !empty($city_to) && !empty($transport_type) && !empty($year) && !empty($vehicle) &&
        !empty($vehicle_model) && !empty($operable) && !empty($email) && !empty($shipping_date)) {
            $form_data = [
            'data' => [
            'attributes' => [
            'route' => [
            'address_from' => $city_from,
            'address_to' => $city_to,
            'trailer' => strtoupper($transport_type)
            ],
            'vehicles' => [
            [
            'year' => $year,
            'make' => $vehicle,
            'model' => $vehicle_model,
            'condition' => strtoupper($operable)
            ]
            ],
            'shipping_date' => $shipping_date,
            'customer' => [
            'email' => $email,
            'phone' => $telephone
            ],
            'source' => 'web',
            'campaign' => [],
            'captcha' => ""
            ]
            ]
            ];

            $quote = new Controllers\Curl();

            $quote->url('https://www.montway.com/checkout/api/calculations')->method('post')->data($form_data)->send();

            if ($quote->info['http_code'] === 200) {
                $quote_data = $quote->content;
            }
            // echo "<pre>";
            // print_r($quote);
            // echo "</pre>";
            $quote->close();
            $response = json_decode($quote_data, true);
            $links = $response['links'];
            if ($links['quote']['href']) {
                ?>
        <script>
            window.location.replace("<?php echo $links['quote']['href']; ?>");
        </script>
                <?php
            }
            // echo '<a href="'.$links['quote']['href'].'">test</a>';
            // echo "<pre>";
            // print_r($quote);
            // echo "</pre>";
        }
        die();
    }
});

add_actions(['wp_ajax_mc_calculator', 'wp_ajax_nopriv_mc_calculator'], function () {
    if (check_ajax_referer('mc_calculator_nonce')) {
        $city_from = filter_var($_POST['city_from'], FILTER_SANITIZE_STRING);
        $city_to = filter_var($_POST['city_to'], FILTER_SANITIZE_STRING);
        $mc_valuation = filter_var($_POST['mc_valuation'], FILTER_SANITIZE_STRING);
        $year = filter_var($_POST['select_year'], FILTER_SANITIZE_STRING);
        $vehicle = filter_var($_POST['vehicle'], FILTER_SANITIZE_STRING);
        $vehicle_model = filter_var($_POST['vehicle_model'], FILTER_SANITIZE_STRING);
        $operable = filter_var($_POST['operable'], FILTER_SANITIZE_STRING);
        $email = filter_var($_POST['email_address'], FILTER_SANITIZE_EMAIL);
        $shipping_date = filter_var($_POST['selected_shipping_date'], FILTER_SANITIZE_STRING);
        $telephone = filter_var($_POST['telephone'], FILTER_SANITIZE_STRING);
        if (!empty($city_from) && !empty($city_to) && !empty($mc_valuation) && !empty($year) && !empty($vehicle) &&
        !empty($vehicle_model) && !empty($operable) && !empty($email) && !empty($shipping_date)) {
            $form_data = [
            'data' => [
            'attributes' => [
            'route' => [
            'address_from' => $city_from,
            'address_to' => $city_to,
            'trailer' => 'OPEN'
            ],
            'vehicles' => [
            [
            'year' => $year,
            'make' => $vehicle,
            'model' => $vehicle_model,
            'condition' => strtoupper($operable),
            'additional_insurance_value' => $mc_valuation
            ]
            ],
            'shipping_date' => $shipping_date,
            'customer' => [
            'email' => $email,
            'phone' => $telephone
            ],
            'source' => 'web',
            'campaign' => [],
            'captcha' => "",
            'calculator_type' => 'motorcycle',
            'type_of_haul' => 'dc-dc'
            ]
            ]
            ];
            $quote = new Controllers\Curl();

            $quote->url('https://www.montway.com/checkout/api/calculations')->method('post')->data($form_data)->send();

            if ($quote->info['http_code'] === 200) {
                $quote_data = $quote->content;
            }
            $quote->close();
            $response = json_decode($quote_data, true);
            $links = $response['links'];
            if ($links['quote']['href']) {
                $urls = [
                    $links['quote']['href']
                ];
               // $urls[0] = preg_replace('/^(http[s]?:\/\/).*?\/checkout\/(.*)$/', '$1www-rc.montway.com/checkout/$2', $urls[0]);
                ?>
            <script>
                window.location.replace("<?php echo $urls[0]; ?>");
            </script>
                <?php
            }
           /* echo '<a href="'.$links['quote']['href'].'">test</a>';
            echo "<pre>";
            print_r($quote_data);
            echo "</pre>";*/
        }
        die();
    }
});

function add_filters($filters, $callback, $priority = 10, $arguments = 1)
{
    collect($filters)->each(function ($filter, $index) use ($callback, $priority, $arguments) {
        add_filter(
            $filter,
            $callback,
            (int)is_array($priority) ? $priority[$index] : $priority,
            (int)is_array($arguments) ? $arguments[$index] : $arguments
        );
    });

    return true;
}
function add_actions($actions, $callback, $priority = 10, $arguments = 1)
{
    return add_filters($actions, $callback, $priority, $arguments);
}

add_actions(['wp_ajax_help_center_search', 'wp_ajax_nopriv_help_center_search'], function () {
    global $wpdb;
    $search = esc_attr($_POST['search_posts']);

    if (!empty($search)) {
        $results = $wpdb->get_results("SELECT wp_posts.ID
            FROM wp_posts
            WHERE ((wp_posts.post_title LIKE '%$search%')
                    OR (wp_posts.post_content LIKE '%$search%'))
              AND wp_posts.post_type = 'help-center'
              AND wp_posts.post_status = 'publish'
            ORDER BY wp_posts.post_title DESC LIMIT 0,10");

        foreach ($results as $result) {
            echo "<li>";
            echo '<a href="'.get_the_permalink($result->ID).'">'. get_the_title($result->ID). '</a>';
            echo "</li>";
        }
    }
    die();
});
// disable page autosave (revisions)
add_action('admin_init', function () {
    wp_deregister_script('autosave');
});


add_shortcode('calculator', function ($atts) {
    ?>
<div class="calculator-container mt-2 mt-lg-0">
   <form id="calculator_form" method="POST" autocomplete="off" action="<?php echo site_url() ?>/wp-admin/admin-ajax.php">
        <?php wp_nonce_field('calculator_nonce'); ?>
      <fieldset class="step-1">
      <div class="h5  mb-2 form-title ">Get <span class="bold"> an instant quote</span> <br/> or <span class="bold">call</span> now <?php echo do_shortcode('[phones]'); ?></div>
         <div class="input-wrap input-wrap-list">
             <span class="city_error_from error-text"></span>
            <input class="input" id="city_from" type="search" name="city_from" value="" autocomplete="off" placeholder="ZIP or City" autocomplete="off">
            <label for="city_from" class="input-label">Transport car FROM</label>
            <ul id="city_select" class="list-select" ></ul>
         </div>
         <div class="input-wrap input-wrap-list border-t-none">
             <span class="city_error_to error-text"></span>
            <input class="input" id="city_to" type="search" name="city_to" value="" autocomplete="off" placeholder="ZIP or City" autocomplete="off">
            <label for="city_to" class="input-label">Transport car TO</label>
            <ul id="city_select_to" class="list-select" ></ul>
         </div>

         <div class="d-flex p-3">
            <div class="mr-4 p">Transport type</div>
            <div class="d-flex">
                <div  class="custom-radio">
                    <input name="transport_type" type="radio" checked value="open" id="open-transport">
                    <label for="open-transport" class="mr-2 p text-gray">Open</label>
                </div>
               <div class="custom-radio">
                   <input name="transport_type" type="radio" value="enclosed" id="enclosed-transport">
                   <label for="enclosed-transport" class="p text-gray">Enclosed</label>
                </div>
            </div>
         </div>
         <button class="button-primary with-icon w-100 button-step-1 ">Vehicle details <i
               class="icon-arrow_forward ml-2"></i>
         </button>
      </fieldset>
      <fieldset class="step-2 d-none">
         <div class="input-wrap input-wrap-list">
             <span class="year_error error-text"></span>
            <input class="input" id="selected_year" name="select_year" type="text" value="" placeholder="Select" >
            <label for="selected_year" class="input-label">Vehicle year</label>
            <ul id="year" class="list-select d-none" >
                <?php
                for ($i=2022; $i>=1899; $i--) {
                    ?>
               <li  data-value="<?php echo $i; ?>"><?php echo $i;  ?></li>
                    <?php
                }
                ?>
            </ul>
            <div class="value-wrap value-placeholder d-flex align-items-center">
                <span class="input-value input-value-year d-inline-flex" data-placeholder="Select">Select</span>
                <span class="select-arrow d-inline-flex ml-1"></span>
            </div>
         </div>
         <div class="input-wrap input-wrap-vehicle input-wrap-list border-t-none">
            <ul id="select_vehicle" class="list-select" ></ul>
            <span class="vehicle_error error-text"></span>
            <input class="input" type="text" name="vehicle" id="selected_vehicle" disabled placeholder="Select">

            <div class="value-wrap value-placeholder d-flex align-items-center">
                <span class="input-value input-value-vehicle d-inline-flex"  data-placeholder="Select">Select</span>
                <span class="select-arrow d-inline-flex ml-1"></span>
            </div>

            <label for="selected_vehicle" class="input-label">Vehicle make</label>
         </div>
         <div class="input-wrap input-wrap-model input-wrap-list border-t-none">
            <ul id="select_model" class="list-select" ></ul>
            <span class="model_error error-text"></span>
            <input class="input" type="text" name="vehicle_model" id="selected_vehicle_model" disabled placeholder="Select">

            <div class="value-wrap value-placeholder d-flex align-items-center">
                <span class="input-value input-value-model d-inline-flex"  data-placeholder="Select">Select</span>
                <span class="select-arrow d-inline-flex ml-1"></span>
            </div>
            <label for="selected_vehicle_model" class="input-label">Vehicle model</label>

         </div>
         <div class="d-flex p-3">
            <div class="mr-4 p">Is it operable?</div>
            <div class="d-flex">
                <div class="custom-radio mr-3">
                    <input name="operable" checked type="radio" value="running" id="radio-running">
                    <label for="radio-running" class="text-gray">Yes</label>
               </div>
               <div class="custom-radio">
                   <input name="operable" type="radio" value="nonrunning" id="non-running">
                   <label for="non-running" class="text-gray">No</label>
                </div>
            </div>
         </div>
         <button class="button-primary with-icon w-100 button-step-2 btn-disabled">Confirmation details<i
               class="icon-arrow_forward ml-2"></i></button>
      </fieldset>
      <fieldset class="step-3 d-none">
         <div class="input-wrap input-grey">
             <span class="mail_error error-text"></span>
            <input id="email_address" name="email_address" type="email" required placeholder="Your email" value="">
            <label for="email_address" class="input-label ">Send a copy of the quote to</label>
         </div>
         <div class="input-wrap d-sm-block input-wrap-list date-input-wrap">
             <span class="date_error error-text"></span>
            <input type="text" name="selected_shipping_date" id="selected_shipping_date" placeholder="Select">

            <div class="value-wrap value-placeholder d-flex align-items-center">
                <span class="input-value input-value-date d-inline-flex" data-placeholder="Select">Select</span>
                <span class="select-arrow d-inline-flex ml-1"></span>
            </div>
             <input id="date_value" type="hidden" name="date_value">

            <label for="selected_shipping_date" class="input-label label-date">First available date</label>
            <ul id="shipping_date" class="list-select d-none" >
               <li  data-value="asap" class="selected">As soon as possible</li>
               <li  data-value="2weeks">Within 2 weeks</li>
               <li  data-value="30days">Within 30 days</li>
               <li  data-value="over30days">More than 30 days</li>
            </ul>

         </div>
         <div class="input-wrap input-grey datepicker-wrap d-none">
            <span class="datepicker_error error-text"></span>
             <input type="text" id="datepicker" class="" placeholder="MM/DD/YYYY">
             <label id="datepicker-label" for="datepicker" class="input-label ">Select date</label>
             <span class="icon-date_picker"></span>
         </div>

         <div class="input-wrap input-grey">
            <input id="telephone" name="telephone" type="tel" autocomplete="off" placeholder="Your phone" value="">
            <label for="telephone" class="input-label">Phone <span class="text-gray-medium">(optional)</span></label>
         </div>

         <input type="hidden" name="action" value="calculator" id="hidden-form">
         <div class="modal privacy-modal"  role="dialog" id="modal-privacy">
                    <div class="modal-wrap">

                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                <span class="h3">Montway Privacy policy</span>
                                 <button class="close-modal" data-dismiss="modal" aria-label="Close">&#10005;</button>
                                </div>
                                <div class="modal-body " tabindex="-1">
                                    <?php
                                    $page = get_page_by_path('/privacy-policy/', OBJECT, 'page');
                                    $page_id = $page->ID;
                                    $post = get_post($page_id);
                                    $output =  apply_filters('the_content', $post->post_content);
                                    print_r($output);
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
            <div class="privacy-note py-3">
            By providing your phone number and clicking submit, you agree to our Terms, <span data-toggle="modal" data-target="#modal-privacy"  class="is-underline text-blue pointer">Privacy Policy</span>, and authorize us
            to make or initiate sales calls, text messages, and prerecorded voicemails to that phone number using an
            automated system. Your agreement is not a condition of purchasing any products, goods or services. Msg &
            data rates may apply.
         </div>
         <button class="button-primary with-icon w-100 button-step-3">Calculate cost</button>
      </fieldset>
   </form>
   <div class="calculator-pagination mt-2 d-none">
      <div class="pag-step pag-step-1 active">
         <button class="step"> <span class="number">1</span></button>
         <button class="label">Destination</button>
      </div>
      <span class="step-dots "></span>
      <div class="pag-step pag-step-2 ">
         <button class="step"> <span class="number">2</span></button>
         <button class="label">Vehicle</button>
      </div>
      <span class="step-dots"></span>
      <div class="pag-step">
         <button class="step"> <span class="number">3</span></button>
         <button class="label">Date</button>
      </div>
   </div>
</div>
<div id="response"></div>
    <?php
});

add_shortcode('mc_calculator', function ($atts) {
    ?>
<div  class="calculator-container mt-2 mt-lg-0">
    <form id="mc_calculator_form" method="POST" autocomplete="off" action="<?php echo site_url() ?>/wp-admin/admin-ajax.php">
        <?php wp_nonce_field('mc_calculator_nonce'); ?>
        <fieldset class="step-1">
            <div class="h5  mb-2 form-title">Get <span class="bold"> an instant quote</span><br/> or <span class="bold">call</span> now <?php echo do_shortcode('[phones]'); ?></div>
            <div class="input-wrap input-wrap-list  mb-1">
                <span class="city_error_from error-text"></span>
                <input class="input" id="city_from" type="search" name="city_from" value="" placeholder="ZIP or City" autocomplete="off">
                <label for="city_from" class="input-label">Transport motorcycle FROM</label>
                <ul id="city_select" class="list-select" ></ul>
            </div>
            <div class="input-wrap input-wrap-list  mb-1">
                <span class="city_error_to error-text"></span>
                <input class="input" id="city_to" type="search" name="city_to" value="" placeholder="ZIP or City" autocomplete="off">
                <label for="city_to" class="input-label">Transport motorcycle TO</label>
                <ul id="city_select_to" class="list-select"></ul>
            </div>
            <div class="input-wrap mb-1">
                <div class="info-element ">
                    <button class="info-btn">?</button>
                    <div class="info-tooltip d-none"> <span> Please select the value of your motorcycle</span><button
                            class="info-close"><svg width="20" height="20" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M13.414 12L16.243 9.172C16.4306 8.98436 16.5361 8.72986 16.5361 8.4645C16.5361 8.19914 16.4306 7.94464 16.243 7.757C16.0554 7.56936 15.8009 7.46394 15.5355 7.46394C15.2701 7.46394 15.0156 7.56936 14.828 7.757L12 10.586L9.172 7.757C8.98436 7.56936 8.72986 7.46394 8.4645 7.46394C8.19914 7.46394 7.94464 7.56936 7.757 7.757C7.56936 7.94464 7.46394 8.19914 7.46394 8.4645C7.46394 8.72986 7.56936 8.98436 7.757 9.172L10.586 12L7.757 14.828C7.56936 15.0156 7.46394 15.2701 7.46394 15.5355C7.46394 15.8009 7.56936 16.0554 7.757 16.243C7.94464 16.4306 8.19914 16.5361 8.4645 16.5361C8.72986 16.5361 8.98436 16.4306 9.172 16.243L12 13.414L14.828 16.243C15.0156 16.4306 15.2701 16.5361 15.5355 16.5361C15.8009 16.5361 16.0554 16.4306 16.243 16.243C16.4306 16.0554 16.5361 15.8009 16.5361 15.5355C16.5361 15.2701 16.4306 15.0156 16.243 14.828L13.414 12ZM12 22C6.477 22 2 17.523 2 12C2 6.477 6.477 2 12 2C17.523 2 22 6.477 22 12C22 17.523 17.523 22 12 22Z"
                                    fill="#808080" />
                            </svg>
                        </button>
                    </div>
                </div>
                <span class="valuation_error error-text"></span>
                <input id="mc_valuation" type="text" name="mc_valuation" value="" placeholder="Select">
                <label for="mc_valuation" class="input-label">Motorcycle valuation</label>
                <ul id="mc_select_valuation" class="list-select d-none" >
                    <li  data-value="7000">$7000 - free and included</li>
                    <li  data-value="8000">$8000 - +$35</li>
                    <li  data-value="9000">$9000 - +$40</li>
                    <li  data-value="10000">$10000 - +$45</li>
                    <li  data-value="11000">$11000 - +$50</li>
                    <li  data-value="12000">$12000 - +$55</li>
                </ul>
            </div>
            <button class="button-primary with-icon w-100 button-step-1 ">Vehicle details <i
               class="icon-arrow_forward ml-2"></i>
            </button>
        </fieldset>
        <fieldset class="step-2 d-none">
            <div class="input-wrap input-wrap-list">
                <span class="year_error error-text"></span>
                <input class="input" id="selected_year" name="select_year" type="text" value="" placeholder="Select" >

                <label for="selected_year" class="input-label">Motorcycle year</label>

                <ul id="year" class="list-select d-none">
                <?php
                for ($i=2022; $i>=1899; $i--) {
                    ?>
               <li  data-value="<?php echo $i; ?>"><?php echo $i;  ?></li>
                    <?php
                }
                ?>
                </ul>
                <div class="value-wrap value-placeholder d-flex align-items-center">
                    <span class="input-value input-value-year d-inline-flex" data-placeholder="Select">Select</span>
                    <span class="select-arrow d-inline-flex ml-1"></span>
                </div>
            </div>
            <div class="input-wrap input-wrap-vehicle input-wrap-list border-t-none">
                <ul id="select_vehicle" class="list-select"></ul>
                <span class="vehicle_error error-text"></span>
                <input class="input" type="text" name="vehicle" id="selected_vehicle" disabled placeholder="Select">

                <div class="value-wrap value-placeholder d-flex align-items-center">
                    <span class="input-value input-value-vehicle d-inline-flex" data-placeholder="Select">Select</span>
                    <span class="select-arrow d-inline-flex ml-1"></span>
                </div>

                <label for="selected_vehicle" class="input-label">Motorcycle make</label>
            </div>
            <div class="input-wrap input-wrap-model input-wrap-list border-t-none">
                <ul id="select_model" class="list-select"></ul>
                <span class="model_error error-text"></span>
                <input class="input" type="text" name="vehicle_model" id="selected_vehicle_model" disabled placeholder="Select">

                <div class="value-wrap value-placeholder d-flex align-items-center">
                    <span class="input-value input-value-model d-inline-flex" data-placeholder="Select">Select</span>
                    <span class="select-arrow d-inline-flex ml-1"></span>
                </div>
                <label for="selected_vehicle_model" class="input-label">Motorcycle model</label>

            </div>
            <div class="d-flex p-3 position-relative">
            <div class="info-element ">
                    <button class="info-btn operable-btn">?</button>
                    <div class="info-tooltip operable-tooltip d-none"> <span>Does the motorcycle roll, brake and steer? If it does not, then please select "No" for this question.</span><button
                            class="info-close operable-close"><svg width="20" height="20" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M13.414 12L16.243 9.172C16.4306 8.98436 16.5361 8.72986 16.5361 8.4645C16.5361 8.19914 16.4306 7.94464 16.243 7.757C16.0554 7.56936 15.8009 7.46394 15.5355 7.46394C15.2701 7.46394 15.0156 7.56936 14.828 7.757L12 10.586L9.172 7.757C8.98436 7.56936 8.72986 7.46394 8.4645 7.46394C8.19914 7.46394 7.94464 7.56936 7.757 7.757C7.56936 7.94464 7.46394 8.19914 7.46394 8.4645C7.46394 8.72986 7.56936 8.98436 7.757 9.172L10.586 12L7.757 14.828C7.56936 15.0156 7.46394 15.2701 7.46394 15.5355C7.46394 15.8009 7.56936 16.0554 7.757 16.243C7.94464 16.4306 8.19914 16.5361 8.4645 16.5361C8.72986 16.5361 8.98436 16.4306 9.172 16.243L12 13.414L14.828 16.243C15.0156 16.4306 15.2701 16.5361 15.5355 16.5361C15.8009 16.5361 16.0554 16.4306 16.243 16.243C16.4306 16.0554 16.5361 15.8009 16.5361 15.5355C16.5361 15.2701 16.4306 15.0156 16.243 14.828L13.414 12ZM12 22C6.477 22 2 17.523 2 12C2 6.477 6.477 2 12 2C17.523 2 22 6.477 22 12C22 17.523 17.523 22 12 22Z"
                                    fill="#808080" />
                            </svg>
                        </button>
                    </div>
                </div>
                <div class="mr-4 p">Is it operable?</div>
                <div class="modal calculator-modal" tabindex="-1" role="dialog" id="modal-operable">
                    <div class="modal-wrap"> <button class="close-modal" data-dismiss="modal" aria-label="Close">x</button>
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-body text-center">
                                    <span class="h4">Your motorcycle must roll, brake and steer. Otherwise, a custom quote will be needed. Please call us at <?php echo do_shortcode('[phones]'); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="d-flex operable-check">
                    <div class="custom-radio mr-3">
                        <input name="operable" checked type="radio" value="running" id="radio-running">
                        <label for="radio-running" class="text-gray">Yes</label>
                    </div>
                    <div class="custom-radio">
                        <input name="operable" type="radio" value="nonrunning" id="non-running" data-toggle="modal" data-target="#modal-operable" >
                        <label for="non-running" class="text-gray">No</label>
                    </div>
                </div>

            </div>
            <button class="button-primary with-icon w-100 button-step-2 btn-disabled">Confirmation details<i
                class="icon-arrow_forward ml-2"></i></button>
        </fieldset>
        <fieldset class="step-3 d-none">
        <div class="input-wrap input-grey">
             <span class="mail_error error-text"></span>
            <input id="email_address" name="email_address" type="email" required placeholder="Your email" value="">
            <label for="email_address" class="input-label ">Send a copy of the quote to</label>
         </div>
         <div class="input-wrap d-sm-block input-wrap-list date-input-wrap">
             <span class="date_error error-text"></span>
            <input type="text" name="selected_shipping_date" id="selected_shipping_date"  placeholder="Select">

            <div class="value-wrap value-placeholder d-flex align-items-center">
                <span class="input-value input-value-date d-inline-flex" data-placeholder="Select">Select</span>
                <span class="select-arrow d-inline-flex ml-1"></span>
            </div>
             <input id="date_value" type="hidden" name="date_value">

            <label for="selected_shipping_date" class="input-label label-date">First available date</label>
            <ul id="shipping_date" class="list-select d-none" >
               <li  data-value="asap">As soon as possible</li>
               <li  data-value="2weeks">Within 2 weeks</li>
               <li  data-value="30days">Within 30 days</li>
               <li  data-value="over30days">More than 30 days</li>
            </ul>

         </div>

         <div class="input-wrap input-grey datepicker-wrap d-none">
            <span class="datepicker_error error-text"></span>
             <input type="text" id="datepicker" class="" placeholder="MM/DD/YYYY">
             <label id="datepicker-label" for="datepicker" class="input-label ">Select date</label>
             <span class="icon-date_picker"></span>
         </div>

         <div class="input-wrap input-grey">
            <input id="telephone" name="telephone" type="tel" autocomplete="off" placeholder="Your phone" value="">
            <label for="telephone" class="input-label">Phone <span class="text-gray-medium">(optional)</span></label>
         </div>

            <input type="hidden" name="action" value="mc_calculator"  id="hidden-form">
            <div class="modal privacy-modal"  role="dialog" id="modal-privacy">
                    <div class="modal-wrap">

                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                <span class="h3">Montway Privacy policy</span>
                                 <button class="close-modal" data-dismiss="modal" aria-label="Close">&#10005;</button>
                                </div>
                                <div class="modal-body" tabindex="-1">
                                    <?php
                                    $page = get_page_by_path('/privacy-policy/', OBJECT, 'page');
                                    $page_id = $page->ID;
                                    $post = get_post($page_id);
                                    $output =  apply_filters('the_content', $post->post_content);
                                    print_r($output);
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
            <div class="privacy-note py-3">
            By providing your phone number and clicking submit, you agree to our Terms, <span data-toggle="modal" data-target="#modal-privacy"  class="is-underline text-blue pointer">Privacy Policy</span>, and authorize us
            to make or initiate sales calls, text messages, and prerecorded voicemails to that phone number using an
            automated system. Your agreement is not a condition of purchasing any products, goods or services. Msg &
            data rates may apply.
         </div>
        <button class="button-primary with-icon w-100 button-step-3">Calculate cost</button>
     </fieldset>
    </form>
    <div class="calculator-pagination mt-2 d-none">
      <div class="pag-step pag-step-1 active">
         <button class="step"> <span class="number">1</span></button>
         <button class="label">Destination</button>
      </div>
      <span class="step-dots "></span>
      <div class="pag-step pag-step-2">
         <button class="step"> <span class="number">2</span></button>
         <button class="label">Vehicle</button>
      </div>
      <span class="step-dots"></span>
      <div class="pag-step">
         <button class="step"> <span class="number">3</span></button>
         <button class="label">Date</button>
      </div>
   </div>

</div>
<div id="response"></div>
    <?php
});
// disable publishing for author role
add_action('init', function () {
    $user = get_role('author');
    $user->add_cap('publish_posts', false);
    $user->add_cap('edit_others_posts', true);
    $user->add_cap('edit_published_posts', true);
    $user->add_cap('publish_pages', false);
    $user->add_cap('edit_pages', true);
    $user->add_cap('edit_others_pages', true);
    $user->add_cap('edit_published_pages', true);
});

// disable publishing for contributor role
add_action('init', function () {
    $contributor = get_role('contributor');
    $contributor->add_cap('publish_posts', false);
    $contributor->add_cap('publish_pages', false);
    $contributor->add_cap('edit_pages', true);
});
add_shortcode('year', function () {
    return date('Y');
});

/*add_action('init', function(){
    $urls = [
        'https://montway.com/checkout/motorcycle/a/b.gif',
        'https://montway.com/checkout/motorcycle/c/k.gif',
        'https://montway.com/checkout/motorcycle/l/k.docx'
    ];

    foreach($urls as $key => $url) {
        $urls[$key] = preg_replace('/^(http[s]?:\/\/).*?\/checkout\/(.*)$/', '$1www-rc.montway.com/checkout/$2', $url);
    }
    echo '<pre>';
    print_r($urls);
    echo '</pre>';
});*/
