<?php

class Child_Wrap extends Walker_Nav_Menu
{
    private $curItem;
    public $isMegaMenu;


    public function __construct()
    {
        $this->isMegaMenu = 0;
    }

    function start_lvl(&$output, $depth = 0, $args = array())
    {
        $indent = str_repeat("\t", $depth);
        $class = ($this->isMegaMenu != 0 ) ? '' : "nav-dropdown";

        if ($depth === 0 && $this->isMegaMenu == 0) {
            $output .="\n$indent <div class=\"nav-wrap position-absolute\"><ul class=\"sub-menu second-level\">\n";
        } else if ($this->isMegaMenu != 0  && $depth == 0) {
            $output .="\n$indent <div class=\"nav-wrap position-absolute\"><ul class=\"sub-menu sub-menu-mega second-level\">\n";
        } else if ($depth == 1) {
            $output .= "\n$indent<ul class=\"sub-menu\">";
        }
    }

    function end_lvl(&$output, $depth = 0, $args = array())
    {
        $indent = str_repeat("\t", $depth);

        if ($depth === 0 && $this->isMegaMenu == 0) {
            $output .= "$indent</ul></div>\n";
        } else if ($this->isMegaMenu != 0  && $depth == 0) {
            $output .= "$indent</ul></div>\n";
        } else if ($depth == 1) {
            $output .= "$indent</ul>";
        }
    }


    function start_el(&$output, $item, $depth = 0, $args = null, $id = 0)
    {
            $this->curItem = $item;
        //  parent::start_el($output, $item, $depth, $args, $id); // TODO: Change the autogenerated stub
        if ($this->isMegaMenu != intval($item->menu_item_parent) && $depth == 0) {
            $this->isMegaMenu = 0;
        }

        $indent = ( 1 ) ? str_repeat("\t", 1) : '';

        $classes = empty($item->classes) ? array() : (array) $item->classes;
        $classes[] = 'menu-item-' . $item->ID;

        if (array_search("mega", $classes) !== false && $depth == 0) {
            $this->isMegaMenu = $item->ID;
        }



        $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args, $depth));
        $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';

        $id = apply_filters('nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args, $depth);
        $id = $id ? ' id="' . esc_attr($id) . '"' : '';
        $output .= $indent . '<li' . $id . $class_names .'>';

        $atts = array();
        $atts['title']  = ! empty($item->attr_title) ? $item->attr_title : '';
        $atts['target'] = ! empty($item->target)     ? $item->target     : '';
        $atts['rel']    = ! empty($item->xfn)        ? $item->xfn        : '';
        $atts['href']   = ! empty($item->url)        ? $item->url        : '';


        $atts = apply_filters('nav_menu_link_attributes', $atts, $item, $args, $depth);

        $attributes = '';
        foreach ($atts as $attr => $value) {
            if (! empty($value)) {
                $value = ( 'href' === $attr ) ? esc_url($value) : esc_attr($value);
                $attributes .= ' ' . $attr . '="' . $value . '"';
            }
        }

        if ($args->walker->has_children && $depth === 0) {
            $svg = '<i class="icon-keyboard_arrow_down position-relative d-inline-block"></i>';
        } else {
            $svg = '';
        }
        $item_output = $args->before;

        if ($depth > 0 && $args->walker->has_children == false) {
            $item_output .= '<a'. $attributes .'>';
            /** This filter is documented in wp-includes/post-template.php */
            $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
            $link_subtitle = get_field("link_subtitle", $item);
            if (!empty($link_subtitle)) {
                $item_output .=' <p class="sub-title">'.$link_subtitle.'</p>';
            }

            $item_output .= '</a>';
        } else {
            $item_output .= '<a'. $attributes .'>';
            /** This filter is documented in wp-includes/post-template.php */
            $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $svg . $args->link_after;
            $item_output .= '</a>';
        }






        $item_output .= $args->after;

        $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
    }
    function end_el(&$output, $item, $depth = 0, $args = null)
    {

        parent::end_el($output, $item, $depth, $args); // TODO: Change the autogenerated stub
        $this->curItem = $item;
    }
}
