@extends('layouts.app')

@section('content')
@include('partials.page-header')
@if(!have_posts())
  <section class="404-section">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-6">
          <span class="text-xl">{!! '404' !!}</span>
        </div>
        <div class="col-md-6">
          <h1>{!! get_field('title_404', 'option') !!}</h1>
          <h2 class="h4 text-gray mb-2">{!! get_field('subtitle_404', 'option') !!}</h2>
          <div class="h4 mb-3">{!! get_field('body_copy_404', 'option') !!}</div>
          @php
            $button = get_field('button_404', 'option');
          @endphp
          @if($button['button_link'])
            <a href="{!! $button['button_link'] !!}" class="button-primary">{!! $button['button_text'] !!}</a>
          @endif
        </div>
      </div>
    </div>
  </section>
@else
  <section class="404-section">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-md-6">
          <span class="text-xl">{!! '404' !!}</span>
        </div>
        <div class="col-md-6">
          <h1>{!! get_field('title_404', 'option') !!}</h1>
          <h2 class="h4 text-gray mb-2">{!! get_field('subtitle_404', 'option') !!}</h2>
          <div class="h4 mb-3">{!! get_field('body_copy_404', 'option') !!}</div>
          @php
            $button = get_field('button_404', 'option');
          @endphp
          @if($button['button_link'])
            <a href="{!! $button['button_link'] !!}" class="button-primary">{!! $button['button_text'] !!}</a>
          @endif
        </div>
      </div>
    </div>
  </section>
@endif
@endsection
