{{--
  Title: Box on the left and accordion on the right
  Description: Box on the left and accordion on the right
  Category: montway_blocks
  Icon: admin-comments
  Keywords: box accordion
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/box-left-acc-right.png
--}}
@php
$title = get_field("title");
$subtitle = get_field("subtitle");
$box = get_field("box");
$buttons = get_field("buttons");
$padding = get_field("block_padding");
$body_copy_background_color = get_field("body_copy_background"); /* ovo koristi kao inline za pozadinsku boju ( ona plava sekcija ) */
$font_color = get_field("font_color"); /* ovo koristi za boju fonta unutar plave sekcije  */

   $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

  if(!empty($box['icon_first'])){
  	$main_icon = \App\Controllers\App::imageWithAlt($box['icon_first']);
  	$main_icon_type = \App\Controllers\App::checkImgExtension($box['icon_first']['filename']);
  }

  if(!empty($box['check_icon'])){
  	$check_icon = \App\Controllers\App::imageWithAlt($box['check_icon']);
  	$check_icon_type = \App\Controllers\App::checkImgExtension($box['check_icon']['filename']);
  }

@endphp
<section data-{{ $block['id'] }} class="bg-light">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h2 class="mb-48">{!! $title !!}</h2>
      </div>
      <div class="col-md-7 mb-4 mb-md-0">

      <a href="{!! $box['button_link'] !!}" class="offer-box container-blue"
        style="background: {!!$body_copy_background_color!!};">
        <span class="text-caption">{!! $subtitle !!}</span>

        <p class="h2  mb-3 mb-lg-4 " style="color: {!!$font_color!!};">{!! $box['title'] !!}</p>

@if($main_icon_type == "svg")
          <div class="icon-body">
@php
  echo file_get_contents($main_icon['image'])
@endphp

@else
<img src="{!! $main_icon['image'] !!}" alt="{!! $main_icon['alt'] !!}"
  srcset="{!! $main_icon['small'] . $main_icon['medium'] . $main_icon['large'] !!}" />
@endif

</div>
<div class="icon-check">
@if($check_icon_type == "svg")
  @php
    echo file_get_contents($check_icon['image'])
  @endphp
@else
            <img src="{!! $check_icon['image'] !!}" alt="{!! $check_icon['alt'] !!}"
              srcset="{!! $check_icon['small'] . $check_icon['medium'] . $check_icon['large'] !!}" />
            @endif
          </div>
          <div class="text-wrap ">{!! $box['body_copy'] !!}</div>

          </a>

      </div>
      <div class="col-md-5">
      @if($buttons)
      @foreach($buttons as $button)
        <a href="{!! $button['button_link'] !!}" class="link-box">
          <span class="h4">
            {!! $button['button_text'] !!}
          </span>
          <i class="icon-arrow_forward icon"></i>
        </a>
      @endforeach
        @endif
    </div>
  </div>
  </div>
</section>
