{{--
  Title: 4 or 6 Boxes with Icons and Text
  Description:4 or 6 Boxes with Icons and Text
  Category: montway_blocks
  Icon: admin-comments
  Keywords: boxes icons text
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/4or6boxes-icons.png
--}}
@php
  $title = get_field("title");
  $number_of_boxes = get_field("number_of_boxes");
  $boxes_2x2 = get_field('boxes_2x2');
  $boxes_2x3 = get_field('boxes_2x_3');
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="bg-gray-white boxes-4-6">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
      </div>
      <div class="col-12">
        @if($number_of_boxes == "four")
        <div class="grid-wrap">
          @foreach($boxes_2x2 as $box)
            <div class="box-icon-text has-border">
              <div class="d-flex align-items-center mb-3 mb-lg-0">
              @php
                if(!empty($box['icon'])){
                $img = \App\Controllers\App::imageWithAlt($box['icon']);
                $img_type = \App\Controllers\App::checkImgExtension($box['icon']['filename']);
                }
              @endphp
              @if(isset($img))
                @if($img_type == "svg")
                <span class="box-icon p-absolute">

                  @php
                    echo file_get_contents($img['image'])
                    @endphp
                </span>
                @else
                  <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
                    srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">
                @endif
              @endif
              <h3 class="h5 mb-lg-2">{!! $box['title'] !!}</h3>
            </div>
              <div class="text-body body-link">{!! $box['body_copy'] !!}</div>
            </div>
          @endforeach
        </div>
        @else
        <div class="grid-wrap">
          @foreach($boxes_2x3 as $box)
            <div class="box-icon-text has-border">
              <div class="d-flex align-items-center mb-3 mb-lg-0">
              @php
                if(!empty($box['icon'])){
                $img = \App\Controllers\App::imageWithAlt($box['icon']);
                $img_type = \App\Controllers\App::checkImgExtension($box['icon']['filename']);
                }
              @endphp
              @if(isset($img))
                @if($img_type == "svg")
                <span class="box-icon p-absolute">

                  @php
                    echo file_get_contents($img['image'])
                    @endphp
                </span>
                @else
                  <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
                    srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">
                @endif
              @endif
              <h3 class="h5 mb-lg-2">{!! $box['title'] !!}</h3>
            </div>
              <div class="text-body body-link">{!! $box['body_copy'] !!}</div>
            </div>
          @endforeach
        </div>
        @endif
      </div>
    </div>
  </div>
</section>
