{{--
Title: Call to Action (Button in the Middle)
Description: Call to action block
Category: montway_blocks
Icon: admin-comments
Keywords: cta action call
Mode: edit
Align: center
PostTypes: page post
SupportsAlign: left right center
SupportsMode: true
SupportsMultiple: true
Preview: true
PreviewImage: /resources/assets/block-images/cta-button-middle.png
--}}
@php
  $headline = get_field("title");
  $subtitle = get_field("subtitle");

  $button = get_field("button");
  $button_text = $button["button_text"];
  $button_link = $button["button_link"];

  $padding = get_field("block_padding");

  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

  $image = get_field('background_image');
  if(!empty($image)){
  $background_image = \App\Controllers\App::imageWithAlt($image);
  $background_image_type = \App\Controllers\App::checkImgExtension($image['filename']);
  }

@endphp

<div data-{{ $block['id'] }} class="bg-white cta-center">
  <div class="container">
    <div class="row">
      <div class="col-md-12 col-lg-9 mx-auto">
        <div class="cta-box " style="background-image: url({!! $background_image['image'] !!});">
          @if(!empty($headline))
            <h3 class="mb-2 h2">{!! $headline !!}</h3>
          @endif
          @if(!empty($subtitle))
            <div class="text body-link">{!! $subtitle !!}</div>
          @endif
          @if(!empty($button_link))
            <a href="{!! $button_link !!}" class="button-primary">{!! $button_text !!}</a>
          @endif
        </div>
      </div>
    </div>
  </div>
</div>
