{{--
  Title: FAQ accordion full width and image in the right corner
  Description:FAQ accordion full width and image in the right corner
  Category: montway_blocks
  Icon: admin-comments
  Keywords: faq accordion questions answers
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/faq-accordion-full-width.png
--}}
@php
  $title = get_field("title");
  $img = get_field("image");
  $questions = get_field("questions");
  if(!empty($img)){
  $image = \App\Controllers\App::imageWithAlt($img);
  $image_type = \App\Controllers\App::checkImgExtension($img['filename']);
  }

  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

@endphp
<section data-{{ $block['id'] }} class="bg-light faq-full-width">
  <div class="container">
    <div class="row">
      <div class="col-12 col-lg-8 d-flex align-items-end">
        <h2>{!! $title !!}</h2>
      </div>
      <div class="d-none d-lg-block col-lg-3 offset-lg-1">
        <div class="img-wrap">
          @if(isset($image))
            @if($image_type == "svg")
              @php
                echo file_get_contents($image['image'])
              @endphp
            @else
              <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
            @endif
          @endif
        </div>
      </div>
      <div class="col-12 mt-4">
        <div class="accordions-wrap">
          @foreach($questions as $question)
            <div class="accordion-item">
              <h3 class="h5 my-1 js-accordion-trigger d-flex align-items-start justify-content-between">
                <span>{!! $question['question'] !!}</span>
                <i class="icon icon-keyboard_arrow_right"></i></h3>
              <div class="text-body body-link">{!! $question['answer'] !!}</div>
            </div>
          @endforeach
        </div>
      </div>
    </div>
  </div>
</section>
