{{--
Title: List with bullet points
Description: List with bullet points
Category: help_center_blocks
Icon: admin-comments
Keywords: list
Mode: edit
Align: center
PostTypes: help-center
SupportsAlign: left right center
SupportsMode: true
SupportsMultiple: true
Preview: true
PreviewImage: /resources/assets/block-images/list-hc.png
--}}
@php
$title= get_field('title');
$padding = get_field('block_padding');
$inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
echo $inline_style;
@endphp
<section class="mb-3" data-{{ $block['id'] }} >
      <h3 class="text-normal mb-3 mb-lg-4">{!! $title !!}</h3>
      @if(have_rows('list'))
          @while(have_rows('list'))
            @php the_row(); @endphp
            <h4 class="p bold mb-1">{!! get_sub_field('list_title') !!}</h4>
            @if(have_rows('list_elements'))
                <ul class="bulleted-list">
                @while(have_rows('list_elements'))
                  @php the_row(); @endphp
                  <li>{!! get_sub_field('single_element') !!}</li>
                @endwhile
                </ul>
            @endif
          @endwhile
      @endif
</section>
