{{--
  Title: Image and Text Module
  Description: Image and Text Module
  Category: montway_blocks
  Icon: admin-comments
  Keywords: image text
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/image-text.png
--}}
@php
  $title = get_field("title");
  $subtitle = get_field("subtitle");
  $sections = get_field("section");
  $padding = get_field("block_padding");

  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="bg-white text-img-normal">
  <div class="container">
    <div class="row">
      <div class="col-12">
        @if(!empty($title))
          <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
        @endif
        @if(!empty($subtitle))
          <h3 class="p mb-5 body-link">{!! $subtitle !!}</h3>
        @endif
      </div>
    </div>
    @php
      $rowCount = 0;
      $size_of_sections = sizeof($sections);
    @endphp
    @foreach($sections as $section)
      @php $button = $section['button']; @endphp
      @if($rowCount++ % 2 == 1)
        <div class="row {{ ( $size_of_sections > 1 ) ? 'mb-4 mb-md-5 pb-lg-5' : '' }} align-items-center">
          @php
            if(!empty($section['image'])){
            $img = \App\Controllers\App::imageWithAlt($section['image']);
            $img_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
            }
          @endphp

          <div class="col-md-6 col-lg-5 order-2 ">
            @if(isset($img))
              @if($img_type == "svg")
                @php
                  echo file_get_contents($img['image'])
                @endphp
              @else
                <img class="image" src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
                  srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">
              @endif
            @endif
          </div>
          <div class="col-md-6 col-lg-5  offset-lg-1 order-1 mb-3 mb-md-0 order-md-2">
            <h2 class="h2 mb-3 mb-lg-4">{!! $section['title'] !!}</h2>
            <div class="text-gray body-link">{!! $section['body_copy'] !!}</div>
            @if($button['button_link'])
              <a href="{!! $button['button_link'] !!}" class="button-primary mt-2">{!! $button['button_text'] !!}</a>
            @endif
          </div>
        </div>
      @else
        <div class="row {{ ( $size_of_sections > 1 ) ? 'mb-4 mb-md-5 pb-lg-5' : '' }} align-items-center">
          @php
            if(!empty($section['image'])){
            $img = \App\Controllers\App::imageWithAlt($section['image']);
            $img_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
            }
          @endphp
          <div class="col-md-6 col-lg-5  mb-3 mb-md-0">
            <h2 class="h2 mb-3 mb-lg-4">{!! $section['title'] !!}</h2>
            <div class="text-gray body-link">{!! $section['body_copy'] !!}</div>
            @if($button['button_link'])
              <a href="{!! $button['button_link'] !!}" class="button-primary mt-2">{!! $button['button_text'] !!}</a>
            @endif
          </div>
          <div class="col-md-6 col-lg-5 offset-lg-2 ">
            @if(isset($img))
              @if($img_type == "svg")
                @php
                  echo file_get_contents($img['image'])
                @endphp
              @else
                <img class="image" src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
                  srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">
              @endif
            @endif

          </div>

        </div>
      @endif
    @endforeach
  </div>
</section>
