{{--
  Title: Circle Image and Text Module
  Description: Circle Image and Text Module
  Category: montway_blocks
  Icon: admin-comments
  Keywords: image text
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/image-circle-text.png
--}}
@php
$title = get_field("title");
$subtitle = get_field("subtitle");
$sections = get_field("section");
$padding = get_field("block_padding");

   $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="bg-white text-img-circle logistics-img-text">
  <div class="container">
    <div class="row">
      <div class="col-12">
        @if(!empty($title))
        <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
        @endif
        @if(!empty($subtitle))
        <div class="p mb-5 body-link">{!! $subtitle !!}</div>
        @endif
      </div>
    </div>
    @php
    $rowCount = 0;
    @endphp
    @foreach($sections as $section)
       @if ($rowCount++ % 2 == 1)
        <div class="row img-row mb-4 mb-md-5 align-items-center">
          @php
            if(!empty($section['image'])){
            $img = \App\Controllers\App::imageWithAlt($section['image']);
            $img_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
            }
            @endphp
              <div class="col-md-6 order-2">

                <h2 class="h2 mb-4 mb-lg-5">{!! $section['title'] !!}</h2>
                <div class="body-link">{!! $section['body_copy'] !!}</div>
              </div>
              <div class="col-md-6 order-1 order-md-2">
                  @if(isset($img))
                      @if($img_type == "svg")
                    @php
                      echo file_get_contents($img['image'])
                    @endphp
                      @else
                        <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}" srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">
                      @endif
                  @endif
              </div>
          </div>
      @else
          <div class="row img-row mb-4 mb-md-5 align-items-center">
              @php
                if(!empty($section['image'])){
                $img = \App\Controllers\App::imageWithAlt($section['image']);
                $img_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
                }
                @endphp
                <div class="col-md-6">
                    @if(isset($img))
                        @if($img_type == "svg")
                      @php
                        echo file_get_contents($img['image'])
                      @endphp
                        @else
                          <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}" srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">
                        @endif
                    @endif

                </div>
                <div class="col-md-6">

                  <h2 class="h2 mb-4 mb-lg-5">{!! $section['title'] !!}</h2>
                  <div class="body-link">{!! $section['body_copy'] !!}</div>
                </div>
          </div>
      @endif
    @endforeach
  </div>
</section>
