{{--
  Title: Images in the corners and text section
  Description: Images in the corners and text section
  Category: montway_blocks
  Icon: admin-comments
  Keywords: image text
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/images-text-corners.png
--}}
@php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $sections = get_field("sections");
  $title = get_field('title');
@endphp
<section data-{{ $block['id'] }} class="image-corner-section bg-gray-white">
  <div class="container">
    <div class="row">
      @foreach($sections as $section)
      @if($loop->first)
        @php
        if($section['image']){
        $image = \App\Controllers\App::imageWithAlt($section['image']);
        $image_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
        }
        @endphp
        <div class="col-lg-4  d-block d-lg-none">
          <div class="img-wrap">
            @if(isset($image))
              @if($image_type == "svg")
                @php
                  echo file_get_contents($image['image'])
                @endphp
              @else
                <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                  srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
              @endif
            @endif
          </div>
        </div>
      @endif
    @endforeach
      <div class="col-lg-12 ">
        <h2 class="mb-4 ">{!! $title !!}</h2>
      </div>
    </div>
    @foreach($sections as $section)
      @if($loop->first)
        <div class="row row-height">
          @php
            if($section['image']){
            $image = \App\Controllers\App::imageWithAlt($section['image']);
            $image_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
            }
          @endphp
          <div class="col-lg-4 d-none d-lg-block">
            <div class="img-wrap">
              @if(isset($image))
                @if($image_type == "svg")
                  @php
                    echo file_get_contents($image['image'])
                  @endphp
                @else
                  <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                    srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
                @endif
              @endif
            </div>
          </div>
          {{-- <div class="col-12 d-block d-lg-none ">
            <h2 class="mb-4 ">{!! $title !!}</h2>
          </div> --}}
          <div class="col-lg-8">
            @foreach($section['content'] as $content)
              <div class="box-icon-text js-container-toggle mb-3 mb-lg-5-c">
                <div class="d-flex align-items-center justify-content-between">
                  <h3 class="mb-lg-3 h4">{!! $content['title'] !!}</h3>
                  <i class="icon icon-keyboard_arrow_right"></i>
                </div>
                <div class="text-wrap body-link">{!! $content['body_copy'] !!}</div>
              </div>
            @endforeach
          </div>
        </div>
      @endif
      @if($loop->last)
        <div class="row row-second">
          @php
            if($section['image']){
            $image = \App\Controllers\App::imageWithAlt($section['image']);
            $image_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
            }
          @endphp
          <div class="col-lg-8">
            @foreach($section['content'] as $content)
            <div class="box-icon-text js-container-toggle mb-3 mb-lg-5-c">
              <div class="d-flex align-items-center justify-content-between">
                <h3 class="mb-lg-3 h4">{!! $content['title'] !!}</h3>
                <i class="icon icon-keyboard_arrow_right"></i>
              </div>
              <div class="text-wrap body-link">{!! $content['body_copy'] !!}</div>
            </div>
            @endforeach
          </div>
          <div class="col-lg-4">
            <div class="img-wrap img-right">
              @if(isset($image))
                @if($image_type == "svg")
                  @php
                    echo file_get_contents($image['image'])
                  @endphp
                @else
                  <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                    srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
                @endif
              @endif
            </div>
          </div>
        </div>
      @endif
    @endforeach

  </div>
</section>
