{{--
  Title: Images and text section with a list
  Description: Images and text section with a list
  Category: montway_blocks
  Icon: admin-comments
  Keywords: image text list
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/image-text-list.png
--}}
@php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $sections = get_field("sections");
@endphp
<section data-{{ $block['id'] }} class="text-img-normal img-text-list">
  <div class="container position-relative">
    @php
      $rowCount = 0;
    @endphp
    @foreach($sections as $section)
      @if($rowCount++ % 2 == 1)
        <div class="row align-items-center pb-lg-4 mb-5  position-relative">
          <div class="col-lg-6 js-parent-container-open pr-xl-5 mb-4 mb-lg-0">
            <div class="js-container-toggle">
              <h2 class="mb-3">{!! $section['title'] !!}</h2>
              <div class="text-gray body-link">{!! $section['body_copy'] !!}</div>
              <div class="text-gray item-hidden body-link">{!! $section['body_copy_hidden'] !!}</div>
              @if($section['body_copy_hidden'])
                <button data-text-open="Read less" data-text-close="Read more"
                  class="is-underline p-0 js-button-trigger js-see-more-button pt-4"><span
                    class="js-button-text">Read more</span></button>
              @endif
              @if($section['button']['button_link'])
                <a href="{!! $section['button']['button_link'] !!}" class="button-primary small">{!!
                  $section['button']['button_text']
                  !!}</a>
              @endif
            </div>
          </div>
          <div class="col-lg-5 offset-lg-1">
            <div class="img-wrap">
              @php
                if($section['image']){
                $image = \App\Controllers\App::imageWithAlt($section['image']);
                $image_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
                }
              @endphp
              @if(isset($image))
                @if($image_type == "svg")
                  @php
                    echo file_get_contents($image['image'])
                  @endphp
                @else
                  <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                    srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
                @endif
              @endif
            </div>
          </div>

          <div class="dashed-line-dot  desk-only"></div>
        </div>
      @else
        <div class="row align-items-center pb-lg-4 mb-5 position-relative">
          <div class="col-lg-5 order-2 order-lg-1">
            <div class="img-wrap">
              @php
                if($section['image']){
                $image = \App\Controllers\App::imageWithAlt($section['image']);
                $image_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
                }
              @endphp
              @if(isset($image))
                @if($image_type == "svg")
                  @php
                    echo file_get_contents($image['image'])
                  @endphp
                @else
                  <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                    srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
                @endif
              @endif
            </div>
          </div>
          <div class="col-lg-6 order-1 js-parent-container-open order-lg-2 offset-lg-1 pl-xl-5 mb-4 mb-lg-0">
            <div class="js-container-toggle">
              <h2 class="mb-3">{!! $section['title'] !!}</h2>
              <div class="text-gray body-link">{!! $section['body_copy'] !!}</div>
              <div class="text-gray item-hidden body-link">{!! $section['body_copy_hidden'] !!}</div>
              @if($section['body_copy_hidden'])
                <button data-text-open="Read less" data-text-close="Read more"
                  class="is-underline p-0 js-button-trigger js-see-more-button pt-4"><span
                    class="js-button-text">Read more</span></button>
              @endif
              @if($section['button']['button_link'])
                <a href="{!! $section['button']['button_link'] !!}" class="button-primary small">{!!
                  $section['button']['button_text']
                  !!}</a>
              @endif
            </div>
          </div>
          <div class="dashed-line-dot  desk-only"></div>
        </div>
      @endif
    @endforeach
      <div class="js-dashed-line dashed-text-list desk-only">
        <div class="animated-line js-animated-line line-2">
          <div class="pulsating-dot"></div>
        </div>
      </div>
      <div class="dashed-line dashed-text-list desk-only"></div>
  </div>
</section>
