{{--
  Title: Image and Text V3 Module
  Description: Image and Text V3 Module
  Category: montway_blocks
  Icon: admin-comments
  Keywords: image text
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/image-textv3.png
--}}
@php
  $title = get_field('title');
  $body_copy = get_field('body_copy');
  $img = get_field('image');
  if(!empty($img)){
  $image = \App\Controllers\App::imageWithAlt($img);
  $image_type = \App\Controllers\App::checkImgExtension($img['filename']);
  }
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

  @endphp
<section data-{{ $block['id'] }} class="img-text-with-padding bg-gray-white">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-5 order-2 order-lg-1">
        <div class="img-wrap ">
          @if($image_type == "svg")
            @php
              echo file_get_contents($image['image'])
            @endphp
          @else
            <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                 srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
          @endif
        </div>
      </div>
      <div class="col-lg-6  offset-lg-1 order-1 mb-4 mb-lg-0 order-lg-2">
        <div class="text-wrap">

          <h2 class="mb-3">{!! $title !!}</h2>
          <div class="text-gray blue-marker body-link">{!! $body_copy !!}</div>
        </div>
      </div>
    </div>
  </div>
</section>
