{{--
  Title: Images and text section with a vertical line
  Description: Images and text section with a vertical line
  Category: montway_blocks
  Icon: admin-comments
  Keywords: image text list
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/image-text-list.png
--}}
@php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $sections = get_field("sections");
  $title = get_field("title");
  $subtitle = get_field("undertitle");

@endphp
<section data-{{ $block['id'] }} class="text-img-normal hero-no-image">
  <div class="container ">
    <div class="row pb-lg-5">
      <div class="col-12 col-lg-7 pb-lg-3 mx-auto text-lg-center fade-in-animation mb-3">
        <h1 class="mb-3 mb-lg-4 h4">{!! $title !!}</h1>
        <h2 class="h4 bold">{!! $subtitle !!}</h2>
      </div>
    </div>
  </div>
  <div class="container position-relative">
    @php
      $rowCount = 0;
    @endphp
    @foreach($sections as $section)
      @if($rowCount++ % 2 == 1)
        <div class="row align-items-center pb-lg-4 mb-2 mb-lg-5  position-relative mt-f-56">
          <div class="col-lg-6 order-2 order-lg-1 js-parent-container-open pr-xl-5 mb-4 mb-lg-0">
            <div class="js-container-toggle">
              <span class="text-gray-medium h5 bold-desc">{!! $section['overline']!!}</span>
              <h2 class="mb-3">{!! $section['title'] !!}</h2>
              <div class="text-gray body-link">{!! $section['body_copy'] !!}</div>
            </div>
          </div>
          <div class="col-lg-6 order-1 order-lg-2">
            <div class="img-wrap mb-3 mb-lg-0">
              @php
                if($section['image']){
                $image = \App\Controllers\App::imageWithAlt($section['image']);
                $image_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
                }
              @endphp
              @if(isset($image))
                @if($image_type == "svg")
                  @php
                    echo file_get_contents($image['image'])
                  @endphp
                @else
                  <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                    srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
                @endif
              @endif
            </div>
          </div>

          <div class="dashed-line-dot  desk-only"></div>
        </div>
      @else
        <div class="row align-items-center pb-lg-4  mb-2 mb-lg-5 position-relative mt-f-56">
          <div class="col-lg-6 pr-lg-4 ">
            <div class="img-wrap mb-3 mb-lg-0">
              @php
                if($section['image']){
                $image = \App\Controllers\App::imageWithAlt($section['image']);
                $image_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
                }
              @endphp
              @if(isset($image))
                @if($image_type == "svg")
                  @php
                    echo file_get_contents($image['image'])
                  @endphp
                @else
                  <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                    srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
                @endif
              @endif
            </div>
          </div>
          <div class="col-lg-6 js-parent-container-open  pl-xl-5 mb-4 mb-lg-0">
            <div class="js-container-toggle">
              <span class="text-gray-medium h5 bold-desc">{!! $section['overline']!!}</span>
              <h2 class="mb-3">{!! $section['title'] !!}</h2>
              <div class="text-gray body-link">{!! $section['body_copy'] !!}</div>
            </div>
          </div>
          <div class="dashed-line-dot  desk-only"></div>
        </div>
      @endif
    @endforeach
    <div class="js-dashed-line dashed-text-header desk-only">
      <span class="dashed-line-dot top-pos desk-only"></span>
      <div class="animated-line js-animated-line line-2">
        <div class="pulsating-dot"></div>
      </div>
    </div>
    <div class="dashed-line dashed-text-header desk-only"></div>
  </div>
</section>
