{{--
  Title: Image and Text Module V2
  Description: Image and Text Module
  Category: montway_blocks
  Icon: admin-comments
  Keywords: text image
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/text-image.png
--}}
@php
  $title = get_field('title');
  $body_copy = get_field('body_copy');
  $img = get_field('image');
  if(!empty($img)){
  $image = \App\Controllers\App::imageWithAlt($img);
  $image_type = \App\Controllers\App::checkImgExtension($img['filename']);
  }
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }}>
  <div class="container">
    <div class="row">
      <div class="col-lg-5 d-none d-lg-block">
        <div class="img-wrap ">
          @if($image_type == "svg")
          @php
            echo file_get_contents($image['image'])
            @endphp
        @else
        <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
        srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
        @endif
        </div>
      </div>
      <div class="col-lg-7">
        <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
        <div class="body-link">{!! $body_copy !!}</div>
      </div>
    </div>
  </div>
</section>
