{{--
  Title: Interactive text and images module
  Description: Interactive text and images module
  Category: montway_blocks
  Icon: admin-comments
  Keywords: text image interactive
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/interactive-text-images.png
--}}
@php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

  $title = get_field("title");
  $years = get_field("single_year");
@endphp
<section data-{{ $block['id'] }} class="history-blok">
  <div class="container">
    <div class="row">
      <div class="col-12 mb-4">
        <h2>{!! $title !!}</h2>
      </div>
    </div>

    @foreach($years as $key => $year)
      <div class="row single-year-section position-relative">
        <div class="col-12 text-center year-wrap">
          <h3 class="p year">{!! $year['year'] !!}</h3>
        </div>
        @if($year['section'])
          <div class="col-xl-6">
            @foreach($year['section'] as $section)
            @php
            $dot_position = $section['dot_position'];
           @endphp
            @if( $section['box_position'] == 'left' )
              <div class=" history-wrap  {{ $section['box_position'] }}">
                <span class="dot" style="top:{{$dot_position}};"></span>
                <div class="history-box">
                  <span class="box-arrow-border" style="top:{{$dot_position}};"></span>
                  <span class="box-arrow" style="top:{{$dot_position}};"></span>
                  @if($section['title'])
                    <h4 class="mb-3 h3">{!! $section['title'] !!}</h4>
                  @endif
                  @if($section['body_copy'])
                    <div class="body-link">{!! $section['body_copy'] !!}</div>
                  @endif
                  @if($section['image'])
                    @php
                      if(!empty($section['image'])){
                      $img = \App\Controllers\App::imageWithAlt($section['image']);
                      $img_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
                      }
                    @endphp
                    @if(isset($img))
                      @if($img_type == "svg")
                        @php
                          echo file_get_contents($img['image'])
                        @endphp
                      @else
                        <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}">
                      @endif
                    @endif
                  @endif
                </div>
              </div>
              @endif
            @endforeach
          </div>
          <div class="col-xl-6">
            @foreach($year['section'] as $section)
              @php
              $dot_position = $section['dot_position'];
             @endphp
            @if( $section['box_position'] == 'right' )
              <div class=" history-wrap  right">
                <span class="dot" style="top:{{$dot_position}};"></span>
                <div class="history-box">
                  <span class="box-arrow-border" style="top:{{$dot_position}};"></span>
                  <span class="box-arrow" style="top:{{$dot_position}};"></span>
                  @if($section['title'])
                    <h4 class="mb-3 h3">{!! $section['title'] !!}</h4>
                  @endif
                  @if($section['body_copy'])
                    <div class="body-link">{!! $section['body_copy'] !!}</div>
                  @endif
                  @if($section['image'])
                    @php
                      if(!empty($section['image'])){
                      $img = \App\Controllers\App::imageWithAlt($section['image']);
                      $img_type = \App\Controllers\App::checkImgExtension($section['image']['filename']);
                      }
                    @endphp
                    @if(isset($img))
                      @if($img_type == "svg")
                        @php
                          echo file_get_contents($img['image'])
                        @endphp
                      @else
                        <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}">
                      @endif
                    @endif
                  @endif
                </div>
              </div>
              @endif
            @endforeach
          </div>
        @endif
      </div>
    @endforeach
  </div>
</section>
