{{--
  Title: Latest Posts
  Description: Latest Posts
  Category: montway_blocks
  Icon: admin-comments
  Keywords: blog posts posts latest
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/latest-posts.png
--}}
@php
$title = get_field('title');
$padding = get_field("block_padding");
$inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
echo $inline_style;
$posts = \App\Controllers\App::blogPosts();
@endphp
<section data-{{ $block['id'] }} class="latest-posts-wrap">
  <div class="container">
      <h2 class="mb-md-32 mb-4">{!! $title !!}</h2>
      <div class="row">
      @foreach($posts as $key => $post)
          {{-- <div>
            <a href="{!! $post['permalink'][0] !!}">
            <img src="{!! $post['image'][0] !!}" alt="{!! $post['alt'][0] !!}"/>
            <h3>{!! $post['title'][0] !!}</h3>
            </a>
            <span>{!! "Posted on:" !!} {!! $post['date'][0] !!}</span>
          </div> --}}
          <div class="col-md-6 col-lg-4 mb-3 mb-md-32 post-col latest-post-single">
            <div class="box-with-shadow p-0 overflow-hidden post-box">
              <a href="{{ $post['permalink'][0] }}">
                <div class="box-post-image">
                  @if ( empty ($post['image'][0] ) )
                    <img src="/app/uploads/2021/12/default.jpg"  alt="{!! $post['title'][0] !!}"/>                                     
                  @else
                  <img class="" src="{{ $post['image'][0] }}" alt="{{ $post['alt'][0] }}">
                  @endif
                </div>
              </a>
              <div class="post-content pt-2 px-3 pb-3">
                <h2 class="h4 post-title overflow-hidden"><a href="{{ $post['permalink'][0] }}">{!! $post['title'][0] !!}</a></h2>
                <div class="date-read d-flex justify-content-between">
                  <span class="text-gray-medium font-small">Posted on: {{ $post['date'][0] }}</span>
                </div>
              </div>
            </div>
          </div>
      @endforeach
      </div>
  </div>
</section>
