{{--
Title: Text and 2 logos in circle on the right
Description: Text and 2 logos in circle on the right
Category: montway_blocks
Icon: admin-comments
Keywords: logo logos
Mode: edit
Align: center
PostTypes: page post
SupportsAlign: left right center
SupportsMode: true
SupportsMultiple: true
Preview: true
PreviewImage: /resources/assets/block-images/logos-new.png
--}}
@php
$title = get_field('title');
$body_copy = get_field('body_copy');
$padding = get_field("block_padding");
$inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
echo $inline_style;
$logos = get_field("logos");
@endphp
<section data-{{ $block['id'] }} class="text-two-logos">
  <div class="container">
    <div class="row">
      @if ( $title )
        <h2 class="mb-4 col-12">{!! $title !!}</h2>
      @endif
    </div>
  </div>
  <div class="container">
    <div class="row aligen-items-center">
      <div class="col-md-6 d-flex align-items-center body-link">
        {!! $body_copy !!}
      </div>
      <div class="col-md-6 d-block d-md-flex">
        @foreach($logos as $logo)
        <div class="logo align-items-center d-block d-md-flex">
          @if($logo['link'])
            <a href="{!! $logo['link'] !!}">
              @endif
              @php
                if(!empty($logo['logo_image'])){
                  $img = \App\Controllers\App::imageWithAlt($logo['logo_image']);
                  $img_type = \App\Controllers\App::checkImgExtension($logo['logo_image']['filename']);
                }
              @endphp
              @if(isset($img))
                <div class="image-wrap">
                @if($img_type == "svg")
                  @php
                    echo file_get_contents($img['image'])
                  @endphp
                @else
                  <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}">
                @endif
                </div>
              @endif

              @if($logo['link'])
            </a>
          @endif
        </div>
      @endforeach
      </div>
    </div>
  </div>
</section>
