{{--
Title: Logos
Description: Logos
Category: montway_blocks
Icon: admin-comments
Keywords: logo logos
Mode: edit
Align: center
PostTypes: page post
SupportsAlign: left right center
SupportsMode: true
SupportsMultiple: true
Preview: true
PreviewImage: /resources/assets/block-images/logos.png
--}}
@php
  $layout = get_field("layout");
  $title = get_field("title");
  $logos = get_field("logos");
 $padding = get_field("block_padding");

   $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="logos-section bg-white">
  @if($layout == "with_title")
  <!-- 8 in row with title -->
  <div class="container">
    <div class="row">
        <div class="col-12">
          <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
        </div>
        <div class="col-12">
          <div class="logos-wrap d-lg-flex align-items-center justify-content-between">
            @foreach($logos as $logo)
            <div class="logo">
              @if($logo['link'])
                <a href="{!! $logo['link'] !!}">
              @endif
              @php
              if(!empty($logo['logo_image'])){
                $img = \App\Controllers\App::imageWithAlt($logo['logo_image']);
                $img_type = \App\Controllers\App::checkImgExtension($logo['logo_image']['filename']);
              }
              @endphp
            @if(isset($img))
            @if($img_type == "svg")
            @php
                  echo file_get_contents($img['image'])
                  @endphp
              @else
              <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}">
              @endif
              @endif

                  @if($logo['link'])
                    </a>
                 @endif
          </div>
            @endforeach
        </div>
      </div>
    </div>
  </div>
  @elseif($layout == "third")
    <!-- 7 in row -->
      <div class="container">
        <div class="row">
          <div class="col-12">
            <h2 class="mb-4 ">{!! $title !!}</h2>
          </div>
          <div class="col-12">
            <div class="logos-wrap d-lg-flex align-items-center justify-content-between seven-row">
              @foreach($logos as $logo)
                <div class="logo">
                  @if($logo['link'])
                    <a href="{!! $logo['link'] !!}" target="_blank" rel="noopener">
                      @endif
                      @php
                        if(!empty($logo['logo_image'])){
                          $img = \App\Controllers\App::imageWithAlt($logo['logo_image']);
                          $img_type = \App\Controllers\App::checkImgExtension($logo['logo_image']['filename']);
                        }
                      @endphp
                      @if(isset($img))
                        @if($img_type == "svg")
                          @php
                            echo file_get_contents($img['image'])
                          @endphp
                        @else
                          <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}">
                        @endif
                      @endif

                      @if($logo['link'])
                    </a>
                  @endif
                </div>
              @endforeach
            </div>
          </div>
        </div>
      </div>
  @else
    <!-- 5 in row without title -->
  <div class="container">
    <div class="row">
        <div class="col-12">
          <div class="logos-wrap logos-links d-lg-flex align-items-center justify-content-between">
            @foreach($logos as $logo)
              @if($logo['link'])
              <a href="{!!$logo['link']!!}" class="logo" target="_blank" rel="noopener noreferrer">
              @endif
              @php
              if(!empty($logo['logo_image'])){
                $img = \App\Controllers\App::imageWithAlt($logo['logo_image']);
                $img_type = \App\Controllers\App::checkImgExtension($logo['logo_image']['filename']);
              }
              @endphp
            @if(isset($img))
            @if($img_type == "svg")
            @php
                  echo file_get_contents($img['image'])
                  @endphp
              @else
              <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}">
              @endif
              @endif
             @if($logo['link'])
              </a>
             @endif
            @endforeach
        </div>
      </div>
    </div>
  </div>
  @endif
</section>
