{{--
  Title: Progress bar with tabs
  Description: Progress bar with tabs
  Category: montway_blocks
  Icon: admin-comments
  Keywords: progress bar
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/progress-bar-tabs.png
--}}
@php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

  $steps_first = get_field('steps_first');
  $steps_second = get_field('steps_second');
  $title = get_field('title');
  $subtitle = get_field('subtitle');
@endphp
<section data-{{ $block['id'] }} class="progress-bar-tabs tab-container bg-gray-white">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h3 class="mb-3 h2">{!! $title !!}</h3>
        <h4 class="h5 bold-desc mb-4">{!! $subtitle !!}</h4>
      </div>
      <div class="col-12">
        <div class="steps-tabs mb-lg-3">
          <div id="tab-1" class="tab tab-button is-active">Shipping to Hawaii</div>
          <div id="tab-2" class="tab tab-button">Shipping from Hawaii</div>
        </div>

        <div class="steps-hawaii tab-1 row">
          @foreach($steps_first as $first)
            <div class="col-lg-3">
              <div class="single-step  js-parent-container-open">
                <div class="d-flex flex-column align-items-center js-container-toggle">
                  @php
                    if(!empty($first['icon'])){
                    $img = \App\Controllers\App::imageWithAlt($first['icon']);
                    $img_type = \App\Controllers\App::checkImgExtension($first['icon']['filename']);
                    }
                  @endphp
                  @if(isset($img))
                    @if($img_type == "svg")
                      <span class="icon-montway">
                        @php
                          echo file_get_contents($img['image'])
                        @endphp
                      </span>
                    @else
                      <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}">
                    @endif
                  @endif
                  <div class="d-flex flex-column align-items-center">
                    <h2 class="step-number text-blue h4 bold">{!! $first['label'] !!}</h2>
                    <p class="h6 bold">{!! $first['text'] !!}</p>
                    <div class="text-wrap">{!! $first['body_copy'] !!}</div>
                    <div class="item-hidden">{!! $first['body_copy_hidden'] !!}</div>
                    <button data-text-open="Read less" data-text-close="Read more"
                      class="is-underline p-0 js-button-trigger js-see-more-button mb-3">
                      <span class="js-button-text">Read more</span></button>
                  </div>
                </div>
              </div>
            </div>
          @endforeach
        </div>

        <div class="steps-hawaii tab-2 row is-hidden">
          @foreach($steps_second as $second)
            <div class="col-lg-3">


              <div class="single-step js-parent-container-open">
                <div class="d-flex flex-column align-items-center js-container-toggle">

                  @php
                    if(!empty($second['icon'])){
                    $img = \App\Controllers\App::imageWithAlt($second['icon']);
                    $img_type = \App\Controllers\App::checkImgExtension($second['icon']['filename']);
                    }
                  @endphp
                  @if(isset($img))
                    @if($img_type == "svg")
                      <span class="icon-montway">
                        @php
                          echo file_get_contents($img['image'])
                        @endphp
                      </span>
                    @else
                      <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}">
                    @endif
                  @endif
                  <div class="d-flex flex-column align-items-center">
                    <h2 class="step-number text-blue h4 bold">{!! $second['label'] !!}</h2>
                    <h5 class="h6 bold">{!! $second['text'] !!}</h5>
                    <div class="text-wrap">{!! $second['body_copy'] !!}</div>
                    <div class="item-hidden">{!! $second['body_copy_hidden'] !!}</div>
                    <button data-text-open="Read less" data-text-close="Read more"
                      class="is-underline p-0 js-button-trigger js-see-more-button mb-3">
                      <span class="js-button-text">Read more</span></button>
                  </div>
                </div>
              </div>
            </div>
          @endforeach
        </div>
      </div>
    </div>
  </div>
</section>
