{{--
  Title: Rating Slider
  Description: Rating Slider
  Category: montway_blocks
  Icon: admin-comments
  Keywords: reviews rating slider
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/rating.png
--}}
@php
  $display_reviews = get_field("single_rating");
  $padding = get_field("block_padding");
  // $title = get_field('title');
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="bg-white ratings-slider position-relative">
  <div class="container">
    <div class="row justify-content-between">
      <div class="col-12 swiper-container ratings-swiper">
        <div class="swiper-wrapper">
          @foreach($display_reviews as $review)
            <div class="swiper-slide">
              <div class="rating-box">
                @php
                  $stars = \App\Controllers\App::startRating($review['average_rating']);
                  $review_logo_type = \App\Controllers\App::checkImgExtension($review['company_logo']['filename']);
                  $review_logo = \App\Controllers\App::imageWithAlt($review['company_logo']);
                @endphp
                <div>
                  <div class="logo mb-2">
                    @if($review_logo_type == "svg")
                      @php
                        echo file_get_contents($review_logo['image'])
                      @endphp
                    @else
                      <img src="{!! $review_logo['image'] !!}" alt="{!! $review_logo['alt'] !!}"
                        srcset="{!! $review_logo['small'] . $review_logo['medium'] . $review_logo['large'] !!}">
                    @endif
                  </div>
                  <div class="d-flex stars-wrap">
                    @for($i=0; $i<$stars['full']; $i++)
                      <img src={!! get_template_directory_uri() . '/assets/images/review-page-star.png' !!} />
                    @endfor
                    @if(isset($stars['half']))
                      <img src={!! get_template_directory_uri() . '/assets/images/review-page-' .$stars['half'].'.png'
                        !!} />
                    @endif
                  </div>

                </div>
                <div class="d-flex align-items-center flex-md-column ">
                  @php
                    $rating = number_format((float)$review['average_rating'], 1, '.', '');
                  @endphp
                  <span class=" rating text-gray mr-3 mr-md-0">{!! $rating !!}</span>

                </div>
                <span class="d-block reviews-amount">{!! $review['number_of_ratings'] !!} reviews</span>
              </div>
            </div>
          @endforeach
        </div>
        <div class="swiper-pagination ratings-pagination"></div>

      </div>
      <div class="swiper-button-prev ratings-prev"></div>
      <div class="swiper-button-next ratings-next"></div>
    </div>
  </div>
</section>
