{{--
  Title: Rating Module
  Description: Rating Module
  Category: montway_blocks
  Icon: admin-comments
  Keywords: reviews rating
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/rating.png
--}}
@php
  $slider_type = get_field("display_type");
  $display_reviews = get_field("single_rating");
  $padding = get_field("block_padding");
   $title = get_field('title');
   $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }}  class="bg-white ratings">
  <div class="container">
    <div class="row justify-content-between">
      @if(!empty($title))
      <div class="col-12 d-none d-lg-flex align-items-center mb-4 mb-lg-5">

        <h3 class="mr-4 h2 flex-none">{!! $title !!}</h3>
        <hr class="separator">
      </div>
      @endif
    @if($slider_type == "four_line")
      @foreach($display_reviews as $review)
      <div class="col-12 col-sm-6 mb-3 mb-xl-0 col-xl-3">
          <div class="rating-box">
            @php
            $stars = \App\Controllers\App::startRating($review['average_rating']);

            $review_logo_type = \App\Controllers\App::checkImgExtension($review['company_logo']['filename']);
            $review_logo = \App\Controllers\App::imageWithAlt($review['company_logo']);
          @endphp
            <div>
              <p class="p text-gray">{!! $review['company_name'] !!}</p>
              <div class="d-flex stars-wrap">

                @for($i=0; $i<$stars['full']; $i++)
                <img src={!! get_template_directory_uri() . '/assets/images/review-page-star.png' !!} />
                @endfor
                @if(isset($stars['half']))
                <img src={!! get_template_directory_uri() . '/assets/images/review-page-'.$stars['half'].'.png' !!} />
                @endif
              </div>
              <span class="text-small text-gray-medium">({!! $review['number_of_ratings'] !!} reviews)</span>
            </div>
            <div class="d-flex align-items-center flex-md-column rating-box-width">
              <span class=" rating text-gray mr-2 mr-md-0">{!! $review['average_rating'] !!}</span>




              @if($review_logo_type == "svg")
              @php
                  echo file_get_contents($review_logo['image'])
                  @endphp
              @else
              <img src="{!! $review_logo['image'] !!}" alt="{!! $review_logo['alt'] !!}" srcset="{!! $review_logo['small'] . $review_logo['medium'] . $review_logo['large'] !!}">
              @endif
           </div>
          </div>
        </div>
        @endforeach
      @else
        <!-- Three Box display  -->
          @foreach($display_reviews as $review)
            <div class="col-12 col-sm-6 mb-3 mb-xl-0 col-xl-3">
              <div class="rating-box">
                @php
                  $stars = \App\Controllers\App::startRating($review['average_rating']);

                  $review_logo_type = \App\Controllers\App::checkImgExtension($review['company_logo']['filename']);
                  $review_logo = \App\Controllers\App::imageWithAlt($review['company_logo']);
                @endphp
                <div>
                  <p class="p text-gray">{!! $review['company_name'] !!}</p>
                  <div class="d-flex stars-wrap">

                    @for($i=0; $i<$stars['full']; $i++)
                      <img src={!! get_template_directory_uri() . '/assets/images/review-page-star.png' !!} />
                    @endfor
                    @if(isset($stars['half']))
                      <img src={!! get_template_directory_uri() . '/assets/images/review-page-'.$stars['half'].'.png' !!} />
                    @endif
                  </div>
                  <span class="text-small text-gray-medium">({!! $review['number_of_ratings'] !!} reviews)</span>
                </div>
                <div class="d-flex align-items-center flex-md-column rating-box-width">
                  @php
                    $rating = number_format((float)$review['average_rating'], 1, '.', '');
                  @endphp
                  <span class=" rating text-gray mr-3 mr-md-0">{!! $rating !!}</span>




                  @if($review_logo_type == "svg")
                    @php
                      echo file_get_contents($review_logo['image'])
                    @endphp
                  @else
                    <img src="{!! $review_logo['image'] !!}" alt="{!! $review_logo['alt'] !!}" srcset="{!! $review_logo['small'] . $review_logo['medium'] . $review_logo['large'] !!}">
                  @endif
                </div>
              </div>
            </div>
          @endforeach
      @endif
    </div>
  </div>
</section>
