{{--
  Title: Reviews Box Layout Module
  Description:Reviews Box Layout Module
  Category: montway_blocks
  Icon: admin-comments
  Keywords: reviews
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/reviews-layout.png
--}}
@php
  $title = get_field('title');
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

  $reviews = get_field('select_reviews');
  if(!empty($reviews)){
  $display_reviews = \App\Controllers\App::getReviews($reviews);
  }else{
  $display_reviews = \App\Controllers\App::getReviews();
  }
@endphp
<section data-{{ $block['id'] }} class="reviews-box-layout">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
      </div>
      <div class="col-12 mb-3">
        <div class="reviews-grid">

          @foreach ( array_chunk( $display_reviews, 4, true ) as $i => $d_reviews )
          @if ( $i < 2 )
            @if ( $i % 2 == 0 )
            <div class="row">
            @else
            <div class="row flex-row-reverse">
            @endif
          @else
            @if ( $i % 2 == 0 )
            <div class="row d-none">
            @else
            <div class="row flex-row-reverse d-none">
            @endif
          @endif
              @foreach ( array_chunk( $d_reviews, 2, true ) as $j => $d_r)
                @if ( $j % 2 == 0 )
                <div class="col-md-6 horizontal">
                @else
                <div class="col-md-6 vertical">
                @endif
                  @foreach($d_r as $key => $review)
                    <a href="{!! $review['external_review_link'][0] !!}" class="review-page-box mb-3" target="_blank" rel="noopener noreferrer">
                      <h4 class="h4 mb-3">{!! $review['review_title'][0] !!}</h4>
                      <div class="d-flex align-items-center flex-wrap mb-3">
                        <div class="d-flex rating-star-wrap align-items-center ">
                          <div class="review-box-rating-wrap mr-2">
                            @php
                              $rating = number_format((float)$review['rating'][0], 1, '.', '');
                            @endphp
                            <span class="rating">{!! $rating !!} /<span class="text-gray-medium">5</span></span>
                          </div>
                          @php
                            $stars = \App\Controllers\App::startRating($review['rating'][0]);
                          @endphp
                          <div class="stars-wrap mr-md-3">
                            @for($i=0; $i<$stars['full']; $i++)
                              <img src={!! get_template_directory_uri() . '/assets/images/review-page-star.png' !!} />
                            @endfor
                            @if(isset($stars['half']))
                              <img src={!! get_template_directory_uri() . '/assets/images/review-page-' .$stars['half'].'.png'
                                !!} />
                            @endif
                          </div>
                        </div>

                        <p class="text-caption text-gray-medium reviewed-by">Reviewed by {!! $review['name'][0] !!} on {!!
                          $review['date'][0]
                          !!}</p>
                      </div>
                      <div class="review-body text-gray-medium text-caption">
                        {!! $review['review'][0] !!}
                      </div>
                      <div class="img-wrap logo-wrap mt-3">
                        <img src="{!! $review['logo'][0]['image'] !!}" alt="{!! $review['logo'][0]['alt'] !!}"
                          {{-- srcset="{!! $review['logo'][0]['small'] . $review['logo'][0]['medium'] . $review['logo'][0]['large'] !!}" --}}>
                      </div>
                    </a>
                  @endforeach
                </div>
              @endforeach
            </div>
          @endforeach
          <div class="mt-4 d-flex justify-content-center">

            <button class="button-secondary show-reviews-button w-md-auto w-100">Show more</button>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
