{{--
Title: Distance and days table
Description: Distance and days table
Category: help_center_blocks
Icon: admin-comments
Keywords: table
Mode: edit
Align: center
PostTypes: help-center
SupportsAlign: left right center
SupportsMode: true
SupportsMultiple: true
Preview: true
PreviewImage: /resources/assets/block-images/distance-table.png
--}}
@php
  $title = get_field('title');
  $padding = get_field('block_padding');
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $rating_shortcode = get_field('rating_shortcode');
@endphp
<section class="col-12 mb-3" data-{{ $block['id'] }} >
  <h2 class="mb-3 mb-lg-4">{!! $title !!}</h2>
  <div class="table-distance">
    @if(have_rows('table'))
      @while(have_rows('table'))
        @php the_row();
        @endphp
        <table>
          <thead>
          <tr>
            @if(have_rows('table_head'))
              @while(have_rows('table_head'))
                @php the_row(); @endphp
                <th>{!! get_sub_field('text') !!}</th>
              @endwhile

            @endif
          </tr>
          </thead>
          <tbody>
          @if(have_rows('table_body'))
            @while(have_rows('table_body'))
              @php the_row(); @endphp
              <tr>
                <td>{!! get_sub_field('first_column') !!}</td>
                <td>{!! get_sub_field('second_column') !!}</td>
              </tr>
            @endwhile
          @endif
          </tbody>
        </table>
        <span>{!! get_sub_field('estimate') !!}</span>
      @endwhile
    @endif
  </div>
</section>
<div>
  @php echo do_shortcode($rating_shortcode); @endphp
</div>
