{{--
  Title: Table Module
  Description: Table  Module
  Category: montway_blocks
  Icon: admin-comments
  Keywords: table
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/table.png
--}}
@php
$title = get_field('title');
$subtitle = get_field("subtitle");
$table = get_field('table_group');
$table_select = get_field('table_layout');
$copy_transit = get_field('copy_transit_time');
$padding = get_field("block_padding");
$name = [];
$fields = get_field_objects();
foreach($fields as $field) {
  $id = $field['parent'];
}
$tabs = acf_get_fields($id);
for($i = 0; $i < sizeof($tabs); $i++) {
  $type = $tabs[$i]['type'];
  if($type == 'tab') {
    $name[] = $tabs[$i]['label'];
  }
}

$inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }}>
  <div class="container">
    <div class="row {{ ( $table_select == 'four' ) ? 'mb-5' : ''}}">
      <div class="col-12">

      <h2 class="{{ ( $table_select == 'four' ) ? 'mb-5' : 'mb-32'}}">{!! $title !!}</h2>
      <p class="text-gray">{!! $subtitle !!}</p>
    </div>

    </div>
@if($table_select == 'four')
  <!-- 4 column layout -->

  <!-- ova tabela ide za prvi tab -->

  <div class="row">
    <div class="col-12 d-flex justify-content-center table-button-wrap">
      @foreach( $name as $key => $n )
        @if( $key == 0 )
        <button id="table-tab-{{ $key }}" class="table-button active">{!! $n !!}</button>
        @else
        <button id="table-tab-{{ $key }}" class="table-button">{!! $n !!}</button>
        @endif
      @endforeach
    </div>
    <div class="col-xl-8 col-lg-9 mx-auto p-0 px-sm-3 pb-3 tabs-table">
      <div class="table-wrap" data-tab="table-tab-0">
        @if(have_rows('table_group'))
          @while(have_rows('table_group'))
            @php the_row(); @endphp
            <table class="text-center alternating-colors table">
              <thead>
                <tr>
                  @if(have_rows('table_head'))
                    @while(have_rows('table_head'))
                      @php the_row();
                      $origin_head = get_sub_field('origin');
                      $destination_head = get_sub_field('destination');
                      $costs_head = get_sub_field('average_door-to-door_costs');
                      $centers_head = get_sub_field('average_cost_between_distribution_centeres');
                      @endphp
                      <th class="text-center">{!! $origin_head !!}</th>
                      <th class="text-center">{!! $destination_head !!}</th>
                      <th class="text-center">{!! $costs_head !!}</th>
                      <th class="text-center">{!! $centers_head !!}</th>
                    @endwhile
                  @endif
                </tr>
              </thead>
              <tbody>
                  @if(have_rows('table'))
                    @while(have_rows('table'))
                      <tr class="">
                        @php the_row();
                        $origin = get_sub_field('origin');
                        $destination = get_sub_field('destination');
                        $costs = get_sub_field('costs');
                        $centers = get_sub_field('centers');
                        @endphp
                        <td class="w-155">{!! $origin !!}</td>
                        <td class="w-155">{!! $destination !!}</td>
                        <td>{!! $costs !!}</td>
                        <td>{!! $centers !!}</td>
                      </tr>
                      @endwhile
                  @endif
              </tbody>
            </table>
          @endwhile
        @endif
      </div>
      <div class="px-4 px-lg-0 ">
        <div class="table-wrap d-none width-600 mx-auto"  data-tab="table-tab-1">
        @if(have_rows('table_group_delivery'))
          @while(have_rows('table_group_delivery'))
            @php the_row(); @endphp
            <table class="text-center alternating-colors  table">
              <thead>
                <tr>
                  @if(have_rows('table_head_delivery'))
                    @while(have_rows('table_head_delivery'))
                      @php the_row();
                      $distance_delivery = get_sub_field('total_distance_head');
                      $costs_delivery = get_sub_field('average_door-to-door_costs_head');
                      $centers_delivery = get_sub_field('average_cost_between_distribution_centeres_head');
                      @endphp
                      <th class="text-center">{!! $distance_delivery !!}</th>
                      <th class="text-center">{!! $costs_delivery !!}</th>
                      <th class="text-center">{!! $centers_delivery !!}</th>
                    @endwhile
                  @endif
                </tr>
              </thead>
              <tbody>
                  @if(have_rows('table'))
                    @while(have_rows('table'))
                      <tr class="">
                        @php the_row();
                        $distance_del = get_sub_field('total_distance');
                        $cost_del = get_sub_field('average_door-to-door_costs');
                        $centers_del = get_sub_field('average_cost_between_distribution_centeres');
                        @endphp
                        <td class="one-third">{!! $distance_del !!}</td>
                        <td class="one-third">{!! $cost_del !!}</td>
                        <td class="one-third">{!! $centers_del !!}</td>
                      </tr>
                      @endwhile
                  @endif
              </tbody>
            </table>
          @endwhile
        @endif
        </div>
      </div>
      <div class="px-4 px-lg-0 " >
      <div class="table-wrap mx-auto d-none" data-tab="table-tab-2">
        @if(have_rows('table_group_transit'))
        @while(have_rows('table_group_transit'))
          @php the_row(); @endphp
          <table class="text-center alternating-colors mb-0 table">
            <thead>
              <tr>
                @if(have_rows('table_head_transit'))
                  @while(have_rows('table_head_transit'))
                    @php the_row();
                    $mileage_head = get_sub_field('mileage_head');
                    $average_transit_time_head = get_sub_field('average_transit_time_head');
                    @endphp
                    <th class="text-center">{!! $mileage_head !!}</th>
                    <th class="text-center">{!! $average_transit_time_head !!}</th>
                  @endwhile
                @endif
              </tr>
            </thead>
            <tbody>
                @if(have_rows('table'))
                  @while(have_rows('table'))
                    <tr class="">
                      @php the_row();
                      $mileage = get_sub_field('mileage');
                      $average_transit_time = get_sub_field('average_transit_time');
                      @endphp
                      <td >{!! $mileage !!}</td>
                      <td >{!! $average_transit_time !!}</td>
                    </tr>
                    @endwhile
                @endif
            </tbody>
          </table>
        @endwhile
        <p>{{ $copy_transit }}</p>
      @endif
      </div>
    </div>
    </div>
  </div>
  <!-- ovde je kraj svega za prvu tabelu -->
  <!-- kad se zavrsi prvi tab u koji ce ici ova prva tabela, onda cu dodati i ostale dve, da ne bude previse koda sada dok ne sredis -->
@else
  <!-- 3 column layout -->
  <div class="col-xl-8 col-lg-9 mx-auto px-0">
    @if(have_rows('table_group_second'))
        @while(have_rows('table_group_second'))
          @php the_row(); @endphp
          <table class="alternating-colors-odd">
            <thead >
            <tr>
              @if(have_rows('table_head'))
                @while(have_rows('table_head'))
                  @php the_row();
                    if(get_sub_field('head_image')){
                      $img = get_sub_field('head_image');
                      $image = \App\Controllers\App::imageWithAlt(get_sub_field('head_image'));
                      $image_type = \App\Controllers\App::checkImgExtension($img['filename']);
                    }
                  @endphp
                  <th class="text-center px-0 th-image">
                    @if(isset($image))
                      @if($image_type == "svg")
                        @php
                          echo file_get_contents($image['image'])
                        @endphp
                      @else
                        <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}" >
                      @endif
                    @endif
                    @if ( !empty( get_sub_field( 'head_copy_text' ) ) )
                        <p class="head-copy">{{ get_sub_field( 'head_copy_text' ) }}</p>
                    @endif
                  </th>
                @endwhile
              @endif
            </tr>
            </thead>
            <tbody>
            @if(have_rows('table'))
              @while(have_rows('table'))
                <tr>
                  @php the_row();
                  $first_column = get_sub_field('first_column');
                  $second_column = get_sub_field('second_column');
                  $third_column = get_sub_field('third_column');
                  @endphp
                  <td class="text-center" style="width: 40%">
                    {!! $first_column !!}
                  </td>
                  <td class="text-center check-mark" style="width: 30%">
                    @if($second_column)
                      <img src="/app/uploads/2021/12/checkmark-green.png" alt="check">
                    @else
                      <img src="/app/uploads/2021/12/x-red.png" alt="uncheck">
                    @endif
                  </td>
                  <td class="text-center check-mark" style="width: 30%">
                    @if($third_column)
                      <img src="/app/uploads/2021/12/checkmark-green.png" alt="check">
                    @else
                      <img src="/app/uploads/2021/12/x-red.png" alt="uncheck">
                    @endif
                  </td>
                </tr>
              @endwhile
            @endif
            </tbody>
          </table>
        @endwhile
    @endif
  </div>
@endif
  </div>
</section>
