{{--
  Title: Team Members Module
  Description: Team Members Module
  Category: montway_blocks
  Icon: admin-comments
  Keywords: team members
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/team-member.png
--}}
@php
$title = get_field("title");
$members = get_field("member");
$padding = get_field("block_padding");
 $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="team-section" >
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h2 class="mb-5">{!! $title !!}</h2>
      </div>
      <div class="col-12 col-lg-10 offset-lg-1">
  @foreach($members as $member)
  <div class="team-member mb-4 mb-xl-5 d-flex align-items-center ">
    <div class="img-wrap mr-4">
      @php
        if(!empty($member['member_image'])){
          $img = \App\Controllers\App::imageWithAlt($member['member_image']);
          $img_type = \App\Controllers\App::checkImgExtension($member['member_image']['filename']);
        }
      @endphp
      @if(isset($img))
        @if($img_type == "svg")
          @php
            echo file_get_contents($img['image'])
          @endphp
        @else
          <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
               srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">
        @endif
      @endif
    </div>
    <div class="team-text">
      <h3 class=" h6 text-black">{!! $member['name'] !!}</h3>
      <h4 class="p mb-1 text-black">{!! $member['job_position'] !!}</h4>
      <div class="body-link">{!! $member['body_copy'] !!}</div>
    </div>
  </div>
  @endforeach
  </div>
  </div>
  </div>
</section>
