{{--
  Title: Text and 4 columns bellow
  Description: Text and 4 columns bellow
  Category: montway_blocks
  Icon: admin-comments
  Keywords: text column
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/text-4-columns.png
--}}
@php
  $title = get_field('title');
  $body_copy = get_field('body_copy');
  $padding = get_field('block_padding');
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $column_layout = get_field('column_layout');
@endphp
<section data-{{ $block['id'] }} class="{{ ( $column_layout == 'four' ) ? 'bg-light' : 'bg-white' }} text-4-col mw-100">
  <div class="container">
    <div class="row">
      <div class="col-12">
        @if ( $title )
        <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
        @endif
        <div class="mb-4 body-link">{!! $body_copy !!}</div>
      </div>

      <div class="col-12">
        @if($column_layout == 'four')
        <div class="col-grid">
          @if(have_rows('columns'))
            @while(have_rows('columns'))
              @php
                the_row();
                $text = get_sub_field('text');
                $icon = get_sub_field('icon');
                if(!empty($icon)){
                $image = \App\Controllers\App::imageWithAlt($icon);
                $image_type = \App\Controllers\App::checkImgExtension($icon['filename']);
                }
              @endphp
              <div class="d-flex align-items-center flex-column py-4">
                <div class="logo-wrap">
                    <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                      srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
                </div>
                <span class="desc">{!! $text !!}</span>
              </div>
            @endwhile
            @endif
        </div>
        @else
          <!-- 3 columns grid -->
          <div class="col-grid col-grid-3">
            @if(have_rows('columns'))
              @while(have_rows('columns'))
                @php
                  the_row();
                  $text = get_sub_field('text');
                  $icon = get_sub_field('icon');
                  if(!empty($icon)){
                  $image = \App\Controllers\App::imageWithAlt($icon);
                  $image_type = \App\Controllers\App::checkImgExtension($icon['filename']);
                  }
                @endphp
                <div class="d-flex align-items-center flex-column py-4">
                  <div class="logo-wrap">
                    <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                         srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
                  </div>
                  <span class="desc font-weight-bold">{!! $text !!}</span>
                </div>
              @endwhile
            @endif
          </div>
        @endif
      </div>

    </div>
  </div>
</section>
