{{--
  Title: Text and image on one side and a list/accordion on the other
  Description: Text and image on one side and a list/accordion on the other
  Category: montway_blocks
  Icon: admin-comments
  Keywords: text image list accordion
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/text-image-side-list-on-another.png
--}}
@php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp

  @if(have_rows('section'))
  @php
  $rowCount = 0;
  @endphp
    @while(have_rows('section'))
      @php
        the_row();
        $title = get_sub_field("title");
        $body_copy = get_sub_field("body_copy");
        $large_image = get_sub_field("large_image");
        if(!empty($large_image)){
        $large_image_type = \App\Controllers\App::checkImgExtension($large_image['filename']);
        $large_image = \App\Controllers\App::imageWithAlt($large_image);
        }
        $first_row_of_images = get_sub_field("first_row_of_images");
        $first_images_type = [];
        $first_images = [];
        if(!empty($first_row_of_images)){
        foreach ($first_row_of_images as $item) {
        if(!empty($item['logos'])){
        $first_images_type[] = \App\Controllers\App::checkImgExtension($item['logos']['filename']);
        $first_images[] = \App\Controllers\App::imageWithAlt($item['logos']);
        }

        }
        }

        $second_row_of_images = get_sub_field("second_row_of_images");
        $second_images_type = [];
        $second_images = [];
        if(!empty($second_row_of_images)){
        foreach ($second_row_of_images as $item) {
        if(!empty($item['logos'])){
        $second_images_type[] = \App\Controllers\App::checkImgExtension($item['logos']['filename']);
        $second_images[] = \App\Controllers\App::imageWithAlt($item['logos']);
        }

        }
        }
        $list = get_sub_field("list");
        @endphp
         @if ($rowCount++ % 2 == 1)
<section id="section_{!! $rowCount !!}" data-{{ $block['id'] }} class="text-image-list bg-gray">
  <div class="container">
    <div class="row">
      <div class="col-lg-5 order-2 order-lg-1">
        <div>
          @foreach($list as $val)
            <div class="box-icon-text has-border js-container-toggle">
              @php
                if(!empty($val['icon'])){
                $image = \App\Controllers\App::imageWithAlt($val['icon']);
                $image_type = \App\Controllers\App::checkImgExtension($val['icon']['filename']);
                }
              @endphp
              <div class="d-flex align-items-center justify-content-between ">
                <div class="d-flex align-items-center">
                  @if(!empty($image))
                    @if($image_type == "svg")
                      <span class="box-icon p-absolute">
                        @php
                          echo file_get_contents($image['image'])
                        @endphp
                      </span>
                    @else
                      <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                        srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
                    @endif
                  @endif
                  <h3 class="h5 bold-desc mb-0 mb-lg-2">{!! $val['title'] !!}</h3>
                </div>
                <i class="icon icon-keyboard_arrow_right"></i>
              </div>
              <div class="text-wrap body-link">{!! $val['body_copy'] !!}</div>
            </div>
          @endforeach
        </div>
      </div>
      <div class="col-lg-6 offset-lg-1 order-1 order-lg-2">
        <h2 class="mb-4">{!! $title !!}</h2>
        <div class="mb-4 mb-lg-5 body-link">{!!$body_copy!!}</div>
        @if(!empty($large_image))
          @if($large_image_type == "svg")
            @php
              echo file_get_contents($large_image['image'])
            @endphp
          @else
            <div class="img-wrap img-right mb-5">
              <img src="{!! $large_image['image'] !!}" alt="{!! $large_image['alt'] !!}"
                srcset="{!! $large_image['small'] . $large_image['medium'] . $large_image['large'] !!}">
            </div>
          @endif
        @endif
        <div class="d-flex flex-wrap align-items-center justify-content-between">
          @forelse($first_images as $key => $image)
            @if($first_images_type[$key] == "svg")
              <div class="logo-wrap">
                @php
                  echo file_get_contents($image['image'])
                @endphp
              </div>
            @else
              <div class="logo-wrap">
                <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}">
              </div>
            @endif
          @empty
          @endforelse
        </div>
      </div>

      <div class="col-12 mt-4 order-2">
        <div class="d-flex flex-wrap align-items-center justify-content-between">
          @forelse($second_images as $key => $image)
            @if($second_images_type[$key] == "svg")
              <div class="logo-wrap">
                @php
                  echo file_get_contents($image['image'])
                @endphp
              </div>
            @else
              <div class="logo-wrap">
                <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}">
              </div>
            @endif
          @empty
          @endforelse
        </div>
      </div>
    </div>
  </div>
</section>
  @else
  <section id="section_{!! $rowCount !!}" data-{{ $block['id'] }} class="text-image-list bg-gray-white">
    <div class="container">
      <div class="row">
        <div class="col-lg-6">
          <h2 class="mb-4">{!! $title !!}</h2>
          <div class="mb-4 mb-lg-5 body-link">{!!$body_copy!!}</div>
          @if(!empty($large_image))
            @if($large_image_type == "svg")
              @php
                echo file_get_contents($large_image['image'])
              @endphp
            @else
              <div class="img-wrap img-left mb-60">
                <img src="{!! $large_image['image'] !!}" alt="{!! $large_image['alt'] !!}">
              </div>
            @endif
          @endif
          <div class="d-flex flex-wrap align-items-center justify-content-between left-logo-wrap">
            @forelse($first_images as $key => $image)
              @if($first_images_type[$key] == "svg")
                <div class="logo-wrap">
                  @php
                    echo file_get_contents($image['image'])
                  @endphp
                </div>
              @else
                <div class="logo-wrap">
                  <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}">
                </div>
              @endif
            @empty
            @endforelse
          </div>
        </div>
        <div class="col-lg-6">
          <div class="text-img-list-wrap">
            @foreach($list as $val)
              <div class="box-icon-text has-border js-container-toggle">
                @php
                  if(!empty($val['icon'])){
                  $image = \App\Controllers\App::imageWithAlt($val['icon']);
                  $image_type = \App\Controllers\App::checkImgExtension($val['icon']['filename']);
                  }
                @endphp
                <div class="d-flex align-items-center justify-content-between ">
                  <div class="d-flex align-items-center">
                    @if(!empty($image))
                      @if($image_type == "svg")
                        <span class="box-icon p-absolute">
                          @php
                            echo file_get_contents($image['image'])
                          @endphp
                        </span>
                      @else
                        <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}"
                          srcset="{!! $image['small'] . $image['medium'] . $image['large'] !!}">
                      @endif
                    @endif
                    <h3 class="h5 bold-desc mb-0 mb-lg-2">{!! $val['title'] !!}</h3>
                  </div>
                  <i class="icon icon-keyboard_arrow_right"></i>
                </div>
                <div class="text-wrap mt-0 body-link">{!! $val['body_copy'] !!}</div>
              </div>
            @endforeach
          </div>
        </div>
        <div class="col-12 mt-4">
          <div class="d-flex flex-wrap align-items-center justify-content-between">
            @forelse($second_images as $key => $image)
              @if($second_images_type[$key] == "svg")
                <div class="logo-wrap">
                  @php
                    echo file_get_contents($image['image'])
                  @endphp
                </div>
              @else
                <div class="logo-wrap">
                  <img src="{!! $image['image'] !!}" alt="{!! $image['alt'] !!}">
                </div>
              @endif
            @empty
            @endforelse
          </div>
        </div>
      </div>
    </div>
  </section>
  @endif
    @endwhile
  @endif

