{{--
  Title: Three tabs module
  Description: Three tabs module
  Category: montway_blocks
  Icon: admin-comments
  Keywords: tabs
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/three-tabs.png
--}}
@php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $tabs = get_field('tabs');
@endphp
<section data-{{ $block['id'] }} class="background-dark mob-hidden">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <div class="tabs-wrap d-flex justify-content-between">

          @if(have_rows('tabs'))
          @php
          $rowCount = 0;
          @endphp
            @while(have_rows('tabs'))
              @php
                the_row();
                $rowCount ++;
              @endphp
              <div>
                <a href="#section_{!! $rowCount !!}" class=" h5 d-flex tab-link">{!! get_sub_field('link_text') !!}
                  <i class="icon-arrow_downward "></i></a>
              </div>
            @endwhile
          @endif
        </div>
      </div>
    </div>
  </div>
</section>
