{{--
  Title: A title and a text on the left and a list on right
  Description: A title and a text on the left and a list on right
  Category: montway_blocks
  Icon: admin-comments
  Keywords: title text list
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/title-left-list-right.png
--}}
@php
  $title = get_field("title");
  $body_copy = get_field("body_copy");
  $list = get_field("list");
  $button = get_field("button");
  $padding = get_field("block_padding");

   $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;

@endphp
<section data-{{ $block['id'] }} class="bg-gray-white">
  <div class="container">


    <div class="row">


      <div class="col-lg-6 pt-40 mb-5 mb-md-0">
        <h2 class="mb-4">{!! $title !!}</h2>
        <div class="body-link">{!! $body_copy !!}</div>
        <a class="button-secondary mt-5" href="{!! $button['button_link'] !!}">{!! $button['button_text'] !!}</a>
      </div>
      <div class=" col-lg-5 offset-lg-1">
        @foreach($list as $item)
          <div class="box-icon-text has-border js-container-toggle">

            @php
              $img_id = $item['icon'];
              if(!empty($img_id)) {
              $icon = \App\Controllers\App::imageWithAlt($img_id);
              $icon_type = \App\Controllers\App::checkImgExtension($img_id['filename']);
              }
            @endphp
            <div class="d-flex align-items-center justify-content-between ">
              <div class="d-flex align-items-center">
                @if(isset($icon))
                  @if($icon_type == "svg")
                    <span class="box-icon p-absolute">
                      @php
                        echo file_get_contents($icon['image'])
                      @endphp
                    </span>
                  @else
                    <img src="{!! $icon['image'] !!}" alt="{!! $icon['alt'] !!}"
                      srcset="{!! $icon['small'] . $icon['medium'] . $icon['large'] !!}" />
                  @endif
                @endif
                <h3 class="h5 bold-desc mb-0 mb-lg-3">{!! $item['title'] !!}</h3>
              </div>
              <i class="icon icon-keyboard_arrow_right"></i>
            </div>
            <div class="text-wrap body-link">
              {!! $item['body_copy'] !!}
            </div>
          </div>
        @endforeach
      </div>
    </div>
  </div>
</section>
