{{--
  Title: 2 columns text and icons
  Description: 2 columns text and icons
  Category: montway_blocks
  Icon: admin-comments
  Keywords: image text cta
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/two-columns-text-icons.png
--}}
@php
  $title = get_field('title');
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
@endphp
<section data-{{ $block['id'] }} class="onboarding">
  <div class="container">
    <div class="row">
      <div class="col-12 col-lg-8 mx-auto text-left text-lg-center">
        <h2 class="mb-4 mb-lg-5">{!! $title !!}</h2>
      </div>
      @php
        $rowCount = 0;
      @endphp
      <div class="col-12 ">
        <div class="onboarding-steps ">
          @if(have_rows('icon_block'))
            @while(have_rows('icon_block'))
              @php
                the_row();
                $text = get_sub_field('text');
                $image = get_sub_field('icon');
                $img = \App\Controllers\App::imageWithAlt($image);
                $img_type = \App\Controllers\App::checkImgExtension($image['filename'])
              @endphp

                <div class="step ">


                    <img src="{!! $img['image'] !!}" alt="{!! $img['alt'] !!}"
                      srcset="{!! $img['small'] . $img['medium'] . $img['large'] !!}">


                  <span class="h5">{!! $text !!}</span>


              </div>
            @endwhile
          @endif
        </div>
      </div>
    </div>
  </div>
</section>
