{{--
  Title: Title and text + Video
  Description: Title and text + Video
  Category: montway_blocks
  Icon: admin-comments
  Keywords: video
  Mode: edit
  Align: center
  PostTypes: page post
  SupportsAlign: left right center
  SupportsMode: true
  SupportsMultiple: true
  Preview: true
  PreviewImage: /resources/assets/block-images/video-text.png
--}}
@php
  $headline = get_field("headline");
  $subheadline = get_field("subheadline");
  $body_copy = get_field("body_copy");
  $video = get_field("video");
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $video_image_id = $video['video']['overlay_image'];
  if(!empty($video_image_id)){
  $video_image = \App\Controllers\App::imageWithAlt($video_image_id);
  $video_image_type = \App\Controllers\App::checkImgExtension($video_image_id['filename']);
  }
  $video_link = $video['video']['video_link'];
  $video_title = $video['video']['overlay_title'];
@endphp
<section data-{{ $block['id'] }} class="section-with-video">
  <div class="container">
    <div class="row">
      <div class="col-lg-6 pt-4 mb-4">
        <div>
          <h1 class="mb-3 mb-md-4">{!! $headline !!}</h1>
          <p class="mb-3 h5 subheadline">{!! $subheadline !!}</p>
          <div class="text-gray body-link">{!! $body_copy !!}</div>
        </div>
      </div>
      <div class="col-lg-6">
        <div class="video-wrap transform-0 h-100 video-box-all">
          <div class="video-thumbnail position-relative">
            <p class="position-absolute video-title h2 text-center mob-hidden ">{!! $video_title !!} </p>
            <button class="position-absolute text-center video-title h2 play-btn-home"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="160" height="160" viewBox="0 0 160 160"><defs><circle id="a" cx="80" cy="80" r="80"/></defs><g fill="none" fill-rule="evenodd"><use fill="#232B36" fill-opacity=".2" xlink:href="#a"/><circle cx="80" cy="80" r="78" stroke="#FFF" stroke-width="4"/><path fill="#FFF" d="M119.636 77.837c1.858 1.195 1.853 3.134 0 4.326l-63.272 40.674c-1.858 1.195-3.364.365-3.364-1.835V38.998c0-2.208 1.51-3.027 3.364-1.835l63.272 40.674z"/></g></svg></button>
            @if(isset($video_image))
              @if($video_image_type == "svg")
                @php
                  echo file_get_contents($video_image['image'])
                @endphp
              @else
                <img src="{!! $video_image['image'] !!}" alt="{!! $video_image['alt'] !!}"
                  srcset="{!! $video_image['small'] . $video_image['medium'] . $video_image['large'] !!}">
              @endif
            @endif

          </div>
          <div class="video-link w-100 d-none h-100 align-items-center">
            @php echo apply_filters( 'the_content', $video_link ); @endphp
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
