@extends('layouts.app')

@section('content')
  <div class="container mt-5">
    @include('partials.page-header')

    @if (!have_posts())
      <div class="alert alert-warning">
        {{ __('Sorry, no results were found.', 'sage') }}
      </div>
      {!! get_search_form(false) !!}
    @endif

    @php
      $page_id = get_queried_object_id();
      $cats = \App\Controllers\App::returnCategories();
      if(is_category()){
          $category_name = get_queried_object()->cat_name;
      }
      global $paged;
    @endphp

    <h1 class="h2 mb-2">{!! ( is_category(  ) ) ? $category_name : get_the_title($page_id) !!}</h1>
    <p class="mb-2 d-none d-lg-block">Select category</p>
    {{-- <ul class="d-flex category-nav justify-content-between">
      <li class="d-flex w-100"><a class="w-100" href="{!! "/blog" !!}">{!! "All" !!}</a></li>
      @foreach($cats['cat_id'] as $key => $cat)
        @if(isset($cats['cat_name'][$key]) && isset($cats['cat_id'][$key]))
          <li class="d-flex w-100">
            <a class="w-100" href="{!! $cats['cat_url'][$key] !!}">{!! $cats['cat_name'][$key] !!}</a>
          </li>
        @endif
      @endforeach
    </ul> --}}
    <div class="mb-5">
    @if ( has_nav_menu('blog_category_navigation') )
      {!! wp_nav_menu(['theme_location' => 'blog_category_navigation', 'menu_class' => 'd-none d-lg-flex category-nav justify-content-between']) !!}
      @php
          $navigation = wp_get_nav_menu_items( 'Blog Category Navigation' );
          // echo '<pre>';
          //   print_r($nav);
          //   echo '</pre>';
      @endphp
      <select class="blog-navigation-select d-block d-lg-none">
        <option>Select category...</option>
        @foreach ($navigation as $nav)
          <option value="{{ $nav->url }}">{{ $nav->title }}</option>            
        @endforeach
      </select>
    @endif
    </div>
    <div class="border-bottom mb-2 mb-lg-3"></div>

    @if ( !is_category(  ) &&  $paged < 2)
    <h2 class="mb-3 h4 font-weight-bold">Featured</h2>
      @php
          $args = array(
            'post_type' => 'post',
            'posts_per_page' => 1,
            'tag' => 'featured'
          );
          $query = new WP_Query( $args );
      @endphp
      @if ( $query->have_posts() )
        @while ( $query->have_posts() ) @php $query->the_post();
          $category = get_the_category();
          $cat_name = $category[0]->name;
          $cat_link = get_category_link($category[0]->term_id);
        @endphp
        
        <div class="d-block d-md-flex featured-post overflow-hidden mb-56 mb-2">
          <div class="col-md-7 featured-image pr-2 mb-0 pl-0">
            <a href="{{ get_the_permalink() }}">
              {!! get_the_post_thumbnail() !!}
            </a>
          </div>
          <div class="col-md-5 p-4 px-lg-4 pb-lg-3">
            <a href="{{ $cat_link }}" class="featured-category mb-2 d-inline-block text-blue">{!! $cat_name !!}</a>
            <h2 class="featured-title h4 font-weight-bold mb-3"><a href="{{ get_the_permalink() }}">{!! get_the_title() !!}</a></h2>
            <p class="featured-date mb-3 text-gray-medium">Posted on {!! get_the_date() !!}</p>
            <p class="featured-excerpt mb-3">{!! wp_trim_words( get_the_content( null, false, get_the_ID() ), 50 ) !!}</p>
            <div class="text-right"><a class="featured-link mt-4 d-inline-block text-blue" href="{!! get_the_permalink() !!}"><span>Continue reading</span> {!! file_get_contents(home_url() . '/app/uploads/2021/12/arrow-right.svg') !!}</a></div>
          </div>
        </div>
        @endwhile   
      @endif
      <div class="border-bottom mb-3"></div>
    @endif
    @if( is_category() ) 
    <div class="mb-3">{!! \App\Controllers\App::breadcrumb() !!}</div>
    @else
    @if ( $paged < 2 )
    <h2 class="mb-3 h4 font-weight-bold ">Latest stories for you</h2>
    @endif
    @endif
    <div class="row mb-56 mb-2 {{ ( $paged > 1 ) ? 'pt-2 pt-lg-4' : '' }}">
    @while (have_posts()) @php the_post() @endphp
      @include('partials.content-'.get_post_type())
    @endwhile
    </div>
    @php
      global $wp_query;
    $big = 999999999;
    $max = intval( $wp_query->max_num_pages );
    $pagination = \App\Controllers\App::custom_pagination();
    // echo paginate_links( array(
    //         'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
    //         'format' => '?paged=%#%',
    //         'current' => max( 1, get_query_var('paged') ),
    //         'total' => $wp_query->max_num_pages,
    //         'prev_text' => __( '&laquo;' ),
    //         'next_text' => __( '&raquo;' ),
    // ) );
    echo $pagination;
    @endphp
  </div>
@endsection
