<article @php post_class('container mt-5') @endphp>
  <div class="row">
    <div class="col-lg-10 offset-lg-2">{!! \App\Controllers\App::breadcrumb() !!}</div>
    <div class="col-lg-8 offset-lg-2 mt-2 mb-lg-4">
      <h1 class="entry-title h2 mb-3">{!! get_the_title() !!}</h1>
    </div>
    <div class="col-lg-2 text-left text-lg-right mb-3 mb-lg-0 text-caption mt-2">
      <div class="text-gray-medium mb-2">Posted on <time class="updated" datetime="{{ get_post_time('c', true) }}"> {{ get_the_date() }}</time></div>
      @php
        global $post;
        $id = $post->ID;
        $url = get_permalink( $id );
        $title = get_the_title( $id );
        $time_to_read = \App\Controllers\App::getPostReadTime( $id )
      @endphp
      <div class="time_to_read text-gray d-inline-block">{!! $time_to_read !!}</div>
    </div>
  </div>
  <div class="featured-image overflow-hidden text-center">
    {!! get_the_post_thumbnail( ) !!}
  </div>
  <div class="row">
    <div class="col-md-2 d-none d-md-block">
      <div class="soc-share position-sticky text-center sticky">
        <span class="share-title">Share on:</span>
        <a class="d-flex align-items-center justify-content-center facebook-share" href="https://www.facebook.com/sharer.php?u={!! $url !!}" target="_blank" rel="noopener noreferrer">{!! file_get_contents( home_url(  ) . '/app/uploads/2021/11/facebook.svg' ) !!}</a>
        <a class="d-flex align-items-center justify-content-center twitter-share" href="https://twitter.com/share?text={!! $title !!}&amp;url={!! $url !!}" target="_blank" rel="noopener noreferrer">{!! file_get_contents( home_url(  ) . '/app/uploads/2021/11/twitter.svg' ) !!}</a>
        <a class="d-flex align-items-center justify-content-center google-share" href="https://plus.google.com/share?url={!! $url !!}" target="_blank" rel="noopener noreferrer">{!! file_get_contents( home_url(  ) . '/app/uploads/2021/12/google-plus.svg' ) !!}</a>
        <a class="d-flex align-items-center justify-content-center linkedin-share" href="https://www.linkedin.com/shareArticle?mini=true&url={!! $url !!}&title={!! $title !!}" target="_blank" rel="noopener noreferrer">{!! file_get_contents( home_url(  ) . '/app/uploads/2021/11/linkedin2.svg' ) !!}</a>
      </div>
    </div>
    <div class="entry-content col-md-7">
      @php the_content() @endphp
    </div>
    <div class="col-md-3 ">
      @php
          $desktopBanner = \App\Controllers\App::imageWithAlt(get_field('desktop_banner_image', 'option'));
          $bottomBanner = \App\Controllers\App::imageWithAlt(get_field('mobile_banner_image', 'option'));
          if ( !empty( get_field('motorcycle_desktop_banner_image', 'option') ) ) {
            $desktopMotorcycleBanner = \App\Controllers\App::imageWithAlt(get_field('motorcycle_desktop_banner_image', 'option'));
          }
          if ( !empty( get_field('motorcycle_mobile_banner_image', 'option') ) ) {
            $bottomMotorcycleBanner = \App\Controllers\App::imageWithAlt(get_field('motorcycle_mobile_banner_image', 'option'));
          }
          $bannerLinkId = get_field('banner_link', 'option')->ID;
          $bannerLink = get_the_permalink( $bannerLinkId );
          $bannerChoice = get_field('choose_banner');
      @endphp
      @if ( $bannerChoice == 'motorcycle' )
        @if ( isset( $desktopMotorcycleBanner ) )
          <div class="post-baner position-sticky sticky soc-share opacity-0 d-none d-md-block">
            <a href="{{ $bannerLink }}"><img src="{!! $desktopMotorcycleBanner['image'] !!}" alt="{!! $desktopMotorcycleBanner['alt'] !!}"></a>
          </div>
        @endif
        @if ( isset( $bottomMotorcycleBanner ) )
          <div class="post-baner-bottom d-block d-md-none position-fixed">
            <a href="{{ $bannerLink }}"><img src="{!! $bottomMotorcycleBanner['image'] !!}" alt="{!! $bottomMotorcycleBanner['alt'] !!}"></a>
          </div>
        @endif
      @else 
        <div class="post-baner position-sticky sticky soc-share opacity-0 d-none d-md-block">
          <a href="{{ $bannerLink }}"><img src="{!! $desktopBanner['image'] !!}" alt="{!! $desktopBanner['alt'] !!}"></a>
        </div>
        <div class="post-baner-bottom d-block d-md-none position-fixed">
          <a href="{{ $bannerLink }}"><img src="{!! $bottomBanner['image'] !!}" alt="{!! $bottomBanner['alt'] !!}"></a>
        </div>
      @endif
    </div>
  </div>
  <div class="row">
    <div class="col-md-8 offset-md-2 soc-share soc-share-bottom">
      <div class="top-border double-border w-100"></div>
      <div class=" d-flex justify-content-between">
        <div class="d-flex align-items-center">
          <span class="share-title">Share on social media:</span>
        </div>
        <div class="d-flex my-2">
          <a class="d-flex align-items-center justify-content-center facebook-share" href="https://www.facebook.com/sharer.php?u={!! $url !!}" target="_blank" rel="noopener noreferrer">{!! file_get_contents( home_url(  ) . '/app/uploads/2021/11/facebook.svg' ) !!}</a>
          <a class="d-flex align-items-center justify-content-center twitter-share" href="https://twitter.com/share?text={!! $title !!}&amp;url={!! $url !!}" target="_blank" rel="noopener noreferrer">{!! file_get_contents( home_url(  ) . '/app/uploads/2021/11/twitter.svg' ) !!}</a>
          <a class="d-flex align-items-center justify-content-center google-share" href="https://plus.google.com/share?url={!! $url !!}" target="_blank" rel="noopener noreferrer">{!! file_get_contents( home_url(  ) . '/app/uploads/2021/12/google-plus.svg' ) !!}</a>
          <a class="d-flex align-items-center justify-content-center linkedin-share" href="https://www.linkedin.com/shareArticle?mini=true&url={!! $url !!}&title={!! $title !!}" target="_blank" rel="noopener noreferrer">{!! file_get_contents( home_url(  ) . '/app/uploads/2021/11/linkedin2.svg' ) !!}</a>
        </div>
      </div>
      <div class="bottom-border double-border w-100"></div>
    </div>
    <div class="col-md-8 offset-md-2">
      @php
        $related_posts = \App\Controllers\App::RelatedBlogPosts( 6, $id );
        $i = 0;
      @endphp
      <h2 class="mb-3 h4">Related</h2>
      <div class="row">
      @foreach ($related_posts as $related_post) 
          <div class="col-md-6 mb-3 mb-md-32 post-col {{ ( $i > 1 ) ? 'd-none' : '' }}">
            <div class="box-with-shadow p-0 overflow-hidden post-box">
              <a href="{{ $related_post['permalink'][0] }}">
                <div class="box-post-image">
                  @if ( empty ($related_post['image'][0] ) )
                    @if ( in_category( 'videos' ) )
                      <img src="/app/uploads/2022/01/default-videos.png"  alt="{!! $related_post['title'][0] !!}"/>  
                    @elseif ( in_category( 'company-news' ) )
                      <img src="/app/uploads/2022/01/default-company-news.png"  alt="{!! $related_post['title'][0] !!}"/>  
                    @else 
                      <img src="/app/uploads/2021/12/default.jpg"  alt="{!! $related_post['title'][0] !!}"/>  
                    @endif                                    
                  @else
                  <img class="" src="{{ $related_post['image'][0] }}" alt="{{ $related_post['alt'][0] }}">
                  @endif
                </div>
              </a>
              <div class="post-content pt-2 px-3 pb-3">
                <h2 class="h4 post-title overflow-hidden"><a href="{{ $related_post['permalink'][0] }}">{!! $related_post['title'][0] !!}</a></h2>
                <div class="date-read d-flex justify-content-between">
                  <span class="text-gray-medium font-small">Posted on {{ $related_post['date'][0] }}</span>
                  <span class="text-gray-medium font-small">{{ $related_post['time_to_read'][0] }}</span>
                </div>
                <div class="post-categorie">
                  <div class="top-border w-100 my-2"></div>
                  @php
                      $length = count( $related_post['category_name'] );
                  @endphp
                  @foreach ($related_post['category_name'] as $key => $cat_name)
                  <a class="is-underline" href="{{ $related_post['cat_url'][$key] }}">{{ $cat_name }}</a>{{ ( $key != $length - 1 ) ? ', ' : '' }}
                  @endforeach
                </div>
              </div>
            </div>
          </div>
          @php
              $i++;
          @endphp
      @endforeach
      <div class="mt-4 d-flex justify-content-center col-12">
        <button class="button-secondary show-reviews-button">View more</button>
      </div>
      </div>

    </div>
  </div>
  {{-- <footer>
    {!! wp_link_pages(['echo' => 0, 'before' => '<nav class="page-nav"><p>' . __('Pages:', 'sage'), 'after' => '</p></nav>']) !!}
  </footer>
  @php comments_template('/partials/comments.blade.php') @endphp --}}
</article>