@extends('layouts.app')
@php $page_id = get_queried_object(); @endphp
@section('content')
@include('partials.page-header')
@include('blocks.block-hero-help', [$page_id])
<section class="bg-gray-white">
  <div class="container single-tag-page pb-5">
    <div class="row d-flex flex-column-reverse flex-lg-row pt-lg-5">
      @php
        $cats = \App\Controllers\App::returnCPTcats('helpcenter-category');
        $term = get_queried_object();
        $image = get_field('icon_taxonomy', $term->taxonomy . '_' . $term->term_id);
        $img_type = \App\Controllers\App::checkImgExtension($image);
      @endphp
       <div class="col-lg-4">
        <ul class="links-list">
          @foreach($cats['cat_id'] as $key => $cat)
            @if(isset($cats['cat_name'][$key]) && isset($cats['cat_id'][$key]))
              <li class="box-icon-text mb-3 mb-lg-1 d-flex">

                  <a class="h5 bold-desc text-hover-blue" href="{!! $cats['cat_url'][$key] !!}">
                    <div class="d-flex align-items-center">

                      @if(!empty($cats['cat_image'][$key]))
                        @php
                            $img_type_cat = \App\Controllers\App::checkImgExtension($cats['cat_image'][$key]);
                        @endphp
                        @if ( $img_type_cat == 'svg' )
                          <span class="icon-wrap d-inline-block d-lg-none mr-3">
                          {!! file_get_contents( $cats['cat_image'][$key] ) !!}
                          </span>
                        @else
                          <span class="icon-wrap d-inline-block d-lg-none mr-3">
                            <img src="{!! $cats['cat_image'][$key] !!}" />
                          </span>
                        @endif
                      @endif
                      <h3 class="h5 bold-desc">{!! $cats['cat_name'][$key] !!}</h3>
                    </div>

                  <i class="icon-arrow_forward icon d-inline-flex"></i></a>
              </li>
            @endif
          @endforeach
        </ul>
      </div>
      <div class="col-lg-8 mb-4 mb-lg-0 pt-5 pt-lg-0">
        @if(!empty($image))
          @if ( $img_type == 'svg' )
            <span class="icon-wrap d-inline-block mb-3">
              {!! file_get_contents( $image ) !!}
            </span>
          @else
            <span class="icon-wrap d-inline-block mb-3">
              <img src="{!! $image !!}" />
            </span>
          @endif
        @endif
        <h2 class="mb-3 mb-lg-4">{!! $term->name !!}</h2>
        <div class="column-count-two">
        @php
          global $wp_query;
          $args = array_merge( $wp_query->query_vars, ['posts_per_page' => 60 ] );
          query_posts( $args );
        @endphp
        @while (have_posts()) @php the_post() @endphp
        @include('partials.content-'.get_post_type())
        @endwhile
        </div>
      </div>

    </div>
  </div>
</section>
  @include('blocks.block-ctav2', [$page_id])
@endsection
