
<?php
  $title = get_field("title");
  $sections = get_field("steps");
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
?>
<section data-<?php echo e($block['id']); ?> class="progress-bar-tabs three-steps bg-white">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <?php if(!empty($title)): ?>
          <h2 class="mb-4 mb-lg-5"><?php echo $title; ?></h2>
        <?php endif; ?>
      </div>
    </div>
    <div class="steps-hawaii row mx-lg-5">
      <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-lg-4">
          <div class="single-step js-parent-container-open">
            <div class="d-flex flex-column align-items-center js-container-toggle">
              <?php
                if(!empty($section['icon'])){
                $img = \App\Controllers\App::imageWithAlt($section['icon']);
                $img_type = \App\Controllers\App::checkImgExtension($section['icon']['filename']);
                }
              ?>
              <?php if(isset($img)): ?>
                <?php if($img_type == "svg"): ?>
                  <span class="icon-montway">
                    <?php
                      echo file_get_contents($img['image'])
                    ?>
                  </span>
                <?php else: ?>
                  <img src="<?php echo $img['image']; ?>" alt="<?php echo $img['alt']; ?>"
                    srcset="<?php echo $img['small'] . $img['medium'] . $img['large']; ?>">
                <?php endif; ?>
              <?php endif; ?>
              <div class="d-flex flex-column align-items-center">
                <h2 class="step-number text-blue h4 bold"><?php echo $section['step']; ?></h2>
                <p class="h6 bold"><?php echo $section['title']; ?></p>
                <div class="text-wrap body-link"><?php echo $section['body_copy']; ?></div>
                <div class="item-hidden body-link"><?php echo $section['body_copy_hidden']; ?></div>
                <?php if($section['body_copy_hidden']): ?>
                  <button data-text-open="Read less" data-text-close="Read more"
                    class="is-underline p-0 js-button-trigger js-see-more-button mt-3 mb-3 align-self-start align-self-lg-center">
                    <span class="js-button-text">Read more</span></button>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

  </div>
</section>
