
<?php
$title = get_field("title");
$right_title = get_field('right_title');
$graph = get_field("graph");
if(!empty($graph)){
	$graph_img = \App\Controllers\App::imageWithAlt($graph);
	$graph_type = \App\Controllers\App::checkImgExtension($graph['filename']);
}
$list = get_field("list");
$padding = get_field("block_padding");
$inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
echo $inline_style;
?>
<section class="bg-gray list-graph">
  <div class="container">
    <div class="row">
      <div class="col-12 col-lg-6 order-2 order-lg-1" data-<?php echo e($block['id']); ?>>

        <h2 class="mb-4 mb-lg-5"><?php echo $title; ?></h2>
        <div class="list-wrap">
        <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div class="box-icon-text has-border js-container-toggle">
            <div class="d-flex align-items-center justify-content-between">
              <div class="d-flex align-items-center">
                <?php if(!empty($item['icon'])): ?>
                  <?php
                    $icon = \App\Controllers\App::imageWithAlt($item['icon']);
                    $icon_type = \App\Controllers\App::checkImgExtension($item['icon']['filename']);
                  ?>
                  <?php if(!empty($icon)): ?>
                    <?php if($icon_type == "svg"): ?>
                      <span class="box-icon p-absolute">
                        <?php
                          echo file_get_contents($icon['image'])
                        ?>
                      </span>
                    <?php else: ?>
                      <img src="<?php echo $icon['image']; ?>" alt="<?php echo $icon['alt']; ?>"
                        srcset="<?php echo $icon['small'] . $icon['medium'] . $icon['large']; ?>" alt="">
                    <?php endif; ?>
                  <?php endif; ?>
                <?php endif; ?>
                <h3 class="h5 bold-desc mb-0 mb-lg-2"><?php echo $item['headline']; ?></h3>
              </div>
              <i class="icon icon-keyboard_arrow_right"></i>

            </div>
            <div class="text-wrap text-gray mt-0"><?php echo $item['body_copy']; ?></div>

          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
      </div>
      <div class="col-lg-6 order-1 order-lg-2">
        <div class="right-wrap">

          <h2 class="h3 graph-title  mb-4"><?php echo $right_title; ?></h2>
          <div class="graph-wrap">
            <?php if(!empty($graph_img)): ?>
            <?php if($graph_type == "svg"): ?>
            <?php
                echo file_get_contents($graph_img['image'])
                ?>
            <?php else: ?>
            <img src="<?php echo $graph_img['image']; ?>" alt="<?php echo $graph_img['alt']; ?>"
            srcset="<?php echo $graph_img['small'] . $graph_img['medium'] . $graph_img['large']; ?>" alt="">
            <?php endif; ?>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
