
<?php
  $title = get_field('title');
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
?>
<section data-<?php echo e($block['id']); ?> class="onboarding">
  <div class="container">
    <div class="row">
      <div class="col-12 col-lg-8 mx-auto text-left text-lg-center">
        <h2 class="mb-4 mb-lg-5"><?php echo $title; ?></h2>
      </div>
      <?php
        $rowCount = 0;
      ?>
      <div class="col-12 ">
        <div class="onboarding-steps ">
          <?php if(have_rows('icon_block')): ?>
            <?php while(have_rows('icon_block')): ?>
              <?php
                the_row();
                $text = get_sub_field('text');
                $image = get_sub_field('icon');
                $img = \App\Controllers\App::imageWithAlt($image);
                $img_type = \App\Controllers\App::checkImgExtension($image['filename'])
              ?>

                <div class="step ">


                    <img src="<?php echo $img['image']; ?>" alt="<?php echo $img['alt']; ?>"
                      srcset="<?php echo $img['small'] . $img['medium'] . $img['large']; ?>">


                  <span class="h5"><?php echo $text; ?></span>


              </div>
            <?php endwhile; ?>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</section>
