
<?php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $title = get_field('title');
  $body_copy = get_field('body_copy');
  $img = get_field('image');
  $image = \App\Controllers\App::imageWithAlt($img);
?>
<section data-<?php echo e($block['id']); ?> class="text-3-col">
  <div class="container">
    <div class="row">
      <div class="col-lg-6 order-2 order-lg-1">
        <img src="<?php echo $image['image']; ?>" alt="<?php echo $image['alt']; ?>"
          srcset="<?php echo $image['small'] . $image['medium'] . $image['large']; ?>">
      </div>
      <div class="col-lg-6 order-1 order-lg-2 mb-3 mb-lg-0">
        <h2 class="mb-4 mb-lg-5"><?php echo $title; ?></h2>
        <div class="h6 body-link"><?php echo $body_copy; ?></div>
      </div>
      <div class="col-12 mt-5 pt-lg-4 order-2">
        <div class="features-grid">
          <?php if(have_rows('text_columns')): ?>
            <?php while(have_rows('text_columns')): ?>
              <?php
                the_row();
                $first_title = get_sub_field('first_title');
                $second_title = get_sub_field('second_title');
              ?>
              <div class="feature text-center py-4 px-3 py-lg-3 px-xl-4">
                <p class="mb-3 h3 mb-5 mb-lg-4"><?php echo $first_title; ?></p>
                <p class="h3  "><?php echo $second_title; ?></p>
              </div>
            <?php endwhile; ?>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</section>
