
<?php
$title = get_field('title');
$subtitle = get_field("subtitle");
$table = get_field('table_group');
$table_select = get_field('table_layout');
$copy_transit = get_field('copy_transit_time');
$padding = get_field("block_padding");
$name = [];
$fields = get_field_objects();
foreach($fields as $field) {
  $id = $field['parent'];
}
$tabs = acf_get_fields($id);
for($i = 0; $i < sizeof($tabs); $i++) {
  $type = $tabs[$i]['type'];
  if($type == 'tab') {
    $name[] = $tabs[$i]['label'];
  }
}

$inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
?>
<section data-<?php echo e($block['id']); ?>>
  <div class="container">
    <div class="row <?php echo e(( $table_select == 'four' ) ? 'mb-5' : ''); ?>">
      <div class="col-12">

      <h2 class="<?php echo e(( $table_select == 'four' ) ? 'mb-5' : 'mb-32'); ?>"><?php echo $title; ?></h2>
      <p class="text-gray"><?php echo $subtitle; ?></p>
    </div>

    </div>
<?php if($table_select == 'four'): ?>
  <!-- 4 column layout -->

  <!-- ova tabela ide za prvi tab -->

  <div class="row">
    <div class="col-12 d-flex justify-content-center table-button-wrap">
      <?php $__currentLoopData = $name; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $n): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if( $key == 0 ): ?>
        <button id="table-tab-<?php echo e($key); ?>" class="table-button active"><?php echo $n; ?></button>
        <?php else: ?>
        <button id="table-tab-<?php echo e($key); ?>" class="table-button"><?php echo $n; ?></button>
        <?php endif; ?>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
    <div class="col-xl-8 col-lg-9 mx-auto p-0 px-sm-3 pb-3 tabs-table">
      <div class="table-wrap" data-tab="table-tab-0">
        <?php if(have_rows('table_group')): ?>
          <?php while(have_rows('table_group')): ?>
            <?php the_row(); ?>
            <table class="text-center alternating-colors table">
              <thead>
                <tr>
                  <?php if(have_rows('table_head')): ?>
                    <?php while(have_rows('table_head')): ?>
                      <?php the_row();
                      $origin_head = get_sub_field('origin');
                      $destination_head = get_sub_field('destination');
                      $costs_head = get_sub_field('average_door-to-door_costs');
                      $centers_head = get_sub_field('average_cost_between_distribution_centeres');
                      ?>
                      <th class="text-center"><?php echo $origin_head; ?></th>
                      <th class="text-center"><?php echo $destination_head; ?></th>
                      <th class="text-center"><?php echo $costs_head; ?></th>
                      <th class="text-center"><?php echo $centers_head; ?></th>
                    <?php endwhile; ?>
                  <?php endif; ?>
                </tr>
              </thead>
              <tbody>
                  <?php if(have_rows('table')): ?>
                    <?php while(have_rows('table')): ?>
                      <tr class="">
                        <?php the_row();
                        $origin = get_sub_field('origin');
                        $destination = get_sub_field('destination');
                        $costs = get_sub_field('costs');
                        $centers = get_sub_field('centers');
                        ?>
                        <td class="w-155"><?php echo $origin; ?></td>
                        <td class="w-155"><?php echo $destination; ?></td>
                        <td><?php echo $costs; ?></td>
                        <td><?php echo $centers; ?></td>
                      </tr>
                      <?php endwhile; ?>
                  <?php endif; ?>
              </tbody>
            </table>
          <?php endwhile; ?>
        <?php endif; ?>
      </div>
      <div class="px-4 px-lg-0 ">
        <div class="table-wrap d-none width-600 mx-auto"  data-tab="table-tab-1">
        <?php if(have_rows('table_group_delivery')): ?>
          <?php while(have_rows('table_group_delivery')): ?>
            <?php the_row(); ?>
            <table class="text-center alternating-colors  table">
              <thead>
                <tr>
                  <?php if(have_rows('table_head_delivery')): ?>
                    <?php while(have_rows('table_head_delivery')): ?>
                      <?php the_row();
                      $distance_delivery = get_sub_field('total_distance_head');
                      $costs_delivery = get_sub_field('average_door-to-door_costs_head');
                      $centers_delivery = get_sub_field('average_cost_between_distribution_centeres_head');
                      ?>
                      <th class="text-center"><?php echo $distance_delivery; ?></th>
                      <th class="text-center"><?php echo $costs_delivery; ?></th>
                      <th class="text-center"><?php echo $centers_delivery; ?></th>
                    <?php endwhile; ?>
                  <?php endif; ?>
                </tr>
              </thead>
              <tbody>
                  <?php if(have_rows('table')): ?>
                    <?php while(have_rows('table')): ?>
                      <tr class="">
                        <?php the_row();
                        $distance_del = get_sub_field('total_distance');
                        $cost_del = get_sub_field('average_door-to-door_costs');
                        $centers_del = get_sub_field('average_cost_between_distribution_centeres');
                        ?>
                        <td class="one-third"><?php echo $distance_del; ?></td>
                        <td class="one-third"><?php echo $cost_del; ?></td>
                        <td class="one-third"><?php echo $centers_del; ?></td>
                      </tr>
                      <?php endwhile; ?>
                  <?php endif; ?>
              </tbody>
            </table>
          <?php endwhile; ?>
        <?php endif; ?>
        </div>
      </div>
      <div class="px-4 px-lg-0 " >
      <div class="table-wrap mx-auto d-none" data-tab="table-tab-2">
        <?php if(have_rows('table_group_transit')): ?>
        <?php while(have_rows('table_group_transit')): ?>
          <?php the_row(); ?>
          <table class="text-center alternating-colors mb-0 table">
            <thead>
              <tr>
                <?php if(have_rows('table_head_transit')): ?>
                  <?php while(have_rows('table_head_transit')): ?>
                    <?php the_row();
                    $mileage_head = get_sub_field('mileage_head');
                    $average_transit_time_head = get_sub_field('average_transit_time_head');
                    ?>
                    <th class="text-center"><?php echo $mileage_head; ?></th>
                    <th class="text-center"><?php echo $average_transit_time_head; ?></th>
                  <?php endwhile; ?>
                <?php endif; ?>
              </tr>
            </thead>
            <tbody>
                <?php if(have_rows('table')): ?>
                  <?php while(have_rows('table')): ?>
                    <tr class="">
                      <?php the_row();
                      $mileage = get_sub_field('mileage');
                      $average_transit_time = get_sub_field('average_transit_time');
                      ?>
                      <td ><?php echo $mileage; ?></td>
                      <td ><?php echo $average_transit_time; ?></td>
                    </tr>
                    <?php endwhile; ?>
                <?php endif; ?>
            </tbody>
          </table>
        <?php endwhile; ?>
        <p><?php echo e($copy_transit); ?></p>
      <?php endif; ?>
      </div>
    </div>
    </div>
  </div>
  <!-- ovde je kraj svega za prvu tabelu -->
  <!-- kad se zavrsi prvi tab u koji ce ici ova prva tabela, onda cu dodati i ostale dve, da ne bude previse koda sada dok ne sredis -->
<?php else: ?>
  <!-- 3 column layout -->
  <div class="col-xl-8 col-lg-9 mx-auto px-0">
    <?php if(have_rows('table_group_second')): ?>
        <?php while(have_rows('table_group_second')): ?>
          <?php the_row(); ?>
          <table class="alternating-colors-odd">
            <thead >
            <tr>
              <?php if(have_rows('table_head')): ?>
                <?php while(have_rows('table_head')): ?>
                  <?php the_row();
                    if(get_sub_field('head_image')){
                      $img = get_sub_field('head_image');
                      $image = \App\Controllers\App::imageWithAlt(get_sub_field('head_image'));
                      $image_type = \App\Controllers\App::checkImgExtension($img['filename']);
                    }
                  ?>
                  <th class="text-center px-0 th-image">
                    <?php if(isset($image)): ?>
                      <?php if($image_type == "svg"): ?>
                        <?php
                          echo file_get_contents($image['image'])
                        ?>
                      <?php else: ?>
                        <img src="<?php echo $image['image']; ?>" alt="<?php echo $image['alt']; ?>" >
                      <?php endif; ?>
                    <?php endif; ?>
                    <?php if( !empty( get_sub_field( 'head_copy_text' ) ) ): ?>
                        <p class="head-copy"><?php echo e(get_sub_field( 'head_copy_text' )); ?></p>
                    <?php endif; ?>
                  </th>
                <?php endwhile; ?>
              <?php endif; ?>
            </tr>
            </thead>
            <tbody>
            <?php if(have_rows('table')): ?>
              <?php while(have_rows('table')): ?>
                <tr>
                  <?php the_row();
                  $first_column = get_sub_field('first_column');
                  $second_column = get_sub_field('second_column');
                  $third_column = get_sub_field('third_column');
                  ?>
                  <td class="text-center" style="width: 40%">
                    <?php echo $first_column; ?>

                  </td>
                  <td class="text-center check-mark" style="width: 30%">
                    <?php if($second_column): ?>
                      <img src="/app/uploads/2021/12/checkmark-green.png" alt="check">
                    <?php else: ?>
                      <img src="/app/uploads/2021/12/x-red.png" alt="uncheck">
                    <?php endif; ?>
                  </td>
                  <td class="text-center check-mark" style="width: 30%">
                    <?php if($third_column): ?>
                      <img src="/app/uploads/2021/12/checkmark-green.png" alt="check">
                    <?php else: ?>
                      <img src="/app/uploads/2021/12/x-red.png" alt="uncheck">
                    <?php endif; ?>
                  </td>
                </tr>
              <?php endwhile; ?>
            <?php endif; ?>
            </tbody>
          </table>
        <?php endwhile; ?>
    <?php endif; ?>
  </div>
<?php endif; ?>
  </div>
</section>
