
<?php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $informations = get_field('informations');
  $business_hours = get_field('business_hours');
?>
<section data-<?php echo e($block['id']); ?> class="contact-section">
  <div class="container">
    <div class="row">
      <div class="col-xl-6 col-md-6 contact-form order-2 order-md-1">
        <?php gravity_form( get_field('contact_form_shordcode'), false, false, false, null, true ); ?>
      </div>
      <div class="col-xl-4 col-md-6 offset-xl-2 order-1 order-md-2">
        <div class="mb-5">
          <h2 class="h4 mb-3"><?php echo $informations['title']; ?></h2>
          <div class="mb-3"><?php echo $informations['location']; ?></div>
          <div class="phones">

            <?php $__currentLoopData = $informations['information']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $information): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="d-flex justify-content-between has-gray-border py-2">
              <div class="d-flex align-items-center">
                <i class="icon"></i>
                <p class="text-gray"><?php echo $information['info']; ?></p>
              </div>
              <a href="" class="is-underline"><?php echo $information['phone']; ?></a>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          </div>
        </div>
        <div>

          <h2 class="h4 mb-2 mb-lg-3"><?php echo $business_hours['title']; ?></h2>
          <?php $__currentLoopData = $business_hours['working_days']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hours): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
              if(!empty($hours['icon'])){
              $image = \App\Controllers\App::imageWithAlt($hours['icon']);
              }
            ?>
            <div class="d-flex justify-content-between has-gray-border py-2">
              <div class="text-gray"><?php echo $hours['days']; ?></div>
              <?php if(!empty($image)): ?>
                <img class="chat-img" src="<?php echo $image['image']; ?>" alt="">
              <?php endif; ?>
              <p><?php echo $hours['time']; ?></p>
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      </div>
    </div>
  </div>
</section>
