<article <?php post_class('container mt-5') ?>>
  <div class="row">
    <div class="col-lg-10 offset-lg-2"><?php echo \App\Controllers\App::breadcrumb(); ?></div>
    <div class="col-lg-8 offset-lg-2 mt-2 mb-lg-4">
      <h1 class="entry-title h2 mb-3"><?php echo get_the_title(); ?></h1>
    </div>
    <div class="col-lg-2 text-left text-lg-right mb-3 mb-lg-0 text-caption mt-2">
      <div class="text-gray-medium mb-2">Posted on <time class="updated" datetime="<?php echo e(get_post_time('c', true)); ?>"> <?php echo e(get_the_date()); ?></time></div>
      <?php
        global $post;
        $id = $post->ID;
        $url = get_permalink( $id );
        $title = get_the_title( $id );
        $time_to_read = \App\Controllers\App::getPostReadTime( $id )
      ?>
      <div class="time_to_read text-gray d-inline-block"><?php echo $time_to_read; ?></div>
    </div>
  </div>
  <div class="featured-image overflow-hidden text-center">
    <?php echo get_the_post_thumbnail( ); ?>

  </div>
  <div class="row">
    <div class="col-md-2 d-none d-md-block">
      <div class="soc-share position-sticky text-center sticky">
        <span class="share-title">Share on:</span>
        <a class="d-flex align-items-center justify-content-center facebook-share" href="https://www.facebook.com/sharer.php?u=<?php echo $url; ?>" target="_blank" rel="noopener noreferrer"><?php echo file_get_contents( home_url(  ) . '/app/uploads/2021/11/facebook.svg' ); ?></a>
        <a class="d-flex align-items-center justify-content-center twitter-share" href="https://twitter.com/share?text=<?php echo $title; ?>&amp;url=<?php echo $url; ?>" target="_blank" rel="noopener noreferrer"><?php echo file_get_contents( home_url(  ) . '/app/uploads/2021/11/twitter.svg' ); ?></a>
        <a class="d-flex align-items-center justify-content-center google-share" href="https://plus.google.com/share?url=<?php echo $url; ?>" target="_blank" rel="noopener noreferrer"><?php echo file_get_contents( home_url(  ) . '/app/uploads/2021/12/google-plus.svg' ); ?></a>
        <a class="d-flex align-items-center justify-content-center linkedin-share" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo $url; ?>&title=<?php echo $title; ?>" target="_blank" rel="noopener noreferrer"><?php echo file_get_contents( home_url(  ) . '/app/uploads/2021/11/linkedin2.svg' ); ?></a>
      </div>
    </div>
    <div class="entry-content col-md-7">
      <?php the_content() ?>
    </div>
    <div class="col-md-3 ">
      <?php
          $desktopBanner = \App\Controllers\App::imageWithAlt(get_field('desktop_banner_image', 'option'));
          $bottomBanner = \App\Controllers\App::imageWithAlt(get_field('mobile_banner_image', 'option'));
          if ( !empty( get_field('motorcycle_desktop_banner_image', 'option') ) ) {
            $desktopMotorcycleBanner = \App\Controllers\App::imageWithAlt(get_field('motorcycle_desktop_banner_image', 'option'));
          }
          if ( !empty( get_field('motorcycle_mobile_banner_image', 'option') ) ) {
            $bottomMotorcycleBanner = \App\Controllers\App::imageWithAlt(get_field('motorcycle_mobile_banner_image', 'option'));
          }
          $bannerLinkId = get_field('banner_link', 'option')->ID;
          $bannerLink = get_the_permalink( $bannerLinkId );
          $bannerChoice = get_field('choose_banner');
      ?>
      <?php if( $bannerChoice == 'motorcycle' ): ?>
        <?php if( isset( $desktopMotorcycleBanner ) ): ?>
          <div class="post-baner position-sticky sticky soc-share opacity-0 d-none d-md-block">
            <a href="<?php echo e($bannerLink); ?>"><img src="<?php echo $desktopMotorcycleBanner['image']; ?>" alt="<?php echo $desktopMotorcycleBanner['alt']; ?>"></a>
          </div>
        <?php endif; ?>
        <?php if( isset( $bottomMotorcycleBanner ) ): ?>
          <div class="post-baner-bottom d-block d-md-none position-fixed">
            <a href="<?php echo e($bannerLink); ?>"><img src="<?php echo $bottomMotorcycleBanner['image']; ?>" alt="<?php echo $bottomMotorcycleBanner['alt']; ?>"></a>
          </div>
        <?php endif; ?>
      <?php else: ?> 
        <div class="post-baner position-sticky sticky soc-share opacity-0 d-none d-md-block">
          <a href="<?php echo e($bannerLink); ?>"><img src="<?php echo $desktopBanner['image']; ?>" alt="<?php echo $desktopBanner['alt']; ?>"></a>
        </div>
        <div class="post-baner-bottom d-block d-md-none position-fixed">
          <a href="<?php echo e($bannerLink); ?>"><img src="<?php echo $bottomBanner['image']; ?>" alt="<?php echo $bottomBanner['alt']; ?>"></a>
        </div>
      <?php endif; ?>
    </div>
  </div>
  <div class="row">
    <div class="col-md-8 offset-md-2 soc-share soc-share-bottom">
      <div class="top-border double-border w-100"></div>
      <div class=" d-flex justify-content-between">
        <div class="d-flex align-items-center">
          <span class="share-title">Share on social media:</span>
        </div>
        <div class="d-flex my-2">
          <a class="d-flex align-items-center justify-content-center facebook-share" href="https://www.facebook.com/sharer.php?u=<?php echo $url; ?>" target="_blank" rel="noopener noreferrer"><?php echo file_get_contents( home_url(  ) . '/app/uploads/2021/11/facebook.svg' ); ?></a>
          <a class="d-flex align-items-center justify-content-center twitter-share" href="https://twitter.com/share?text=<?php echo $title; ?>&amp;url=<?php echo $url; ?>" target="_blank" rel="noopener noreferrer"><?php echo file_get_contents( home_url(  ) . '/app/uploads/2021/11/twitter.svg' ); ?></a>
          <a class="d-flex align-items-center justify-content-center google-share" href="https://plus.google.com/share?url=<?php echo $url; ?>" target="_blank" rel="noopener noreferrer"><?php echo file_get_contents( home_url(  ) . '/app/uploads/2021/12/google-plus.svg' ); ?></a>
          <a class="d-flex align-items-center justify-content-center linkedin-share" href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo $url; ?>&title=<?php echo $title; ?>" target="_blank" rel="noopener noreferrer"><?php echo file_get_contents( home_url(  ) . '/app/uploads/2021/11/linkedin2.svg' ); ?></a>
        </div>
      </div>
      <div class="bottom-border double-border w-100"></div>
    </div>
    <div class="col-md-8 offset-md-2">
      <?php
        $related_posts = \App\Controllers\App::RelatedBlogPosts( 6, $id );
        $i = 0;
      ?>
      <h2 class="mb-3 h4">Related</h2>
      <div class="row">
      <?php $__currentLoopData = $related_posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related_post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
          <div class="col-md-6 mb-3 mb-md-32 post-col <?php echo e(( $i > 1 ) ? 'd-none' : ''); ?>">
            <div class="box-with-shadow p-0 overflow-hidden post-box">
              <a href="<?php echo e($related_post['permalink'][0]); ?>">
                <div class="box-post-image">
                  <?php if( empty ($related_post['image'][0] ) ): ?>
                    <?php if( in_category( 'videos' ) ): ?>
                      <img src="/app/uploads/2022/01/default-videos.png"  alt="<?php echo $related_post['title'][0]; ?>"/>  
                    <?php elseif( in_category( 'company-news' ) ): ?>
                      <img src="/app/uploads/2022/01/default-company-news.png"  alt="<?php echo $related_post['title'][0]; ?>"/>  
                    <?php else: ?> 
                      <img src="/app/uploads/2021/12/default.jpg"  alt="<?php echo $related_post['title'][0]; ?>"/>  
                    <?php endif; ?>                                    
                  <?php else: ?>
                  <img class="" src="<?php echo e($related_post['image'][0]); ?>" alt="<?php echo e($related_post['alt'][0]); ?>">
                  <?php endif; ?>
                </div>
              </a>
              <div class="post-content pt-2 px-3 pb-3">
                <h2 class="h4 post-title overflow-hidden"><a href="<?php echo e($related_post['permalink'][0]); ?>"><?php echo $related_post['title'][0]; ?></a></h2>
                <div class="date-read d-flex justify-content-between">
                  <span class="text-gray-medium font-small">Posted on <?php echo e($related_post['date'][0]); ?></span>
                  <span class="text-gray-medium font-small"><?php echo e($related_post['time_to_read'][0]); ?></span>
                </div>
                <div class="post-categorie">
                  <div class="top-border w-100 my-2"></div>
                  <?php
                      $length = count( $related_post['category_name'] );
                  ?>
                  <?php $__currentLoopData = $related_post['category_name']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $cat_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <a class="is-underline" href="<?php echo e($related_post['cat_url'][$key]); ?>"><?php echo e($cat_name); ?></a><?php echo e(( $key != $length - 1 ) ? ', ' : ''); ?>

                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
              </div>
            </div>
          </div>
          <?php
              $i++;
          ?>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      <div class="mt-4 d-flex justify-content-center col-12">
        <button class="button-secondary show-reviews-button">View more</button>
      </div>
      </div>

    </div>
  </div>
  
</article>