
<?php
  $title = get_field("title");
  $subheadline = get_field("subheadline");
  $small_headline = get_field("small_headline");
  $blocks = get_field("blocks");
  $rating = get_field("rating");
  $rating_num = number_format((float)$rating, 1, '.', '');
  $title_under_rating = get_field("title_under_rating");
  $padding = get_field('block_padding');
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
?>
<section data-<?php echo e($block['id']); ?> class="review-single-large">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h1 class="mb-4"><?php echo $title; ?></h1>
        <h2 class="h5 bold-desc mb-4"><?php echo $subheadline; ?></h2>
      </div>
      <div class="col-lg-11 col-xl-9 mx-auto">
        <div class="review-box-shadow d-flex row mx-2 mx-md-0">
          <div class="col-12">
              <h3 class="d-block mb-5 text-gray bold-desc h5"><?php echo $small_headline; ?></h3>

            </div>
          <div class="col-lg-5 order-2 order-lg-1">
            <div class="review-grid">
              <?php $__currentLoopData = $blocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $block): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="review-block d-flex flex-column align-items-center d-lg-block">
                  <?php
                    if(!empty($block['icon'])){
                    $image = \App\Controllers\App::imageWithAlt($block['icon']);
                    $image_type = \App\Controllers\App::checkImgExtension($block['icon']['filename']);
                    }
                  ?>
                  <?php if(!empty($image)): ?>
                    <?php if($image_type == "svg"): ?>
                      <span class="icon-montway mb-2">
                        <?php
                          echo file_get_contents($image['image'])
                        ?>
                      </span>
                    <?php else: ?>
                      <img class="icon-montway mb-2" src="<?php echo $image['image']; ?>" alt="<?php echo $image['alt']; ?>"
                        srcset="<?php echo $image['small'] . $image['medium'] . $image['large']; ?>">
                    <?php endif; ?>
                  <?php endif; ?>
                  <p class="h5 bold-desc"><?php echo $block['shortcodes']; ?></p>
                  <p class="text-gray-medium text-center text-md-left text-caption"><?php echo $block['body_copy']; ?></p>
                </div>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
          </div>

          <div class="col-lg-7 mb-4 mb-lg-0 order-1 order-lg-2 large-review d-flex align-items-start justify-content-center justify-content-lg-end">
            <div class="d-flex flex-column align-items-center">
              <span class="rating-number-large bold"><?php echo $rating_num; ?></span>
              <?php
                $stars = \App\Controllers\App::startRating($rating);
              ?>
              <div class="d-flex stars-wrap mb-2">

                <?php for($i=0; $i<$stars['full']; $i++): ?>
                  <img src=<?php echo get_template_directory_uri() . '/assets/images/review-page-star.png'; ?> />
                <?php endfor; ?>
                <?php if(isset($stars['half'])): ?>
                  <img src=<?php echo get_template_directory_uri() . '/assets/images/review-page-' .$stars['half'].'.png'; ?> />
                <?php endif; ?>
              </div>
              <span class="text-caption text-center text-gray-medium"><?php echo $title_under_rating; ?></span>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
