
<?php
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $title = get_field('title');
  $title_mob = get_field('title_mobile');
  $subtitle = get_field('undertitle');
  $subtitle_mob = get_field('undertitle_mobile');
  $body_copy = get_field('body_copy');
?>
<section data-<?php echo e($block['id']); ?> class="hawaii-map-section bg-white-blue">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-4 mb-4 mb-lg-0">
        <h2 class="h3 mb-4 d-none d-lg-block"><?php echo $title; ?></h2>
        <p class="p bold-desc d-none d-lg-block"><?php echo $subtitle; ?></p>

        <h2 class="h3 mb-3 d-block d-lg-none title-mob"><?php echo $title_mob; ?></h2>
        <p class="h5 bold-desc d-block d-lg-none"><?php echo $subtitle_mob; ?></p>
        <div class="d-none d-lg-block body-link">
          <?php echo $body_copy; ?>

        </div>
      </div>
      <div class="col-lg-8">
        <div class="hawaii-map">
          <img src="/app/themes/montway/resources/assets/images/hawaii_islands.png" alt="hawaii map">
          <?php if(have_rows('locations')): ?>
          <?php
          $rowCount = 0;
          ?>
            <?php while(have_rows('locations')): ?>
              <?php
                the_row();
                $rowCount ++;
              ?>
              <div class="port-box flex-column align-items-start box-icon-text  js-container-toggle port-<?php echo $rowCount; ?>">
                <div class="d-flex align-items-center justify-content-between w-100">
                  <p class="d-flex align-items-lg-center flex-column flex-lg-row location-wrap">
                    <span class="bold island mr-1">
                      <?php echo get_sub_field('island'); ?>

                    </span>
                    <span class="text-caption">
                      <?php echo get_sub_field('location'); ?>

                    </span>
                  </p>
                  <i class="icon ml-2 icon-keyboard_arrow_right text-gray-medium d-block"></i>
                </div>
              <div class="port-pin pin<?php echo $rowCount; ?>"></div>

                <div class="text-wrap d-lg-none">
                  <div>
                    <span class="bold d-block body-link"> <?php echo get_sub_field('island'); ?></span>

                  </div>
                  <div class="mb-3">
                    <?php echo get_sub_field('detailed_location'); ?>

                  </div>
                  <span class="d-block bold">Drop-off/Pick-up Hours</span>
                  <div class="hours body-link">
                    <?php echo get_sub_field('hours'); ?>

                  </div>

                </div>
              </div>
              <div class="port-detailed  port-detailed-<?php echo $rowCount; ?>">
                <div class="d-flex justify-content-between align-items-center mb-3">

                  <span class="bold d-block body-link"> <?php echo get_sub_field('island'); ?></span>
                  <button class="button-close p-0">
                    <i class="material-icons close-me text-gray"><svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M18.3 5.70996C18.1131 5.5227 17.8595 5.41747 17.595 5.41747C17.3305 5.41747 17.0768 5.5227 16.89 5.70996L12 10.59L7.10997 5.69996C6.92314 5.5127 6.66949 5.40747 6.40497 5.40747C6.14045 5.40747 5.8868 5.5127 5.69997 5.69996C5.30997 6.08996 5.30997 6.71996 5.69997 7.10996L10.59 12L5.69997 16.89C5.30997 17.28 5.30997 17.91 5.69997 18.3C6.08997 18.69 6.71997 18.69 7.10997 18.3L12 13.41L16.89 18.3C17.28 18.69 17.91 18.69 18.3 18.3C18.69 17.91 18.69 17.28 18.3 16.89L13.41 12L18.3 7.10996C18.68 6.72996 18.68 6.08996 18.3 5.70996Z" fill="#9ba3af"/>
                      </svg>

                      </i>
                  </button>
                </div>
                <div class="mb-3 body-link">
                  <?php echo get_sub_field('detailed_location'); ?>

                </div>
                <span class="d-block bold">Drop-off/Pick-up Hours</span>
                <div class="hours mb-3 body-link">
                  <?php echo get_sub_field('hours'); ?>

                </div>
                <a href="<?php echo get_sub_field('directions'); ?>" class="is-underline text-caption"  target="_blank" rel="noopener"><?php echo "Get directions"; ?></a>
              </div>
            <?php endwhile; ?>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</section>
