
<?php
  $title = get_field('title');
  $subtitle = get_field('subtitle');
  $body_copy = get_field('list');
  $img = get_field('image');
  if(!empty($img)){
  $image = \App\Controllers\App::imageWithAlt($img);
  $image_type = \App\Controllers\App::checkImgExtension($img['filename']);
  }
  $padding = get_field("block_padding");
  $inline_style = \App\Controllers\App::inlineStyle($padding, $block['id']);
  echo $inline_style;
  $button = get_field('button');
  $button_type = get_field('button_type');
  $form_cta = get_field('contact_form_shordcode');
  $form = GFAPI::get_form( $form_cta );
?>
  <?php if($form['title'] == 'Let\'s get Started'): ?>
  <div class="modal form-modal home-delivery-form" id="formModal-<?php echo e($form_cta); ?>" tabindex="-1" aria-labelledby="formModal-<?php echo e($form_cta); ?>" aria-hidden="true">
    <span class="close-modal position-fixed d-flex justify-content-center align-items-center d-sm-inline-block" data-dismiss="modal"><svg viewBox="0 0 10 10" xmlns="http://www.w3.org/2000/svg"><path d="M.3 9.7c.2.2.4.3.7.3.3 0 .5-.1.7-.3L5 6.4l3.3 3.3c.2.2.5.3.7.3.2 0 .5-.1.7-.3.4-.4.4-1 0-1.4L6.4 5l3.3-3.3c.4-.4.4-1 0-1.4-.4-.4-1-.4-1.4 0L5 3.6 1.7.3C1.3-.1.7-.1.3.3c-.4.4-.4 1 0 1.4L3.6 5 .3 8.3c-.4.4-.4 1 0 1.4z" fill="#000" fill-rule="nonzero"></path></svg><span class="d-inline-block d-sm-none text-white close-text">Close</span></span>
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-body contact-form p-0">
          <div class="container-fluid">
            <div class="row">
              <div class="left-content cus-col-6">
                <div class="modal-text">
                  <h2 class="text-white">Find out how our Vehicle Home Delivery solution and Montway Business Portal can:</h2>
                  <ul class="bulleted-list mt-4">
                    <li class="text-white"><h3 class="text-white">expand your sales audience</h3></li>
                    <li class="text-white"><h3 class="text-white">engage motivated consumers</h3></li>
                    <li class="text-white"><h3 class="text-white">drive increased sales</h3></li>
                    <li class="text-white"><h3 class="text-white">simple and easy dealer website integration</h3></li>
                  </ul>
                </div>
                <div class="modal-logos d-flex justify-content-between align-items-center">
                  <img src="/app/uploads/2022/02/bbb-logo-transparent.png" alt="bbb-logo">
                  <img src="/app/uploads/2022/02/naaa_white_logo.png" alt="naaa" style="height: 60px;">
                  <img src="/app/uploads/2022/02/iara_white_logo.png" alt="iara">
                </div>
              </div>
              <div class="right-content cus-col-6">
                <?php gravity_form( $form_cta , true, true, false, null, true ); ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <?php else: ?>
  <div class="modal form-modal" id="formModal-<?php echo e($form_cta); ?>" tabindex="-1" aria-labelledby="formModal-<?php echo e($form_cta); ?>" aria-hidden="true">
    <span class="close-modal position-fixed d-flex justify-content-center align-items-center d-sm-inline-block" data-dismiss="modal"><svg viewBox="0 0 10 10" xmlns="http://www.w3.org/2000/svg"><path d="M.3 9.7c.2.2.4.3.7.3.3 0 .5-.1.7-.3L5 6.4l3.3 3.3c.2.2.5.3.7.3.2 0 .5-.1.7-.3.4-.4.4-1 0-1.4L6.4 5l3.3-3.3c.4-.4.4-1 0-1.4-.4-.4-1-.4-1.4 0L5 3.6 1.7.3C1.3-.1.7-.1.3.3c-.4.4-.4 1 0 1.4L3.6 5 .3 8.3c-.4.4-.4 1 0 1.4z" fill="#000" fill-rule="nonzero"></path></svg><span class="d-inline-block d-sm-none text-white close-text">Close</span></span>
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-body contact-form contact-form-btn">
          <?php gravity_form( $form_cta , true, false, false, null, true ); ?>
        </div>
      </div>
    </div>
  </div>
  <?php endif; ?>
<section data-<?php echo e($block['id']); ?> class="img-text-button">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <h2 class="mb-4 mb-lg-5"><?php echo $title; ?></h2>
      </div>
    </div>
    <div class="row align-items-center  ">
      <div class="col-lg-6 mb-3 mb-lg-0">
        <div>
          <h2 class="h2 mb-4 "><?php echo $subtitle; ?></h2>
          <div class="body-link"><?php echo $body_copy; ?></div>
          <?php if($button_type == 'shortcode'): ?>
            <button class="button-primary mt-2" data-toggle="modal" data-target="#formModal-<?php echo e($form_cta); ?>"><?php echo $button['button_text']; ?></button>
          <?php else: ?>
            <?php if($button['button_link']): ?>
              <a href="<?php echo $button['button_link']; ?>" class="button-primary mt-2"><?php echo $button['button_text']; ?></a>
            <?php endif; ?>
          <?php endif; ?>
        </div>
      </div>
      <div class="col-lg-6">
        <?php if($image_type == "svg"): ?>
          <?php
            echo file_get_contents($image['image'])
          ?>
        <?php else: ?>
          <img src="<?php echo $image['image']; ?>" alt="<?php echo $image['alt']; ?>"
            srcset="<?php echo $image['small'] . $image['medium'] . $image['large']; ?>">
        <?php endif; ?>
      </div>
    </div>
  </div>
</section>
